/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.decoration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPNullCellDecoration;
import com.cognos.xqe.ast.localprocessing.v5.V5ResultCellUpdate;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXRank;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RelocateNestedLevelCalculation;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateRule;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConvertNullCellDecoToCellUpdateDeco
extends Transformation {
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    static final boolean USE_OLD = false;
    static final int LOG_LEVEL = 0;

    public ConvertNullCellDecoToCellUpdateDeco() {
        this.mName = "Converts a NullCell decoration into corresponding entries in CELLUPDATE node.";
        this.mPassNumbers = new int[]{36};
        this.mTypes = new int[]{601015};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] edges;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        OLAPNullCellDecoration nullCellDecoration = (OLAPNullCellDecoration)node;
        int rankEdgeOrdinal = nullCellDecoration.getEdgeOrdinalProperty();
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        RSAPIEdgeRowset rankRowset = (RSAPIEdgeRowset)nullCellDecoration.getRSAPIRowsetProperty();
        int logLevel = 0;
        MDXRank rank = nullCellDecoration.getRankExpression();
        if (rank == null) {
            node.extract();
            return;
        }
        if (logLevel > 0) {
            rank.dumpToXQELogger("<<===ConvertNullCellDecoToCellUpdateDeco===>>");
        }
        int rankSolveOrder = ((MDXCalculatedMemberDefinition)rank.getAncestorOfType(1005)).getSolveOrder();
        this.doLog1(logLevel, "definitionSolveOrder=" + XQEIntegerPool.getInteger(rankSolveOrder).toString());
        AbstractMDXSet rankSet = (AbstractMDXSet)rank.getChild(1);
        MDXLevelInfo rankSetLevelInfo = rankSet.getLevelInfo();
        AbstractXV5CellUpdateRule cellUpdateRule = null;
        this.doLog1(logLevel, "<<===NEW===>>>");
        for (IXQEQueryNode edge : edges = rsapiDataset.getDescendantsOfType(1006, false)) {
            MDXEdge mdxEdge = (MDXEdge)edge;
            XOLAPEdgeMapping xOLAPEdgeMapping = mdxEdge.getXOLAPEdgeMapping();
            this.doLog1(logLevel, "###EdgeOrdinal=" + XQEIntegerPool.getInteger(xOLAPEdgeMapping.getEdgeOrdinal()).toString());
            List<IXQEQueryNode> groups = mdxEdge.getDescendantsOfCategory(1027, false);
            for (IXQEQueryNode group : groups) {
                String intersectingName;
                RSAPIEdgeRowset intersectingRowset;
                CogMDXGroup intersectingGroup;
                block35: {
                    int rankSetLowestLevel;
                    MDXLevelInfo intersectingLevelInfo;
                    boolean intersectingColumnProjCalc;
                    IHierarchy intersectingHierarchy;
                    block36: {
                        boolean intersectingProjectsCurrMember;
                        block37: {
                            boolean hasSingleCalcMUN;
                            MDXCalculatedMemberReference calcReference;
                            block34: {
                                intersectingGroup = (CogMDXGroup)group;
                                if (logLevel > 0) {
                                    intersectingGroup.dumpToXQELogger("###group");
                                }
                                if (intersectingGroup.getRSAPIEdgeRowset() == null) {
                                    this.doLog1(logLevel, "RSAPIEdgeRowset=null");
                                    continue;
                                }
                                if (intersectingGroup.isNestedLevels() && intersectingGroup.isGenerateContextRequired().booleanValue() && intersectingGroup.getNumberChildren() == 1) {
                                    this.doLog1(logLevel, "isNestedLevels() && isGenerateContextRequired && NumberChildren == 1");
                                    continue;
                                }
                                intersectingRowset = intersectingGroup.getRSAPIEdgeRowset();
                                if (intersectingRowset != null && rankRowset != null && rankRowset.getEdge().getOrdinal() == intersectingRowset.getEdge().getOrdinal()) {
                                    this.doLog1(logLevel, "rankEdgeOrdinal == xOLAPEdgeMapping.getEdgeOrdinal()");
                                    continue;
                                }
                                intersectingName = null;
                                intersectingHierarchy = intersectingGroup.getFirstSetHierarchy();
                                this.doLog1(logLevel, "intersectingHierarchy=" + intersectingHierarchy.toString());
                                intersectingColumnProjCalc = false;
                                boolean intersectingNLCReplacement = false;
                                calcReference = this.getFirstProjectedCalculatedMember(intersectingGroup);
                                if (calcReference != null && logLevel > 0) {
                                    calcReference.dumpToXQELogger("calcReference");
                                }
                                hasSingleCalcMUN = false;
                                if (!intersectingGroup.isGenerateContextRequired().booleanValue()) {
                                    this.doLog1(logLevel, "!intersectingGroup.isGenerateContextRequired()");
                                    AbstractOLAPColumn intersectingColumn = intersectingGroup.getFirstAbstractOLAPColumn();
                                    if (intersectingColumn == null) {
                                        this.doLog1(logLevel, "intersectingColumn == null");
                                        continue;
                                    }
                                    if (intersectingColumn.isHierarchyNormalization()) {
                                        this.doLog1(logLevel, "intersectingColumn.isHierarchyNormalization()");
                                        continue;
                                    }
                                    RelocateNestedLevelCalculation rnlCalc = (RelocateNestedLevelCalculation)intersectingColumn.getActionOfTypeForMUN(6, null);
                                    if (rnlCalc != null) {
                                        this.doLog1(logLevel, "rnlCalc != null");
                                    }
                                    if (!intersectingHierarchy.getDimension().isMeasuresDimension() && rnlCalc != null && calcReference != null) {
                                        intersectingHierarchy = (IHierarchy)calcReference.getPropertyValue("originalHierarchy");
                                        this.doLog1(logLevel, "original intersectingHierarchy=" + intersectingHierarchy.toString());
                                    }
                                    intersectingColumnProjCalc = hasSingleCalcMUN = intersectingColumn.getRules().isRulesForCalculations() && intersectingColumn.getRules().hasSingleMUN();
                                    boolean bl = intersectingNLCReplacement = intersectingColumn.getRules().getType() == 7;
                                    if (intersectingNLCReplacement) {
                                        this.doLog1(logLevel, "intersectingNLCReplacement1");
                                    }
                                }
                                if (!intersectingColumnProjCalc) {
                                    this.doLog1(logLevel, "!intersectingColumnProjCalc2");
                                    intersectingColumnProjCalc = calcReference != null;
                                    this.doLog1(logLevel, "!intersectingColumnProjCalc3");
                                }
                                if (rankSetLevelInfo.getHierarchyInfo().projectsHierarchy(intersectingHierarchy)) break block34;
                                this.doLog1(logLevel, "!rankSetLevelInfo.getHierarchyInfo().projectsHierarchy(intersectingHierarchy)");
                                if (intersectingHierarchy.getDimension().isMeasuresDimension() || !intersectingColumnProjCalc && !intersectingNLCReplacement) {
                                    this.doLog1(logLevel, "isMeasuresDimension || (!intersectingColumnProjCalc && !intersectingNLCReplacement)");
                                    continue;
                                }
                                if (intersectingColumnProjCalc) {
                                    this.doLog1(logLevel, "intersectingColumnProjCalc");
                                    if (calcReference != null && intersectingGroup.getFirstRSAPIDataItem().getSolveOrder() < rankSolveOrder) {
                                        this.doLog1(logLevel, "calcReference != null && calcReference.getSolveOrder() < definitionSolveOrder");
                                        continue;
                                    }
                                    intersectingName = "AnyIntersectingCalculationName";
                                    this.doLog1(logLevel, "newXV5CellSpec.ANYCALC1");
                                }
                                break block35;
                            }
                            intersectingLevelInfo = new MDXLevelInfo();
                            rankSetLowestLevel = -1;
                            if (rankSetLevelInfo.getNumProjectedLevels(intersectingHierarchy) > 0) {
                                rankSetLowestLevel = rankSetLevelInfo.getLowestProjectedLevel(intersectingHierarchy).getIndex();
                                this.doLog1(logLevel, "rankSetLevelInfo.getNumProjectedLevels(intersectingHierarchy) > 0");
                            }
                            ArrayList<ILevel> projectedLevelList = new ArrayList<ILevel>();
                            MDXLevelInfo intersectingCogMDXGroupLevelInfo = null;
                            if (!hasSingleCalcMUN) {
                                intersectingCogMDXGroupLevelInfo = ((AbstractMDXSet)intersectingGroup.getChild(0)).getLevelInfo();
                                projectedLevelList.addAll(intersectingCogMDXGroupLevelInfo.getProjectedLevels(intersectingHierarchy));
                            } else {
                                intersectingCogMDXGroupLevelInfo = calcReference.getLevelInfo();
                                projectedLevelList.addAll(intersectingCogMDXGroupLevelInfo.getProjectedLevels(calcReference.getHierarchy()));
                            }
                            intersectingLevelInfo.addProjectedLevels(projectedLevelList);
                            if (!rankSetLevelInfo.projectedLevelsOverlap(intersectingLevelInfo, intersectingHierarchy)) break block36;
                            this.doLog1(logLevel, "rankSetLevelInfo.projectedLevelsOverlap(intersectingLevelInfo, intersectingHierarchy)");
                            intersectingProjectsCurrMember = false;
                            intersectingProjectsCurrMember = intersectingColumnProjCalc ? this.projectsCurrentMember(calcReference.getDefinition().getChild(0)) : this.projectsCurrentMember(intersectingGroup);
                            if (intersectingProjectsCurrMember) {
                                this.doLog1(logLevel, "intersectingProjectsCurrMember");
                            }
                            if (!rankSetLevelInfo.compareProjectedLevels(intersectingLevelInfo, intersectingHierarchy)) break block37;
                            this.doLog1(logLevel, "rankSetLevelInfo.compareProjectedLevels(intersectingLevelInfo, intersectingHierarchy)");
                            if (!intersectingHierarchy.isRagged() || !intersectingProjectsCurrMember) {
                                this.doLog1(logLevel, "!(intersectingHierarchy.isRagged() && intersectingProjectsCurrMember)");
                                continue;
                            }
                            break block35;
                        }
                        int intersectingLowestLevel = intersectingLevelInfo.getLowestProjectedLevel(intersectingHierarchy).getIndex();
                        if (!intersectingColumnProjCalc && !intersectingProjectsCurrMember) {
                            this.doLog1(logLevel, "!intersectingColumnProjCalc && !intersectingProjectsCurrMember");
                            if (rankSetLowestLevel == intersectingLowestLevel) {
                                this.doLog1(logLevel, "rankSetLowestLevel == intersectingLowestLevel");
                                continue;
                            }
                            if (this.isNestingSameHierarchy(intersectingGroup) && rankSetLowestLevel > intersectingLowestLevel) {
                                this.doLog1(logLevel, "isNestingSameHierarchy && rankSetLowestLevel > intersectingLowestLevel");
                                continue;
                            }
                        }
                        if (!intersectingColumnProjCalc) break block35;
                        intersectingName = "AnyIntersectingCalculationName";
                        this.doLog1(logLevel, "newXV5CellSpec.ANYCALC2");
                        break block35;
                    }
                    if (intersectingColumnProjCalc) {
                        intersectingName = "AnyIntersectingCalculationName";
                        this.doLog1(logLevel, "newXV5CellSpec.ANYCALC3");
                    } else if (this.isNestingSameHierarchy(intersectingGroup) || rankSetLowestLevel < intersectingLevelInfo.getHighestProjectedLevel(intersectingHierarchy).getIndex()) {
                        this.doLog1(logLevel, "new bottom continue");
                        continue;
                    }
                }
                if (cellUpdateRule == null) {
                    V5ResultCellUpdate cellUpdateNode = null;
                    int descendantType = 601014;
                    IXQEQueryNode[] nodeCellUpdate = rsapiDataset.getDescendantsOfType(descendantType, false);
                    if (nodeCellUpdate.length == 0) {
                        cellUpdateNode = (V5ResultCellUpdate)nodeFactory.createNode(601014);
                        rsapiDataset.getChild(0).insertParent(cellUpdateNode);
                    } else {
                        cellUpdateNode = (V5ResultCellUpdate)nodeCellUpdate[0];
                    }
                    int nullCellRowSetId = nullCellDecoration.getRSAPIRowsetProperty().getRowsetId();
                    String nullCellV5Name = nullCellDecoration.getV5NameProperty();
                    if (nullCellDecoration.isQueryCalculation()) {
                        nullCellV5Name = null;
                    }
                    this.doLog2(logLevel, "new create cellUpdateRule");
                    this.doLog2(logLevel, "new rankEdgeOrdinal1=" + XQEIntegerPool.getInteger(rankEdgeOrdinal));
                    this.doLog2(logLevel, "new nullCellRowSetId1=" + XQEIntegerPool.getInteger(nullCellRowSetId));
                    this.doLog2(logLevel, "new nullCellDecoration.DataItemOrdinal1=" + XQEIntegerPool.getInteger(nullCellDecoration.getDataItemOrdinal()));
                    this.doLog2(logLevel, "new nullCellV5Name1=" + nullCellV5Name);
                    XV5CellSpec nodeCellSpec = new XV5CellSpec(rankEdgeOrdinal, nullCellRowSetId, nullCellDecoration.getDataItemOrdinal(), nullCellV5Name);
                    cellUpdateRule = new AbstractXV5CellUpdateRule(nodeCellSpec){

                        @Override
                        public boolean apply(ICell cell) {
                            IValue value = (IValue)cell.getValue().copy();
                            cell.setValue(value);
                            value.setNull();
                            return true;
                        }
                    };
                    cellUpdateNode.addCellUpdateRule(cellUpdateRule);
                }
                int intersectingOrdinal = intersectingRowset.getDataItemOrdinal(intersectingGroup.getFirstRSAPIDataItem());
                this.doLog2(logLevel, "new append to cellUpdateRule");
                this.doLog2(logLevel, "new rankEdgeOrdinal2=" + XQEIntegerPool.getInteger(xOLAPEdgeMapping.getEdgeOrdinal()));
                this.doLog2(logLevel, "new nullCellRowSetId2=" + XQEIntegerPool.getInteger(intersectingRowset.getRowsetId()));
                this.doLog2(logLevel, "new nullCellDecoration.DataItemOrdinal2=" + XQEIntegerPool.getInteger(intersectingOrdinal));
                this.doLog2(logLevel, "new nullCellV5Name2=" + intersectingName);
                XV5CellSpec currentCellSpec = new XV5CellSpec(xOLAPEdgeMapping.getEdgeOrdinal(), intersectingRowset.getRowsetId(), intersectingOrdinal, intersectingName);
                cellUpdateRule.addIntersectingCellSpec(currentCellSpec);
            }
        }
        node.extract();
    }

    public void doLog1(int logLevel, String logMessage) {
        if (logLevel == 1) {
            mErrorLogger.log(LogLevel.ERROR, logMessage);
        }
    }

    public void doLog2(int logLevel, String logMessage) {
        if (logLevel == 2) {
            mErrorLogger.log(LogLevel.ERROR, logMessage);
        }
    }

    private boolean isNestingSameHierarchy(CogMDXGroup group) {
        if (group.getNumberChildren() == 1) {
            return false;
        }
        IHierarchy targetHierarchy = group.getFirstSetHierarchy();
        if (((AbstractMDXSet)group.getChild(1)).getHierarchyInfo().projectsHierarchy(targetHierarchy)) {
            this.doLog1(0, "isNestingSameHierarchy1");
            return true;
        }
        return false;
    }

    public boolean projectsCurrentMember(IXQEQueryNode expression) {
        Iterator<IXQEQueryNode> childIt = expression.getChildrenIterator();
        while (childIt.hasNext()) {
            IXQEQueryNode child = childIt.next();
            if (!child.isOfCategory(1039)) continue;
            Iterator<IXQEQueryNode> it = ((AbstractMDXSet)child).getChildrenIterator();
            while (it.hasNext()) {
                if (it.next().getType() != 1076) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode decoNode;
        XQETrace trace = environment.getTrace();
        for (decoNode = node; decoNode != null && decoNode.getDescendantsOfType(1002, false).length <= 0; decoNode = decoNode.getParent()) {
        }
        if (decoNode == null) {
            this.traceNodeCondition(false, "Unable to find the MDXQuery node for this decoration.", trace);
            return false;
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        if (rsapiDataset == null) {
            this.traceNodeCondition(false, "Unable to find the ancestor DataSet node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The decoration node is converted into XCELLUPDATE entries.", trace);
        return true;
    }

    private MDXCalculatedMemberReference getFirstProjectedCalculatedMember(CogMDXGroup intersectingCogMDXGroup) {
        IXQEQueryNode[] calcReferences;
        IHierarchy intersectingHierarchy = intersectingCogMDXGroup.getFirstSetHierarchy();
        for (IXQEQueryNode calcReference : calcReferences = intersectingCogMDXGroup.getDescendantsOfType(1013, false)) {
            if (!intersectingCogMDXGroup.isProjectedDescendant(intersectingCogMDXGroup)) continue;
            if (intersectingCogMDXGroup.getType() == 1080) {
                return (MDXCalculatedMemberReference)calcReference;
            }
            if (!((MDXCalculatedMemberReference)calcReference).getHierarchy().equals(intersectingHierarchy)) continue;
            return (MDXCalculatedMemberReference)calcReference;
        }
        return null;
    }
}

