/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import java.util.ArrayList;
import java.util.List;

public class BuildOLAPColumnForDiffHierNested
extends Transformation {
    public BuildOLAPColumnForDiffHierNested() {
        this.mName = "This transformation builds an OLAPColumn node for a CogMDXGroup nesting a different hierarchy.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1027, 1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        List<AbstractMDXSet> ancestorGroups = null;
        if (BuildXOLAPEdgeMappingUtilities.isGroupNestedUnderOrder(cogMDXGroup)) {
            ancestorGroups = BuildXOLAPEdgeMappingUtilities.getInnerMostOrderedGroup(cogMDXGroup);
        }
        if (ancestorGroups == null) {
            CogMDXGroup ancestorGroup = BuildXOLAPEdgeMappingUtilities.getRaggedCompensationAncestorGroup(cogMDXGroup);
            if (ancestorGroup == null) {
                ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027);
            }
            if (ancestorGroup != null) {
                ancestorGroups = new ArrayList<AbstractMDXSet>();
                ancestorGroups.add(ancestorGroup);
            }
        }
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
        boolean containsCrosstabSpacers = mdxQuery.containsCrosstabSpacersOnEdge(mdxEdge.getEdgeID());
        for (AbstractMDXSet ancestorGroup : ancestorGroups) {
            CogMDXGroup currAncestor;
            CogMDXGroup ancestor = currAncestor = (CogMDXGroup)ancestorGroup;
            IHierarchy ancestorHierarchy = ancestor.getHierarchyInfo().getProjectedHierarchy(0);
            if (ancestor.isGenerateContextRequired().booleanValue() && !ancestor.isCustomMemberQuery()) {
                while (cogMDXGroup.getFirstSetHierarchy().equals(ancestorHierarchy)) {
                    ancestor = (CogMDXGroup)ancestor.getAncestorOfCategory(1027);
                    ancestorHierarchy = ancestor.getHierarchyInfo().getProjectedHierarchy(0);
                }
            }
            if (ancestor.getPropertyValue("firstCurrentMemberOfCalc") != Boolean.TRUE && ancestor.getRSAPIDataItemList() == null && !ancestor.isGenerateContextRequired().booleanValue() && (BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(ancestor) || BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(ancestor) || ancestor.isNonDetailGroupBodyValue() || CalcMemberReferencePrefixes.isNormalizationMeasure(currAncestor.getChild(0)))) {
                CogMDXGroup grandAncestor;
                BuildXOLAPEdgeMappingUtilities.createHierarchyNormalizationOLAPColumn(ancestor, mdxEdge, edgeElementFactory);
                if (!containsCrosstabSpacers && BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(ancestor) && (grandAncestor = (CogMDXGroup)ancestor.getAncestorOfCategory(1027)) != null && grandAncestor.getFirstSetHierarchy().equals(ancestorHierarchy) && !grandAncestor.getGenerateProjCurrentMember() && !ancestor.getGenerateProjCurrentMember()) {
                    this.turnOffHierNormalizationSetRowsetInfo(cogMDXGroup, ancestor, grandAncestor);
                }
                return;
            }
            AbstractOLAPRow row = null;
            BuildXOLAPEdgeMappingUtilities.createAbstractOLAPColumn(2, ancestor, mdxEdge, edgeElementFactory, -1, ancestor.getFirstRSAPIDataItem(), row);
            if (ancestor.getPropertyValue("firstCurrentMemberOfCalc") != Boolean.TRUE) continue;
            CogMDXGroup grandAncestor = (CogMDXGroup)ancestor.getAncestorOfCategory(1027);
            this.turnOffHierNormalizationSetRowsetInfo(cogMDXGroup, ancestor, grandAncestor);
        }
    }

    private void turnOffHierNormalizationSetRowsetInfo(CogMDXGroup cogMDXGroup, CogMDXGroup ancestor, CogMDXGroup grandAncestor) {
        ancestor.getFirstAbstractOLAPColumn().setHierarchyNormalization(false);
        ancestor.getFirstAbstractOLAPColumn().setRowset(grandAncestor.getRSAPIEdgeRowset());
        ancestor.getFirstAbstractOLAPColumn().setDataItemIndex(grandAncestor.getFirstRSAPIDataItem());
        ancestor.getFirstAbstractOLAPColumn().setDataitemIndixesProjectingSameSet(cogMDXGroup.getDataItemIndexesProjectingSameSet());
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (cogMDXGroup.isGenerateContextRequired().booleanValue() && cogMDXGroup.getNumberChildren() > 1 && ((AbstractMDXSet)cogMDXGroup.getChild(1)).getHierarchyInfo().getProjectedHierarchy(0).equals(cogMDXGroup.getFirstSetHierarchy())) {
            this.traceQueryCondition(false, "The target CogMDXGroup is context generated at run time.", trace);
            return false;
        }
        if (cogMDXGroup.getAbstractOLAPColumnList() == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup has not an associated AbstractOLAPColumn.", trace);
            return false;
        }
        if (cogMDXGroup.getFirstAbstractOLAPColumn().getParentRow() == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup has not an associated AbstractOLAPRow.", trace);
            return false;
        }
        if (cogMDXGroup.getFirstAbstractOLAPColumn().getParentRow().isCycle()) {
            this.traceQueryCondition(false, "The target CogMDXGroup has an associated OLAPRowCycle.", trace);
            return false;
        }
        if (cogMDXGroup.getParent().getType() == 1039) {
            this.traceQueryCondition(false, "The target CogMDXGroup is within an MDXSet.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        if (cogMDXGroup.getChild(0).getType() == 1113) {
            this.traceNodeCondition(false, "The target cogMDXGroup projects a TNodeUnbCompensation node.", trace);
            return false;
        }
        IHierarchy cogMDXGroupHierarchy = cogMDXGroup.getHierarchyInfo().getProjectedHierarchy(0);
        if (cogMDXGroup.isTopWithinUnbCompCrossjoin()) {
            this.traceNodeCondition(false, "The target cogMDXGroup is under a TNodeUnbCompensation's crossjoin.", trace);
            return false;
        }
        if (cogMDXGroup.getChild(0).getType() == 1145) {
            this.traceNodeCondition(false, "The target CogMDXGroup projects an empty set.", trace);
            return false;
        }
        List<AbstractMDXSet> ancestorSets = null;
        boolean sortCase = false;
        if (BuildXOLAPEdgeMappingUtilities.isGroupNestedUnderOrder(cogMDXGroup) && (ancestorSets = BuildXOLAPEdgeMappingUtilities.getInnerMostOrderedGroup(cogMDXGroup)) == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "ancestorGroup?");
        }
        if (ancestorSets == null) {
            CogMDXGroup ancestorGroup = BuildXOLAPEdgeMappingUtilities.getRaggedCompensationAncestorGroup(cogMDXGroup);
            if (ancestorGroup == null) {
                ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027);
            }
            if (ancestorGroup != null) {
                ancestorSets = new ArrayList<AbstractMDXSet>();
                ancestorSets.add(ancestorGroup);
            }
        }
        String noAncestors = "The required ancestor CogMDXGroup could not be found.";
        if (ancestorSets == null) {
            this.traceQueryCondition(false, "The required ancestor CogMDXGroup could not be found.", trace);
            return false;
        }
        for (AbstractMDXSet ancestorSet : ancestorSets) {
            AbstractOLAPColumn ancestorColumn = ancestorSet.getFirstAbstractOLAPColumn();
            if (ancestorColumn != null) {
                this.traceNodeCondition(false, "The ancestor CogMDXGroup has an associated AbstractOLAPColumn.", trace);
                return false;
            }
            if (!ancestorSet.isOfCategory(1027)) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!CogMDXGroup");
            }
            CogMDXGroup currAncestor = (CogMDXGroup)ancestorSet;
            if (ancestorSet.getChild(0).getType() == 1145) {
                this.traceNodeCondition(false, "The ancestor CogMDXGroup projects an empty set.", trace);
                return false;
            }
            if (currAncestor.getRSAPIDataItemList() == null) {
                String property = "nestingDepthOfContextForProperty";
                if (currAncestor.getPropertyValue("nestingDepthOfContextForProperty") != null) {
                    this.traceNodeCondition(true, "The ancestor CogMDXGroup was created by RemoveAndPropagateMDXPropertiesScopeSet.", trace);
                    return true;
                }
                if ((BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(currAncestor) || BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(currAncestor)) && !cogMDXGroupHierarchy.equals(currAncestor.getFirstSetHierarchy())) {
                    this.traceNodeCondition(true, "The ancestor CogMDXGroup is a hierarchy normalization set.", trace);
                    return true;
                }
                if (currAncestor.isNonDetailGroupBodyValue() || currAncestor.isNonDetailGroupBodyTag()) {
                    this.traceNodeCondition(true, "The ancestor CogMDXGroup is a groupbody measure group.", trace);
                    return true;
                }
                if (CalcMemberReferencePrefixes.isNormalizationMeasure(currAncestor.getChild(0))) {
                    this.traceNodeCondition(true, "The ancestor CogMDXGroup is a normalization measure set.", trace);
                    return true;
                }
                this.traceNodeCondition(false, "The ancestor CogMDXGroup has not RSAPI information.", trace);
                return false;
            }
            if (!sortCase) {
                IHierarchy currAncestorHier;
                if (cogMDXGroupHierarchy == null && cogMDXGroup.getType() == 1080) {
                    cogMDXGroupHierarchy = cogMDXGroup.getHierarchyInfo().getProjectedHierarchy(0);
                }
                if ((currAncestorHier = currAncestor.getFirstSetHierarchy()) == null && currAncestor.getType() == 1080) {
                    currAncestorHier = currAncestor.getHierarchyInfo().getProjectedHierarchy(0);
                }
                if (cogMDXGroupHierarchy.equals(currAncestorHier)) {
                    if (currAncestor.isGenerateContextRequired().booleanValue() && (currAncestor.getNumberChildren() == 1 || ((AbstractMDXSet)currAncestor.getChild(1)).getHierarchyInfo().getProjectedHierarchy(0).equals(cogMDXGroupHierarchy))) {
                        CogMDXGroup prevAncestor = currAncestor;
                        while (cogMDXGroup.getFirstSetHierarchy().equals(currAncestor.getFirstSetHierarchy())) {
                            if ((currAncestor = (CogMDXGroup)currAncestor.getAncestorOfCategory(1027)) == null) {
                                this.traceQueryCondition(false, "The required ancestor CogMDXGroup could not be found.", trace);
                                return false;
                            }
                            if (prevAncestor.getParent() != null && prevAncestor.getParent().getType() == 1039) {
                                this.traceQueryCondition(false, "The required ancestor CogMDXGroup could not be found.", trace);
                                return false;
                            }
                            prevAncestor = currAncestor;
                        }
                    } else {
                        this.traceNodeCondition(false, "Target CogMDXGroup projects the same hierarchy as the ancestor CogMDXGroup.", trace);
                        return false;
                    }
                }
            }
            AbstractOLAPColumn detailGroupFirstColumn = null;
            if (currAncestor.getType() == 1080) {
                AbstractMDXSet detailExpr = (AbstractMDXSet)((CogMDXReportSummary)currAncestor).getDetailExpr();
                String reason = "The detail set for the ancestor CogMDXReportSummary has not an AbstractOLAPColumn.";
                if (detailExpr.getType() == 1027) {
                    CogMDXGroup detailGroup = (CogMDXGroup)detailExpr;
                    if (!(detailGroup.isGenerateContextRequired().booleanValue() || (detailGroupFirstColumn = detailGroup.getFirstAbstractOLAPColumn()) != null && detailGroupFirstColumn.getParentRow() != null)) {
                        this.traceQueryCondition(false, "The detail set for the ancestor CogMDXReportSummary has not an AbstractOLAPColumn.", trace);
                        return false;
                    }
                } else {
                    AbstractMDXSet detailSet = (AbstractMDXSet)((CogMDXReportSummary)currAncestor).getDetailExpr();
                    List<IXQEQueryNode> groups = detailSet.getDescendantsOfCategoryOrdered(1027, false);
                    for (IXQEQueryNode group : groups) {
                        CogMDXGroup currGroup = (CogMDXGroup)group;
                        if (currGroup != detailSet && currGroup.getAncestorOfCategory(1027) != detailSet || (detailGroupFirstColumn = currGroup.getFirstAbstractOLAPColumn()) != null && detailGroupFirstColumn.getParentRow() != null) continue;
                        this.traceQueryCondition(false, "The detail set for the ancestor CogMDXReportSummary has not an AbstractOLAPColumn.", trace);
                        return false;
                    }
                }
            }
            if (currAncestor.getChild(0).getType() == 1113) {
                this.traceNodeCondition(false, "The ancestor set projects a TNodeUnbCompensation node.", trace);
                return false;
            }
            if (currAncestor.getFirstAbstractOLAPColumn() != null) {
                this.traceNodeCondition(false, "The ancestor CogMDXGroup has an associated AbstractOLAPColumn..", trace);
                return false;
            }
            boolean doesPathSplitsUnderCurrAncestor = false;
            if (currAncestor.getNumberChildren() > 1) {
                AbstractMDXSet currAncestorSecondChild = (AbstractMDXSet)currAncestor.getChild(1);
                if (currAncestorSecondChild.getType() == 1004) {
                    currAncestorSecondChild = (AbstractMDXSet)currAncestorSecondChild.getChild(0);
                }
                doesPathSplitsUnderCurrAncestor = BuildOLAPColumnForDiffHierNested.doesPathSplitsOnThisSet(currAncestorSecondChild);
            }
            if (!doesPathSplitsUnderCurrAncestor) continue;
            this.traceNodeCondition(false, "BuildOLAPRowCycleForDiffHierNested should be applied instead.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The ancestor CogMDXGroup has not an associated AbstractOLAPColumn.", trace);
        return true;
    }

    private static boolean doesPathSplitsOnThisSet(AbstractMDXSet set) {
        boolean doesPathSplitsUnderCurrAncestor = false;
        if (!set.isOfCategory(1027)) {
            doesPathSplitsUnderCurrAncestor = set.isOfCategory(1030) || set.isOfCategory(1058) ? BuildOLAPColumnForDiffHierNested.doesPathSplitsOnThisSet((AbstractMDXSet)set.getChild(0)) : true;
        }
        return doesPathSplitsUnderCurrAncestor;
    }
}

