/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildOLAPRowForInnermost;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import java.util.ArrayList;
import java.util.List;

public class BuildOLAPRowCycleForDiffHierNested
extends Transformation {
    private static final int GROUP_NESTING_DIFF_HIER_GROUP = 4;
    private static final int GROUP_NESTING_SAME_HIER_GROUP = 3;
    private static final int GROUP_NESTING_MDXCROSJOIN = 2;
    private static final int GROUP_NESTING_MDXSET = 1;
    private static final String TRACE_MESSAGE = "The target CogMDXGroup is the first child of an MDXCrossjoin.";

    public BuildOLAPRowCycleForDiffHierNested() {
        this.mName = "This transformation builds an OLAPRowCycle node for a CogMDXGroup nesting a different hierarchy.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1027, 1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup ancestorGroup;
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        XOLAPEdgeMapping xOLAPEdgeMapping = mdxEdge.getXOLAPEdgeMapping();
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        OLAPRowCycle rowCycle = BuildXOLAPEdgeMappingUtilities.createRowCycle(xOLAPEdgeMapping, edgeElementFactory);
        BuildXOLAPEdgeMappingUtilities.createAbstractOLAPColumn(3, cogMDXGroup, mdxEdge, edgeElementFactory, -1, cogMDXGroup.getFirstRSAPIDataItem(), rowCycle);
        List<AbstractMDXSet> ancestorGroups = null;
        if (BuildXOLAPEdgeMappingUtilities.isGroupNestedUnderOrder(cogMDXGroup)) {
            ancestorGroups = BuildXOLAPEdgeMappingUtilities.getInnerMostOrderedGroup(cogMDXGroup);
        }
        if (ancestorGroups == null && (ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027)) != null) {
            ancestorGroups = new ArrayList<AbstractMDXSet>();
            ancestorGroups.add(ancestorGroup);
        }
        if (ancestorGroups == null) {
            xOLAPEdgeMapping.addRow(rowCycle, false);
        } else {
            for (AbstractMDXSet ancestorGroup2 : ancestorGroups) {
                AbstractOLAPColumn ancestorColumn = ancestorGroup2.getFirstAbstractOLAPColumn();
                if (ancestorColumn == null) continue;
                if (!ancestorColumn.getParentRow().isCycle()) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!ancestorColumn.getParentRow().isCycle()");
                }
                OLAPRowCycle ancestorRowCycle = (OLAPRowCycle)ancestorColumn.getParentRow();
                ancestorRowCycle.addRow(rowCycle, false);
            }
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCrossjoin mdxCrossjoin;
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        if (cogMDXGroup.getAbstractOLAPColumnList() != null) {
            this.traceNodeCondition(false, "This transformation was applied already.", trace);
            return false;
        }
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (!mdxEdge.isProjectedDescendant(cogMDXGroup)) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not projected by its ancestor MDXEdge node.", trace);
            return false;
        }
        if (cogMDXGroup.getParent().getType() == 1030 && cogMDXGroup.getParent().getChild(0) == cogMDXGroup && cogMDXGroup.getParent().getChild(1).getType() == 1027 && (mdxCrossjoin = (MDXCrossjoin)cogMDXGroup.getParent()).getParent().getType() == 1027 && mdxCrossjoin.getParent().getNumberChildren() == 2 && mdxCrossjoin.getParent().getChild(1) == mdxCrossjoin) {
            this.traceQueryCondition(false, TRACE_MESSAGE, trace);
            return false;
        }
        if (cogMDXGroup.getNumberChildren() == 1) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not nesting a set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup detailGroup;
        IXQEQueryNode detailExpr;
        boolean result;
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        if (cogMDXGroup.getHierarchyInfo().getNumProjectedHierarchies() == 1) {
            this.traceNodeCondition(false, "The target CogMDXGroup projects a single hierarchy.", trace);
            return false;
        }
        if (cogMDXGroup.getChild(0).getType() == 1145) {
            this.traceNodeCondition(false, "The target CogMDXGroup projects an empty set.", trace);
            return false;
        }
        if (cogMDXGroup.isTopWithinUnbCompCrossjoin()) {
            this.traceNodeCondition(false, "The target cogMDXGroup is under a TNodeUnbCompensation's crossjoin.", trace);
            return false;
        }
        List<AbstractMDXSet> ancestorGroups = null;
        if (BuildXOLAPEdgeMappingUtilities.isGroupNestedUnderOrder(cogMDXGroup)) {
            ancestorGroups = BuildXOLAPEdgeMappingUtilities.getInnerMostOrderedGroup(cogMDXGroup);
        }
        if (ancestorGroups == null) {
            Object ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027);
            ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027);
            if (ancestorGroup != null) {
                ancestorGroups = new ArrayList<AbstractMDXSet>();
                ancestorGroups.add((AbstractMDXSet)ancestorGroup);
            }
        }
        if (ancestorGroups != null) {
            for (AbstractMDXSet ancestorGroup : ancestorGroups) {
                boolean isHierNormalizationGroup;
                CogMDXGroup currAncestor = (CogMDXGroup)ancestorGroup;
                if (currAncestor.getRSAPIDataItemList() != null) continue;
                boolean notPassing = true;
                String property = "nestingDepthOfContextForProperty";
                if (ancestorGroup.getPropertyValue("nestingDepthOfContextForProperty") != null) {
                    String reason = "The ancestor CogMDXGroup was created by RemoveAndPropagateMDXPropertiesScopeSet.";
                    this.traceNodeCondition(true, "The ancestor CogMDXGroup was created by RemoveAndPropagateMDXPropertiesScopeSet.", trace);
                    notPassing = false;
                }
                boolean bl = isHierNormalizationGroup = BuildXOLAPEdgeMappingUtilities.isDefaultMemberHierNormalizationGroup(currAncestor) || BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(currAncestor);
                if (notPassing && isHierNormalizationGroup && !cogMDXGroup.getHierarchyInfo().getProjectedHierarchy(0).equals(ancestorGroup.getHierarchyInfo().getProjectedHierarchy(0))) {
                    this.traceNodeCondition(true, "The ancestor CogMDXGroup is a hierarchy normalization set.", trace);
                    notPassing = false;
                }
                if (notPassing && currAncestor.isNonDetailGroupBodyValue() || currAncestor.isNonDetailGroupBodyTag()) {
                    this.traceNodeCondition(true, "The ancestor CogMDXGroup is a groupbody measure group.", trace);
                    notPassing = false;
                }
                if (!notPassing) continue;
                this.traceNodeCondition(false, "The ancestor CogMDXGroup has not RSAPI information.", trace);
                return false;
            }
        }
        if ((result = BuildOLAPRowCycleForDiffHierNested.nodeCondition(traceMsg, cogMDXGroup)) && cogMDXGroup.isOfCategory(1080) && (detailExpr = ((CogMDXReportSummary)cogMDXGroup).getDetailExpr()) != null && detailExpr.getType() == 1027 && !(detailGroup = (CogMDXGroup)detailExpr).isGenerateContextRequired().booleanValue() && (detailGroup.getFirstAbstractOLAPColumn() == null || detailGroup.getFirstAbstractOLAPColumn().getParentRow() == null)) {
            this.traceNodeCondition(false, "The detail CogMDXGroup for the target CogMDXReportSummary is not ready.", trace);
            return false;
        }
        if (result && BuildOLAPRowForInnermost.isNotProjectedWithinHeadSuppression(cogMDXGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup is not projected.", trace);
            return false;
        }
        this.traceNodeCondition(result, traceMsg.toString(), trace);
        return result;
    }

    public static boolean nodeCondition(StringBuilder traceMsg, CogMDXGroup cogMDXGroup) {
        AbstractMDXSet secondChild = (AbstractMDXSet)cogMDXGroup.getChild(1);
        return BuildOLAPRowCycleForDiffHierNested.passNestedNodeCondition(traceMsg, cogMDXGroup, secondChild);
    }

    private static boolean passNestedNodeCondition(StringBuilder traceMsg, CogMDXGroup cogMDXGroup, AbstractMDXSet secondChild) {
        String notNestingDifferentHierarchy = "The target CogMDXGroup is not nesting a set of a different hierarchy.";
        String nestingDifferentHierarchy = "Target is nesting a different hierarchy set with multiple paths.";
        if (secondChild.isOfCategory(1027)) {
            CogMDXGroup nestedGroup = (CogMDXGroup)secondChild;
            if (cogMDXGroup.getFirstSetHierarchy().equals(nestedGroup.getFirstSetHierarchy())) {
                traceMsg.append("The target CogMDXGroup is not nesting a set of a different hierarchy.");
                return false;
            }
            ArrayList<CogMDXGroup> innerMostGroups = new ArrayList<CogMDXGroup>();
            if (nestedGroup.isGenerateContextRequired().booleanValue()) {
                BuildOLAPRowCycleForDiffHierNested.collectSameHierarchyInnermosGroups(nestedGroup, innerMostGroups);
            } else {
                innerMostGroups.add(nestedGroup);
            }
            int emptySetCount = 0;
            String notApplicable = "The transformation is not applicable";
            for (CogMDXGroup innerMostGroup : innerMostGroups) {
                boolean edgeMappingDone;
                if (innerMostGroup.getChild(0).getType() == 1145) {
                    ++emptySetCount;
                    continue;
                }
                boolean bl = edgeMappingDone = innerMostGroup.getAbstractOLAPColumnList() != null && innerMostGroup.getFirstAbstractOLAPColumn().getParentRow() != null;
                if (!edgeMappingDone) {
                    traceMsg.append(notApplicable);
                    return false;
                }
                boolean diffHierarchySplits = innerMostGroup.getFirstAbstractOLAPColumn().getParentRow().isCycle() || innerMostGroups.size() > 1;
                if (diffHierarchySplits) continue;
                traceMsg.append(notApplicable);
                return false;
            }
            if (emptySetCount == innerMostGroups.size()) {
                traceMsg.append(notApplicable);
                return false;
            }
            traceMsg.append("Target is nesting a different hierarchy set with multiple paths.");
            return true;
        }
        if (cogMDXGroup.getFirstSetHierarchy().equals(secondChild.getHierarchyInfo().getProjectedHierarchy(0))) {
            traceMsg.append("The target CogMDXGroup is not nesting a set of a different hierarchy.");
            return false;
        }
        if (secondChild.getType() == 1039) {
            List<IXQEQueryNode> descendantSets = secondChild.getDescendantsOfCategory(1021, false);
            int descendantcount = 0;
            for (IXQEQueryNode descendantSet : descendantSets) {
                AbstractMDXSet decAbstractMDXSet = (AbstractMDXSet)descendantSet;
                CogMDXGroup ancestorGroup = (CogMDXGroup)decAbstractMDXSet.getAncestorOfCategory(1027);
                if (ancestorGroup != cogMDXGroup) continue;
                ++descendantcount;
            }
            if (descendantcount > 0) {
                traceMsg.append("The target CogMDXGroup is nesting an MDXSet of CogMDXGroup objects.");
                return true;
            }
        } else {
            if (secondChild.getType() == 1057 && secondChild.getChild(0).getType() == 1058) {
                return BuildOLAPRowCycleForDiffHierNested.passNestedNodeCondition(traceMsg, cogMDXGroup, (AbstractMDXSet)secondChild.getChild(0).getChild(0));
            }
            if (secondChild.getType() == 1030 && secondChild.getChild(0).getType() == 1058) {
                return BuildOLAPRowCycleForDiffHierNested.passNestedNodeCondition(traceMsg, cogMDXGroup, (AbstractMDXSet)secondChild.getChild(0).getChild(0));
            }
            if (secondChild.getType() == 1030 && secondChild.getChild(0).getType() == 1027 && secondChild.getChild(1).getType() == 1027) {
                return BuildOLAPRowCycleForDiffHierNested.passNestedNodeCondition(traceMsg, cogMDXGroup, (AbstractMDXSet)secondChild.getChild(0));
            }
            if (secondChild.getType() == 1058) {
                return BuildOLAPRowCycleForDiffHierNested.passNestedNodeCondition(traceMsg, cogMDXGroup, (AbstractMDXSet)secondChild.getChild(0));
            }
            if (secondChild.getType() == 1015 || secondChild.getType() == 1145) {
                return false;
            }
            if (secondChild.getType() == 1004) {
                return BuildOLAPRowCycleForDiffHierNested.passNestedNodeCondition(traceMsg, cogMDXGroup, (AbstractMDXSet)secondChild.getChild(0));
            }
            StringBuilder sb = new StringBuilder("Unexpected secondChild instanceof ");
            sb.append(secondChild.getClass().getSimpleName());
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, sb.toString());
        }
        traceMsg.append("The target CogMDXGroup is not nesting a set of a different hierarchy.");
        return false;
    }

    private static void collectSameHierarchyInnermosGroups(CogMDXGroup nestedGroup, List<CogMDXGroup> innerMostGroups) {
        boolean keepLooping = true;
        while (keepLooping) {
            if (nestedGroup.getNumberChildren() == 1) {
                innerMostGroups.add(nestedGroup);
                keepLooping = false;
                continue;
            }
            int status = BuildOLAPRowCycleForDiffHierNested.collectSameHierarchyInnermosGroupsHelper(nestedGroup.getChild(1), nestedGroup, innerMostGroups);
            if (status == 1) {
                return;
            }
            if (status == 2) {
                return;
            }
            if (status == 3) {
                nestedGroup = (CogMDXGroup)nestedGroup.getChild(1);
                continue;
            }
            if (status != 4) continue;
            innerMostGroups.add(nestedGroup);
            keepLooping = false;
        }
    }

    private static int collectSameHierarchyInnermosGroupsHelper(IXQEQueryNode targetNode, CogMDXGroup ancestorGroup, List<CogMDXGroup> innerMostGroups) {
        if (targetNode.getType() == 1039) {
            IXQEQueryNode[] nodes;
            for (IXQEQueryNode node : nodes = targetNode.getChildren()) {
                if (node.isOfCategory(1027)) {
                    BuildOLAPRowCycleForDiffHierNested.collectSameHierarchyInnermosGroups((CogMDXGroup)node, innerMostGroups);
                    continue;
                }
                if (node.getType() == 1083 && node.getChild(0).getType() == 1027) {
                    BuildOLAPRowCycleForDiffHierNested.collectSameHierarchyInnermosGroupsHelper(node.getChild(0), ancestorGroup, innerMostGroups);
                    continue;
                }
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "node?");
            }
            return 1;
        }
        if (ancestorGroup != null && ancestorGroup.getType() == 1027 && targetNode.getType() == 1030) {
            IXQEQueryNode[] nestedGroups;
            if (targetNode.getChild(0).getType() != 1058) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "targetNode.getChild(0)?");
            }
            CogMDXGroup parentGroup = (CogMDXGroup)targetNode.getParent();
            for (IXQEQueryNode currGrp : nestedGroups = targetNode.getChild(0).getDescendantsOfType(1027, true)) {
                CogMDXGroup nestedGrp = (CogMDXGroup)currGrp;
                if (!nestedGrp.isProjectedDescendant(parentGroup)) continue;
                innerMostGroups.add(nestedGrp);
            }
            return 2;
        }
        if (targetNode.isOfCategory(1027)) {
            CogMDXGroup currGroup = (CogMDXGroup)targetNode;
            if (ancestorGroup.getFirstSetHierarchy().equals(currGroup.getFirstSetHierarchy())) {
                return 3;
            }
            innerMostGroups.add(ancestorGroup);
            return 4;
        }
        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "targetNode?");
    }
}

