/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildOLAPRowForInnermost;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import java.util.ArrayList;
import java.util.List;

public class BuildOLAPRowForInnermostNestedLevelCalc
extends Transformation {
    public BuildOLAPRowForInnermostNestedLevelCalc() {
        this.mName = "This transformation builds an OLAPRow node for an innermost CogMDXGroup projecting a nested level calculation.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1027, 1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        CogMDXGroup ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027);
        ArrayList<MDXCalculatedMemberReference> nestedLevelCalculations = new ArrayList<MDXCalculatedMemberReference>();
        AbstractMDXSet groupSet = (AbstractMDXSet)cogMDXGroup.getChild(0);
        IHierarchy hierarchy = cogMDXGroup.getHierarchyInfo().getProjectedHierarchy(0);
        BuildXOLAPEdgeMappingUtilities.findNestedLevelCalculations(groupSet, nestedLevelCalculations, hierarchy);
        CogMDXGroup originalCogMDXGroup = ((MDXCalculatedMemberReference)nestedLevelCalculations.get(0)).getOriginalGroupForNLC();
        List<RSAPIDataItem> rsapiDataItemList = originalCogMDXGroup.getRSAPIDataItemList();
        RSAPIEdgeRowset aRowset = originalCogMDXGroup.getRSAPIEdgeRowset();
        int rsapiDataItemIdx = -1;
        for (MDXCalculatedMemberReference nestedLevelCalcRef : nestedLevelCalculations) {
            if (originalCogMDXGroup != nestedLevelCalcRef.getOriginalGroupForNLC()) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "originalCogMDXGroup != nestedLevelCalcRef.getOriginalGroupForNLC()");
            }
            RSAPIDataItem rsapiDataItem = rsapiDataItemList.get(++rsapiDataItemIdx);
            OLAPRow row = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
            AbstractMDXNode nestedLevelCalcRefParent = (AbstractMDXNode)nestedLevelCalcRef.getParent();
            if (nestedLevelCalcRefParent.getType() != 1069) {
                BuildXOLAPEdgeMappingUtilities.createAbstractOLAPColumn(cogMDXGroup, mdxEdge, edgeElementFactory, aRowset, nestedLevelCalcRef, rsapiDataItem, row);
            } else {
                IXQEQueryNode[] tupleMembers;
                for (IXQEQueryNode tupleMember : tupleMembers = nestedLevelCalcRefParent.getChildren()) {
                    if (tupleMember.getType() == 1013) {
                        MDXCalculatedMemberReference mdxCalcRef = (MDXCalculatedMemberReference)tupleMember;
                        if (mdxCalcRef.isNestedLevelCalcRef()) {
                            BuildXOLAPEdgeMappingUtilities.createAbstractOLAPColumn(cogMDXGroup, mdxEdge, edgeElementFactory, aRowset, nestedLevelCalcRef, rsapiDataItem, row);
                        } else {
                            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!mdxCalcRef.isNestedLevelCalcRef()");
                        }
                    }
                    if (tupleMember.getType() != 1076 && tupleMember.getType() != 1077) continue;
                    AbstractMDXMember abstractMDXMember = (AbstractMDXMember)tupleMember;
                    AbstractOLAPColumn hierNormalizationColumn = BuildXOLAPEdgeMappingUtilities.createHierarchyNormalizationOLAPColumn(abstractMDXMember, mdxEdge, edgeElementFactory);
                    row.addColumn(hierNormalizationColumn, true);
                }
            }
            if (ancestorGroup == null) continue;
            AbstractOLAPColumn ancestorColumn = ancestorGroup.getFirstAbstractOLAPColumn();
            if (ancestorColumn != null) {
                if (!ancestorColumn.getParentRow().isCycle()) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!ancestorColumn.getParentRow().isCycle()");
                }
                OLAPRowCycle ancestorRowCycle = (OLAPRowCycle)ancestorColumn.getParentRow();
                ancestorRowCycle.addRow(row, false);
                continue;
            }
            if (!BuildXOLAPEdgeMappingUtilities.isCurrentMemberHierNormalizationGroup(ancestorGroup)) continue;
            ancestorColumn = BuildXOLAPEdgeMappingUtilities.createHierarchyNormalizationOLAPColumn(ancestorGroup, mdxEdge, edgeElementFactory);
            row.addColumn(ancestorColumn, false);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup detailGroup;
        IXQEQueryNode detailExpr;
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (cogMDXGroup.getAbstractOLAPColumnList() != null) {
            this.traceNodeCondition(false, "This trasformation was applied already.", trace);
            return false;
        }
        if (cogMDXGroup.getNumberChildren() > 1) {
            this.traceQueryCondition(false, "The target CogMDXGroup is nesting a set.", trace);
            return false;
        }
        if (!mdxEdge.isProjectedDescendant(cogMDXGroup)) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not projected by its ancestor MDXEdge node.", trace);
            return false;
        }
        String traceMsg1 = "The detail set for this CogMDXReportSummary has not an AbstractOLAPColumn and an AbstractOLAPRow.";
        if (cogMDXGroup.getType() == 1080 && (detailExpr = ((CogMDXReportSummary)cogMDXGroup).getDetailExpr()) != null && detailExpr.getType() == 1027 && (detailGroup = (CogMDXGroup)((CogMDXReportSummary)cogMDXGroup).getDetailExpr()) != null) {
            AbstractOLAPColumn detailGroupColumn = detailGroup.getFirstAbstractOLAPColumn();
            if (detailGroupColumn == null) {
                List<IXQEQueryNode> nestedGroups = detailGroup.getDescendantsOfCategory(1027, false);
                for (IXQEQueryNode nestedGroup : nestedGroups) {
                    CogMDXGroup nGroup = (CogMDXGroup)nestedGroup;
                    if (!detailGroup.isProjectedDescendant(nGroup)) continue;
                    detailGroupColumn = nGroup.getFirstAbstractOLAPColumn();
                    if (detailGroupColumn != null && detailGroupColumn.doesActionTypeApplies(2)) break;
                    detailGroupColumn = null;
                }
            }
            if (detailGroupColumn == null || detailGroupColumn.getParentRow() == null) {
                this.traceQueryCondition(false, traceMsg1, trace);
                return false;
            }
        }
        if (BuildOLAPRowForInnermost.isSummaryProjectingMultiHierarchyTuple(cogMDXGroup)) {
            this.traceQueryCondition(false, "Target CogMDXGroup projects a tuple of multiple hierarchies", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IHierarchy hierarchy;
        ArrayList<MDXCalculatedMemberReference> nestedLevelCalculations;
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        AbstractMDXSet groupSet = (AbstractMDXSet)cogMDXGroup.getChild(0);
        int foundNLC = BuildXOLAPEdgeMappingUtilities.findNestedLevelCalculations(groupSet, nestedLevelCalculations = new ArrayList<MDXCalculatedMemberReference>(), hierarchy = cogMDXGroup.getHierarchyInfo().getProjectedHierarchy(0));
        if (foundNLC != 1) {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
            return false;
        }
        CogMDXGroup originalCogMDXGroup = ((MDXCalculatedMemberReference)nestedLevelCalculations.get(0)).getOriginalGroupForNLC();
        if (originalCogMDXGroup == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "originalCogMDXGroup == null");
        }
        List<RSAPIDataItem> rsapiDataItemList = originalCogMDXGroup.getRSAPIDataItemList();
        RSAPIEdgeRowset aRowset = originalCogMDXGroup.getRSAPIEdgeRowset();
        if (rsapiDataItemList == null) {
            this.traceNodeCondition(false, "The target CogMDXGroup  has no RSAPIRefDataItemList.", trace);
            return false;
        }
        if (aRowset == null) {
            this.traceNodeCondition(false, "The target CogMDXGroup  has no aRowset.", trace);
            return false;
        }
        if (BuildOLAPRowForInnermost.isNotProjectedWithinHeadSuppression(cogMDXGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup is not projected.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation is applicable.", trace);
        return true;
    }
}

