/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.actions.RelocateNestedLevelCalculation;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildOLAPRowForInnermost;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BuildOLAPRowForInnermostReportSummaryWithMultiHierTuple
extends Transformation {
    public BuildOLAPRowForInnermostReportSummaryWithMultiHierTuple() {
        this.mName = "Builds an OLAPRow node for an innermost CogMDXReportSummary projecting a tuple of multiple hierarchies.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXReportSummary cogMDXReportSummary = (CogMDXReportSummary)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXReportSummary.getAncestorOfType(1006);
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        List<RSAPIDataItem> rsapiDataItemList = cogMDXReportSummary.getRSAPIDataItemList();
        ArrayList<AbstractOLAPColumn> abstractOLAPColumnList = new ArrayList<AbstractOLAPColumn>();
        ActionFactory actionFactory = edgeElementFactory.getActionFactory();
        for (int i = 0; i < cogMDXReportSummary.getChild(0).getNumberChildren(); ++i) {
            MDXTuple projectedTuple = (MDXTuple)cogMDXReportSummary.getChild(0).getChild(i);
            OLAPRow row = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
            RSAPIDataItem rsapiDataItem = rsapiDataItemList.get(i);
            IXQEQueryNode[] tupleMembers = projectedTuple.getChildren();
            boolean foundSummary = false;
            for (IXQEQueryNode member : tupleMembers) {
                AbstractMDXMember aMember = (AbstractMDXMember)member;
                AbstractOLAPColumn column = (AbstractOLAPColumn)edgeElementFactory.createEdgeElementByType(2);
                int aTuplePosition = mdxEdge.getHierarchyInfo().getProjectedHierarchyIndex(aMember.getHierarchy());
                column.setTuplePosition(aTuplePosition);
                column.setAbstractMDXSetProperties(cogMDXReportSummary);
                column.setRaggedCompensation(cogMDXReportSummary.isRaggedCompensation());
                Set<IHierarchy> reportHierarchies = mdxEdge.getReportHierarchies();
                column.getRules().setReportHierarchy(reportHierarchies.contains(aMember.getHierarchy()));
                column.setHierarchy(aMember.getHierarchy());
                if (aMember.getType() == 1076) {
                    column.addRule(aMember.getHierarchy(), 4);
                    column.setHierarchyNormalization(true);
                } else if (aMember.getType() == 1077) {
                    column.addRule(aMember.getHierarchy(), 3);
                } else {
                    column.addRule(aMember);
                    if (aMember.getType() == 1013) {
                        MDXCalculatedMemberReference calc = (MDXCalculatedMemberReference)aMember;
                        if (calc.isReportSummary()) {
                            column.setRowset(cogMDXReportSummary.getRSAPIEdgeRowset());
                            column.setDataItemIndex(rsapiDataItem);
                            column.setDataitemIndixesProjectingSameSet(cogMDXReportSummary.getDataItemIndexesProjectingSameSet());
                            foundSummary = true;
                            abstractOLAPColumnList.add(column);
                            cogMDXReportSummary.setAbstractOLAPColumn(column);
                        }
                        if (calc.isNestedLevelCalcRef()) {
                            RelocateNestedLevelCalculation relocateNLC = (RelocateNestedLevelCalculation)actionFactory.createActionByType(6);
                            IHierarchy originalHierarchy = (IHierarchy)calc.getPropertyValue("originalHierarchy");
                            int originalTuplePosition = mdxEdge.getHierarchyInfo().getProjectedHierarchyIndex(originalHierarchy);
                            relocateNLC.setTo(originalTuplePosition);
                            IHierarchy currentHierarchy = calc.getHierarchy();
                            int currentTuplePosition = mdxEdge.getHierarchyInfo().getProjectedHierarchyIndex(currentHierarchy);
                            relocateNLC.setFrom(currentTuplePosition);
                            column.addAction(relocateNLC);
                            if (!column.getHierarchy().getDimension().isMeasuresDimension() && !column.getRules().isReportHierarchy()) {
                                column.addRemoveAction(edgeElementFactory);
                            }
                        }
                        BuildXOLAPEdgeMappingUtilities.createRenameActions(cogMDXReportSummary, column, actionFactory, calc);
                    }
                }
                row.addColumn(column, true);
                if (!foundSummary) continue;
                BuildXOLAPEdgeMappingUtilities.buildActionsForReportSummary(cogMDXReportSummary, column, actionFactory);
                break;
            }
            cogMDXReportSummary.setAbstractOLAPRow(row);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup detailGroup;
        IXQEQueryNode detailExpr;
        MDXCrossjoin mdxCrossjoin;
        XQETrace trace = environment.getTrace();
        CogMDXReportSummary cogMDXReportSummary = (CogMDXReportSummary)node;
        List<RSAPIDataItem> rsapiDataItemList = cogMDXReportSummary.getRSAPIDataItemList();
        if (rsapiDataItemList == null) {
            this.traceNodeCondition(false, "This transformation is not applicable.", trace);
            return false;
        }
        MDXEdge mdxEdge = (MDXEdge)cogMDXReportSummary.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target CogMDXReportSummary is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target's ancestor MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (cogMDXReportSummary.getAbstractOLAPColumnList() != null) {
            this.traceNodeCondition(false, "This transformation was applied already.", trace);
            return false;
        }
        if (cogMDXReportSummary.getParent().getType() == 1030 && cogMDXReportSummary.getParent().getChild(0).getType() == 1027 && cogMDXReportSummary.getParent().getChild(1).getType() == 1027) {
            this.traceQueryCondition(false, "The target CogMDXReportSummary is the first child of an MDXCrossjoin.", trace);
            return false;
        }
        if (BuildXOLAPEdgeMappingUtilities.isOrderedNestingMeasures(cogMDXReportSummary)) {
            this.traceQueryCondition(false, "The target CogMDXReportSummary is withing an MDXOrder nesting measures.", trace);
            return false;
        }
        if (cogMDXReportSummary.getNumberChildren() > 1) {
            this.traceQueryCondition(false, "The target CogMDXReportSummary is nesting a set.", trace);
            return false;
        }
        if (mdxEdge != null && !mdxEdge.isProjectedDescendant(cogMDXReportSummary)) {
            this.traceQueryCondition(false, "The target CogMDXReportSummary is not projected by its ancestor MDXEdge node.", trace);
            return false;
        }
        if (cogMDXReportSummary.isRaggedCompensation() && (mdxCrossjoin = (MDXCrossjoin)cogMDXReportSummary.getAncestorOfType(1030)) != null && ((AbstractMDXSet)mdxCrossjoin.getChild(0)).isProjectedDescendant(cogMDXReportSummary)) {
            this.traceQueryCondition(false, "The target CogMDXReportSummary is within a ragged compensation.", trace);
            return false;
        }
        String traceMsg1 = "The detail set for this CogMDXReportSummary has not an AbstractOLAPColumn and an AbstractOLAPRow.";
        if (cogMDXReportSummary.getType() == 1080 && (detailExpr = cogMDXReportSummary.getDetailExpr()) != null && detailExpr.getType() == 1027 && (detailGroup = (CogMDXGroup)cogMDXReportSummary.getDetailExpr()) != null) {
            AbstractOLAPColumn detailGroupColumn = detailGroup.getFirstAbstractOLAPColumn();
            if (detailGroupColumn == null) {
                IHierarchy detailExprHierarchy = detailGroup.getFirstSetHierarchy();
                List<IXQEQueryNode> nestedGroups = detailGroup.getDescendantsOfCategory(1027, false);
                for (IXQEQueryNode nestedGroup : nestedGroups) {
                    CogMDXGroup nGroup = (CogMDXGroup)nestedGroup;
                    if (!detailExprHierarchy.equals(nGroup.getFirstSetHierarchy()) || !detailGroup.isProjectedDescendant(nGroup)) continue;
                    detailGroupColumn = nGroup.getFirstAbstractOLAPColumn();
                    if (detailGroupColumn != null && detailGroupColumn.doesActionTypeApplies(2)) break;
                    detailGroupColumn = null;
                }
            }
            if (detailGroupColumn == null || detailGroupColumn.getParentRow() == null) {
                this.traceQueryCondition(false, traceMsg1, trace);
                return false;
            }
        }
        if (BuildOLAPRowForInnermost.isSummaryProjectingMultiHierarchyTuple(cogMDXReportSummary)) {
            this.traceNodeCondition(true, "This transformation is applicable.", trace);
            return true;
        }
        this.traceQueryCondition(false, "Target CogMDXReportSummary doesn not project a tuple of multiple hierarchies", trace);
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXReportSummary cogMDXReportSummary = (CogMDXReportSummary)node;
        AbstractMDXSet groupSet = (AbstractMDXSet)cogMDXReportSummary.getChild(0);
        if (groupSet.getType() == 1145) {
            this.traceNodeCondition(false, "The target CogMDXReportSummary projects an empty set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation is applicable.", trace);
        return true;
    }
}

