/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingRules;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.Remove;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BuildTagBetweenOverlappingPaths
extends Transformation {
    private static final String NEWLINE = "\n";
    private static final String INDEX_EQUAL = "index = ";
    private static final String COMMA = " , ";
    public static final String BUILDTAGBETWEENOVERLAPPINGPATHS_APPLIED = "BuildTagBetweenOverlappingPathsApplied";

    public BuildTagBetweenOverlappingPaths() {
        this.mName = "Build tags between overlapping paths.";
        this.mPassNumbers = new int[]{36};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge mdxEdge = (MDXEdge)node;
        XOLAPEdgeMapping edgeMapping = mdxEdge.getXOLAPEdgeMapping();
        boolean isNotLastEdgePath = true;
        int currPathIndex = 1;
        int prevIndexBoundary = -1;
        while (isNotLastEdgePath) {
            AbstractOLAPRow overlappingRow;
            OLAPRowCycle grandParentCycle;
            int indexOfOverlappingRow;
            AbstractOLAPColumn overlappingOLAPColumn;
            boolean tagAdded;
            ArrayList<EdgePath> edgePaths = new ArrayList<EdgePath>();
            OLAPRowCycle rootRowCycle = edgeMapping.getRootRowCycle();
            EdgePath rowCycleEdgePath = new EdgePath();
            this.buildEdgePaths(edgePaths, rootRowCycle, rowCycleEdgePath);
            if (edgePaths.size() == 1) break;
            isNotLastEdgePath = currPathIndex < edgePaths.size() - 1;
            EdgePath currEdgePath = (EdgePath)edgePaths.get(currPathIndex);
            while (isNotLastEdgePath && currEdgePath.isTag()) {
                currEdgePath = (EdgePath)edgePaths.get(++currPathIndex);
                isNotLastEdgePath = currPathIndex < edgePaths.size() - 1;
            }
            if (currEdgePath.isTag()) break;
            int prevIndex = currPathIndex - 1;
            AbstractMDXSet overlapSet = null;
            while (prevIndex > prevIndexBoundary) {
                boolean edgePathInDiffCycles;
                EdgePath prevEdgePath = (EdgePath)edgePaths.get(prevIndex);
                if (prevEdgePath.isTag()) {
                    prevIndexBoundary = prevIndex;
                    break;
                }
                EdgeColumn firstColumnOfPrevEdgePath = prevEdgePath.getEdgeColumn(0);
                int numOfInnerCloumns = prevEdgePath.getNumOfColumns() - 1;
                if (numOfInnerCloumns == currEdgePath.getNumOfColumns() && firstColumnOfPrevEdgePath.getAbstractMDXSet() != null && firstColumnOfPrevEdgePath.getAbstractMDXSet().getType() == 1027) {
                    boolean firstColumnOfPrevEdgePathIsContext;
                    CogMDXGroup cogMDXGroup = (CogMDXGroup)firstColumnOfPrevEdgePath.getAbstractMDXSet();
                    boolean bl = firstColumnOfPrevEdgePathIsContext = cogMDXGroup.getAbstractOLAPColumnList() != null && cogMDXGroup.getAbstractOLAPColumnList().get(0).isContext();
                    if (firstColumnOfPrevEdgePathIsContext) {
                        OLAPContextColumn cogMDXGroupColumn = (OLAPContextColumn)cogMDXGroup.getAbstractOLAPColumnList().get(0);
                        OLAPRowCycle rowCycle = (OLAPRowCycle)cogMDXGroupColumn.getParentRow();
                        int numberOfRows = rowCycle.getNumberOfRows();
                        boolean firstColumnOfPrevEdgePathOverlapsParentRowCycle = false;
                        for (int i = 0; i < numberOfRows; ++i) {
                            AbstractOLAPRow currentRow = rowCycle.getRow(i);
                            if (!currentRow.getFirstColumn().getRules().overlaps(cogMDXGroupColumn.getRules())) continue;
                            firstColumnOfPrevEdgePathOverlapsParentRowCycle = true;
                            break;
                        }
                        if (firstColumnOfPrevEdgePathOverlapsParentRowCycle) {
                            EdgeColumn secondColumnOfPrevEdgePath = prevEdgePath.getEdgeColumn(1);
                            EdgeColumn firstColumnOfCurrEdgePath = currEdgePath.getEdgeColumn(0);
                            if (prevEdgePath.getNumOfColumns() != 2 || firstColumnOfPrevEdgePath.getRules().getType() != 2 || firstColumnOfPrevEdgePath.getRules().getMemberDescriptorList().size() != 1 || secondColumnOfPrevEdgePath.getRules().getType() != 2 || secondColumnOfPrevEdgePath.getRules().getMemberDescriptorList().size() != 1) {
                                EdgeColumn columnOfCurrEdgePath;
                                EdgeColumn columnOfPrevEdgePath;
                                boolean currentOverlapsWithPrev = false;
                                for (int prevId = 1; prevId < prevEdgePath.getNumOfColumns() && (currentOverlapsWithPrev = (columnOfPrevEdgePath = prevEdgePath.getEdgeColumn(prevId)).overlaps(columnOfCurrEdgePath = currEdgePath.getEdgeColumn(prevId - 1))); ++prevId) {
                                }
                                if (currentOverlapsWithPrev) {
                                    overlapSet = firstColumnOfCurrEdgePath.getAbstractMDXSet();
                                    break;
                                }
                            } else {
                                overlapSet = null;
                                break;
                            }
                        }
                    }
                }
                int columnCount = currEdgePath.getNumOfColumns();
                if (prevEdgePath.getNumOfColumns() > columnCount) {
                    columnCount = prevEdgePath.getNumOfColumns();
                }
                boolean prevCouldBeEmpty = false;
                int overlappingColumns = 0;
                for (int j = 0; j < columnCount && prevEdgePath.getNumOfColumns() != j && currEdgePath.getNumOfColumns() != j; ++j) {
                    EdgeColumn currEdgeColumn = currEdgePath.getEdgeColumn(j);
                    EdgeColumn prevEdgeColumn = prevEdgePath.getEdgeColumn(j);
                    if (!prevCouldBeEmpty && prevEdgeColumn.couldBeEmpty()) {
                        prevCouldBeEmpty = true;
                    }
                    if (currEdgeColumn.overlaps(prevEdgeColumn)) {
                        AbstractMDXSet currAbstractMDXSet;
                        AbstractMDXSet prevAbstractMDXSet = prevEdgeColumn.getAbstractMDXSet();
                        if (prevAbstractMDXSet != (currAbstractMDXSet = currEdgeColumn.getAbstractMDXSet())) {
                            if (overlapSet == null) {
                                overlapSet = currEdgeColumn.getAbstractMDXSet();
                            }
                            ++overlappingColumns;
                            continue;
                        }
                        if (prevEdgeColumn.getAbstractMDXSet().getHierarchyInfo().getProjectedHierarchy(0).getDimension().isMeasuresDimension() && prevAbstractMDXSet == currAbstractMDXSet) continue;
                        ++overlappingColumns;
                        continue;
                    }
                    overlapSet = null;
                    break;
                }
                if (columnCount == overlappingColumns) break;
                int shareContextColumns = currEdgePath.shareContextColumns(prevEdgePath);
                if (shareContextColumns == -2) {
                    if (!prevCouldBeEmpty) break;
                    --prevIndex;
                    continue;
                }
                if (overlapSet == null && shareContextColumns == 0 && currEdgePath.firstColumnOverlapsPreviousColumnAtAnyDepth(prevEdgePath)) {
                    overlapSet = currEdgePath.getEdgeColumn(0).getAbstractMDXSet();
                    break;
                }
                boolean bl = edgePathInDiffCycles = shareContextColumns == 1 || shareContextColumns == 0;
                if (!prevCouldBeEmpty && edgePathInDiffCycles) {
                    EdgePath nextToPrevEdgePath = (EdgePath)edgePaths.get(prevIndex + 1);
                    AbstractOLAPRow prevTopRow = prevEdgePath.getEdgeColumn(0).getAbstractMDXSet().getFirstAbstractOLAPColumn().getParentRow();
                    if (nextToPrevEdgePath != currEdgePath && prevTopRow != prevEdgePath.getEdgeColumn(0).getAbstractMDXSet().getFirstAbstractOLAPColumn().getParentRow()) {
                        boolean breaksTheCycle;
                        boolean bl2 = breaksTheCycle = prevEdgePath.getEdgeColumn(prevEdgePath.getNumOfColumns() - 1).getRules().getType() == 2;
                        if (breaksTheCycle) break;
                    }
                }
                --prevIndex;
            }
            if (overlapSet != null && (tagAdded = BuildTagBetweenOverlappingPaths.addTagToGroup(overlappingOLAPColumn = overlapSet.getFirstAbstractOLAPColumn(), indexOfOverlappingRow = (grandParentCycle = (OLAPRowCycle)(overlappingRow = overlappingOLAPColumn.getParentRow()).getParentRow()).getRowIndex(overlappingRow), mdxEdge, environment))) {
                ++currPathIndex;
            }
            ++currPathIndex;
        }
        mdxEdge.setPropertyValue(BUILDTAGBETWEENOVERLAPPINGPATHS_APPLIED, Boolean.TRUE);
    }

    private void buildEdgePaths(List<EdgePath> edgePaths, OLAPRowCycle rowCycle, EdgePath rowCycleEdgePath) {
        if (rowCycle.getNumberOfColumns() != 0) {
            AbstractOLAPColumn contextColumn = rowCycle.getFirstColumn();
            EdgeColumn rowCycleEdgeColumn = new EdgeColumn(contextColumn.getId(), contextColumn.getRules(), contextColumn.getCogMDXGroup(), contextColumn.isContext());
            rowCycleEdgePath.addEdgeColumn(rowCycleEdgeColumn);
        }
        int numberOfRows = rowCycle.getNumberOfRows();
        for (int rowIndex = 0; rowIndex < numberOfRows; ++rowIndex) {
            EdgePath currEdgePath = rowCycleEdgePath.copy();
            AbstractOLAPRow currRow = rowCycle.getRow(rowIndex);
            if (currRow.isCycle()) {
                this.buildEdgePaths(edgePaths, (OLAPRowCycle)currRow, currEdgePath);
                continue;
            }
            int numberOfColumns = currRow.getNumberOfColumns();
            if (currRow.isTag()) {
                currEdgePath.setTag(true);
            }
            for (int columnIndex = 0; columnIndex < numberOfColumns; ++columnIndex) {
                AbstractOLAPColumn currColumn = currRow.getColumn(columnIndex);
                if (currColumn.getRulesType() == 4 && currColumn.isContextMember()) continue;
                EdgeColumn currEdgeColumn = new EdgeColumn(currColumn.getId(), currColumn.getRules(), currColumn.getCogMDXGroup(), currColumn.isContext());
                currEdgePath.addEdgeColumn(currEdgeColumn);
            }
            currEdgePath.setIndex(edgePaths.size());
            edgePaths.add(currEdgePath);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        XOLAPEdgeMapping edgeMapping = mdxEdge.getXOLAPEdgeMapping();
        if (mdxEdge.getDescendantsOfType(1027, false).length <= 1 && mdxEdge.getDescendantsOfType(1026, false).length == 0) {
            this.traceNodeCondition(false, "Edge does not contain nesting or siblings requiring tags.", trace);
            return false;
        }
        if (edgeMapping == null || edgeMapping.getRootRowCycle() == null) {
            this.traceNodeCondition(false, "Associated XOLAPEdgeMapping node is not found or initialized.", trace);
            return false;
        }
        if (edgeMapping.getRootRowCycle().getNumberOfRows() == 0) {
            this.traceNodeCondition(false, "Associated XOLAPEdgeMapping is empty.", trace);
            return false;
        }
        if (node.getPropertyValue(BUILDTAGBETWEENOVERLAPPINGPATHS_APPLIED) != null) {
            this.traceNodeCondition(false, "BuildTagBetweenOverlappingPaths was applied already.", trace);
            return false;
        }
        if (node.getPropertyValue("BuildTagForOverlappingContextColumnApplied") == null) {
            this.traceNodeCondition(false, "BuildTagForOverlappingContextColumn needs to be applied first.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
        String queryDataSource = mdxQuery.getDataSourceType();
        String propValue = "RebuildMUNRulesForPowerCubeRootAliasesApplied";
        if (queryDataSource.equals("PC") && mdxEdge.getPropertyValue("RebuildMUNRulesForPowerCubeRootAliasesApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "This transformation is not applicable yet.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }

    public static boolean addTagToGroup(AbstractOLAPColumn overlapCol, int overlappingRowPosition, MDXEdge mdxEdge, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
        IHierarchy hierarchy = overlapCol.getHierarchy();
        AbstractMDXSet matchGroup = overlapCol.getCogMDXGroup();
        if (matchGroup == null) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "matchGroup == null");
        }
        if (((CogMDXGroup)matchGroup).getTagType() != null) {
            return false;
        }
        boolean tagAdded = false;
        CogMDXGroup tagGroup = (CogMDXGroup)factory.createNode(1027);
        MDXSet mdxSet = (MDXSet)factory.createNode(1039);
        MDXCalculatedMemberReference tag = MDXBuilder.buildTagMember(factory, hierarchy, mdxQuery);
        mdxSet.addChild(tag);
        tagGroup.addChild(mdxSet);
        IXQEQueryNode parent = matchGroup.getParent();
        List<IXQEQueryNode> parents = BuildTagBetweenOverlappingPaths.getParents(parent, mdxEdge);
        for (IXQEQueryNode currParent : parents) {
            AbstractMDXSet matchGroupParent = (AbstractMDXSet)currParent;
            if (currParent.getType() != 1039) {
                int[] categories = new int[]{1027, 1006, 1004};
                if (!currParent.isOfCategories(categories)) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!currParent.isOfCategory(OLAPNodeTypeEnum.COGMDX_GROUP)");
                }
                mdxSet = (MDXSet)factory.createNode(1039);
                matchGroup.insertParent(mdxSet);
                matchGroupParent = mdxSet;
            }
            CogMDXGroup topGroup = null;
            CogMDXGroup lastGroup = null;
            AbstractMDXSet ancestorSet = (AbstractMDXSet)matchGroup.getAncestorOfCategory(1021);
            List<IHierarchy> projHierarchies = ancestorSet.getHierarchyInfo().getProjectedHierarchies();
            if (projHierarchies.size() > 1) {
                for (IHierarchy projHierarchy : projHierarchies) {
                    if (projHierarchy.equals(hierarchy)) {
                        if (topGroup == null) {
                            topGroup = tagGroup;
                        }
                        if (lastGroup == null) {
                            lastGroup = tagGroup;
                            continue;
                        }
                        lastGroup.addChild(tagGroup);
                        lastGroup = tagGroup;
                        continue;
                    }
                    mdxSet = (MDXSet)factory.createNode(1039);
                    if ((mdxQuery.getDataSourceType().equals("TM") || mdxQuery.getDataSourceType().equals("TMR")) && !mdxQuery.getCapabilities().isSupported("v5.useLocalOLAP")) {
                        mdxSet.addChild(MDXBuilder.buildTagMember(factory, projHierarchy, mdxQuery));
                    } else {
                        MDXDefaultMember mdxDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, projHierarchy);
                        mdxSet.addChild(mdxDefaultMember);
                    }
                    CogMDXGroup currDefaultMemberGroup = (CogMDXGroup)factory.createNode(1027);
                    currDefaultMemberGroup.addChild(mdxSet);
                    if (topGroup == null) {
                        topGroup = currDefaultMemberGroup;
                    }
                    if (lastGroup == null) {
                        lastGroup = currDefaultMemberGroup;
                        continue;
                    }
                    lastGroup.addChild(currDefaultMemberGroup);
                    lastGroup = currDefaultMemberGroup;
                }
            } else {
                topGroup = tagGroup;
            }
            if (matchGroupParent.getType() == 1083) {
                matchGroupParent = (AbstractMDXSet)matchGroupParent.getParent();
            }
            matchGroupParent.addChildBeforeNode(topGroup, matchGroup);
            if (tag == null) continue;
            BuildTagBetweenOverlappingPaths.addTagToEdgeMapping(overlapCol, tag, overlappingRowPosition, mdxEdge, environment);
            tagAdded = true;
        }
        return tagAdded;
    }

    public static List<IXQEQueryNode> getParents(IXQEQueryNode parent, MDXEdge mdxEdge) {
        ArrayList<IXQEQueryNode> parents = new ArrayList<IXQEQueryNode>();
        while (parent.isOfCategory(1078) || parent.getType() == 1004) {
            if (parent.getType() == 1004) {
                List<MDXSetAliasReference> setAliasRefs = ((MDXSetAliasDefinition)parent).getSetAliasRefs();
                for (MDXSetAliasReference setAliasRef : setAliasRefs) {
                    List<IXQEQueryNode> tmpParents;
                    if (!mdxEdge.isProjectedDescendant(setAliasRef) || (tmpParents = BuildTagBetweenOverlappingPaths.getParents(parent = setAliasRef.getParent(), mdxEdge)).isEmpty()) continue;
                    parents.addAll(tmpParents);
                }
                if (parents.size() > 0) {
                    return parents;
                }
                if (!mdxEdge.isProjectedDescendant((MDXSetAliasDefinition)parent)) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "parent.getType() == OLAPNodeTypeEnum.MDX_SET_ALIAS_DEFINITION");
                }
                parents.add(parent);
                return parents;
            }
            parent = parent.getParent();
        }
        parents.add(parent);
        return parents;
    }

    public static void addTagToEdgeMapping(AbstractOLAPColumn overlappingColumn, MDXCalculatedMemberReference tag, int overlappingRowPosition, MDXEdge mdxEdge, PlanningEnvironment environment) {
        AbstractOLAPRow row = overlappingColumn.getParentRow();
        OLAPRowCycle parentRow = (OLAPRowCycle)row.getParentRow();
        OLAPRow tagRow = BuildTagBetweenOverlappingPaths.createOLAPRowForTagging(overlappingColumn, tag, mdxEdge, environment);
        parentRow.insertRow(tagRow, overlappingRowPosition);
    }

    public static OLAPRow createOLAPRowForTagging(AbstractOLAPColumn overlappingColumn, MDXCalculatedMemberReference tag, MDXEdge mdxEdge, PlanningEnvironment environment) {
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        OLAPRow tagRow = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
        Remove action = new Remove();
        tagRow.addAction(action);
        OLAPColumn tagColumn = (OLAPColumn)edgeElementFactory.createEdgeElementByType(2);
        tagColumn.addRule(tag);
        tagColumn.setTuplePosition(overlappingColumn.getTuplePosition());
        tagColumn.setHierarchy(overlappingColumn.getHierarchy());
        CogMDXGroup tagGroup = (CogMDXGroup)tag.getAncestorOfType(1027);
        tagColumn.setAbstractMDXSetProperties(tagGroup);
        if (tagColumn.getRules().getIsReportHierarchy() == null) {
            Set<IHierarchy> reportHierarchies = mdxEdge.getReportHierarchies();
            tagColumn.getRules().setReportHierarchy(reportHierarchies.contains(overlappingColumn.getHierarchy()));
        }
        tagGroup.setAbstractOLAPColumn(tagColumn);
        tagRow.addColumn(tagColumn, false);
        tagRow.setTag(true);
        return tagRow;
    }

    private class EdgeColumn {
        private int index = -1;
        private EdgeMappingRules rules = null;
        private boolean couldBeEmpty = false;
        private AbstractMDXSet abstractMDXSet = null;
        private boolean isContext = false;

        protected EdgeColumn(int edgeElementId, EdgeMappingRules aRules, AbstractMDXSet aSet, boolean aContext) {
            this.rules = aRules;
            this.couldBeEmpty = this.edgeColumnCouldBeEmpty(aSet);
            this.abstractMDXSet = aSet;
            this.isContext = aContext;
            this.index = edgeElementId;
        }

        public boolean isContext() {
            return this.isContext;
        }

        protected EdgeColumn copy() {
            return new EdgeColumn(this.index, this.rules, this.abstractMDXSet, this.isContext);
        }

        protected boolean edgeColumnCouldBeEmpty(AbstractMDXSet aSet) {
            boolean isEmpty = false;
            isEmpty = aSet.couldResolveToEmptySet(true, true, false);
            if (!isEmpty) {
                MDXEdge mdxEdge = (MDXEdge)aSet.getAncestorOfType(1006);
                isEmpty = mdxEdge.getPowerCubeZeroSuppress();
            }
            return isEmpty;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append("(");
            buffer.append(BuildTagBetweenOverlappingPaths.INDEX_EQUAL);
            buffer.append(this.getIndex());
            buffer.append(BuildTagBetweenOverlappingPaths.COMMA);
            buffer.append("CogMDXGroup");
            buffer.append(" = ");
            buffer.append(this.abstractMDXSet.toString());
            buffer.append(BuildTagBetweenOverlappingPaths.COMMA);
            buffer.append("couldBeEmpty = ");
            buffer.append(this.couldBeEmpty());
            buffer.append(BuildTagBetweenOverlappingPaths.COMMA);
            buffer.append("isContext = ");
            buffer.append(this.isContext());
            buffer.append(BuildTagBetweenOverlappingPaths.NEWLINE);
            buffer.append(this.rules.dumpToString());
            buffer.append(")");
            buffer.append(BuildTagBetweenOverlappingPaths.NEWLINE);
            return buffer.toString();
        }

        protected EdgeMappingRules getRules() {
            return this.rules;
        }

        protected AbstractMDXSet getAbstractMDXSet() {
            return this.abstractMDXSet;
        }

        protected boolean couldBeEmpty() {
            return this.couldBeEmpty;
        }

        public int getIndex() {
            return this.index;
        }

        protected boolean overlaps(EdgeColumn anEdgeColumn) {
            return this.rules.overlaps(anEdgeColumn.getRules());
        }
    }

    private class EdgePath {
        private int index = -1;
        private boolean isTag = false;
        private List<EdgeColumn> edgeColumns = null;
        protected static final int BOTH_EDGE_PATHS_WITHOUT_CONTEXT = -2;
        protected static final int ONLY_ONE_EDGE_PATHS_WITH_CONTEXT = -1;
        protected static final int NO_SHARED_CONTEXT_COLUMNS = 0;
        protected static final int SOME_SHARED_CONTEXT_COLUMNS = 1;
        protected static final int SHARE_ALL_CONTEXT_COLUMNS = 2;

        private EdgePath() {
        }

        protected void addEdgeColumn(EdgeColumn anEdgeColumn) {
            if (this.edgeColumns == null) {
                this.edgeColumns = new ArrayList<EdgeColumn>();
            }
            this.edgeColumns.add(anEdgeColumn);
        }

        protected int getIndex() {
            return this.index;
        }

        protected void setIndex(int anIndex) {
            this.index = anIndex;
        }

        protected boolean isTag() {
            return this.isTag;
        }

        protected void setTag(boolean value) {
            this.isTag = value;
        }

        protected EdgePath copy() {
            EdgePath copyOfThis = new EdgePath();
            if (this.edgeColumns != null) {
                for (EdgeColumn edgeColumn : this.edgeColumns) {
                    copyOfThis.addEdgeColumn(edgeColumn.copy());
                }
            }
            return copyOfThis;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
            buffer.append("(");
            buffer.append(BuildTagBetweenOverlappingPaths.INDEX_EQUAL);
            buffer.append(this.getIndex());
            buffer.append(BuildTagBetweenOverlappingPaths.COMMA);
            buffer.append("isTag = ");
            buffer.append(this.isTag());
            if (this.edgeColumns != null) {
                buffer.append(BuildTagBetweenOverlappingPaths.NEWLINE);
                for (EdgeColumn edgeColumn : this.edgeColumns) {
                    buffer.append(edgeColumn.toString());
                }
            }
            buffer.append(")");
            return buffer.toString();
        }

        protected int getNumOfColumns() {
            return this.edgeColumns.size();
        }

        protected EdgeColumn getEdgeColumn(int columnIndex) {
            return this.edgeColumns.get(columnIndex);
        }

        protected int shareContextColumns(EdgePath prvEdgePath) {
            int edgeColumnPos = -1;
            int status = -2;
            if (this.getNumOfColumns() == 0 || prvEdgePath.getNumOfColumns() == 0) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "getNumOfColumns() == 0");
            }
            if (this.getEdgeColumn(this.getNumOfColumns() - 1).isContext() || prvEdgePath.getEdgeColumn(prvEdgePath.getNumOfColumns() - 1).isContext()) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "last column is context");
            }
            block18: for (EdgeColumn edgeColumn : this.edgeColumns) {
                if (prvEdgePath.getNumOfColumns() <= ++edgeColumnPos) {
                    switch (status) {
                        case 2: {
                            return 1;
                        }
                    }
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "d?");
                }
                EdgeColumn anEdgeColumn = prvEdgePath.getEdgeColumn(edgeColumnPos);
                if (edgeColumn.isContext() && anEdgeColumn.isContext()) {
                    if (edgeColumn.getIndex() == anEdgeColumn.getIndex()) {
                        switch (status) {
                            case -2: 
                            case 2: {
                                status = 2;
                                continue block18;
                            }
                        }
                        throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "d??");
                    }
                    switch (status) {
                        case -2: {
                            return 0;
                        }
                        case 2: {
                            return 1;
                        }
                    }
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "d???");
                }
                if (!edgeColumn.isContext() && !anEdgeColumn.isContext()) {
                    switch (status) {
                        case -2: {
                            return -2;
                        }
                        case 2: {
                            return 2;
                        }
                    }
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "d????");
                }
                switch (status) {
                    case -2: {
                        return -1;
                    }
                    case 2: {
                        return 1;
                    }
                }
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "d?????");
            }
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "?????");
        }

        protected boolean firstColumnOverlapsPreviousColumnAtAnyDepth(EdgePath prvEdgePath) {
            IHierarchy lastHierarchy;
            IHierarchy firstHierarchy = this.getEdgeColumn(0).getAbstractMDXSet().getHierarchyInfo().getProjectedHierarchy(0);
            if (!firstHierarchy.equals(lastHierarchy = this.getEdgeColumn(this.getNumOfColumns() - 1).getAbstractMDXSet().getHierarchyInfo().getProjectedHierarchy(0))) {
                return false;
            }
            for (int i = 0; i < prvEdgePath.getNumOfColumns(); ++i) {
                if (!this.getEdgeColumn(0).overlaps(prvEdgePath.getEdgeColumn(i))) continue;
                return true;
            }
            return false;
        }
    }
}

