/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import java.util.ArrayList;
import java.util.List;

public class DetectUnsupportedGroupsWithDiffHierOrderOnSiblingPaths
extends Transformation {
    protected static final String TRANSFORMATION_APPLIED = "DetectUnsupportedGroupsWithDiffHierOrderOnSiblingPathsApplied";

    public DetectUnsupportedGroupsWithDiffHierOrderOnSiblingPaths() {
        this.mName = "Detect unsupported case of different hierarchy order on sibling edge paths with context dependent expression.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        AbstractMDXSet groupSet = (AbstractMDXSet)cogMDXGroup.getChild(0);
        boolean isNotNestedLevelCalculation = true;
        if (BuildXOLAPEdgeMappingUtilities.isCurrentMemberSet(groupSet) && cogMDXGroup.getNumberChildren() > 1) {
            CogMDXGroup nestedMDXGroup = (CogMDXGroup)cogMDXGroup.getChild(1);
            AbstractMDXSet nestedSet = (AbstractMDXSet)nestedMDXGroup.getChild(0);
            boolean bl = isNotNestedLevelCalculation = nestedSet.getType() != 1039 || nestedSet.getNumberChildren() > 1 || nestedSet.getChild(0).getType() != 1013 || !((MDXCalculatedMemberReference)nestedSet.getChild(0)).isNestedLevelCalcRef();
        }
        if (isNotNestedLevelCalculation) {
            CogMDXGroup firstNestedGroup;
            MDXHierInfo edgeHierInfo = mdxEdge.getHierarchyInfo();
            for (IHierarchy hierarchy : edgeHierInfo.getProjectedHierarchies()) {
                if (!groupSet.isContextDependent(hierarchy)) continue;
                String contextDependentDataItemName = "";
                if (cogMDXGroup.getFirstRSAPIDataItem() != null && cogMDXGroup.getFirstRSAPIDataItem().getName() != null && !cogMDXGroup.getFirstRSAPIDataItem().getName().isEmpty()) {
                    contextDependentDataItemName = cogMDXGroup.getFirstRSAPIDataItem().getName();
                }
                List<IXQEQueryNode> edgePathNodes = this.collectedgePathNodes(cogMDXGroup);
                StringBuffer daitemList = this.buildDaitemList(edgePathNodes);
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedGroupsWithDiffHierOrderOnSiblingPaths, daitemList.toString(), contextDependentDataItemName, hierarchy.getName(), edgePathNodes);
                throw new XQERuntimeException(message);
            }
            if (!(cogMDXGroup.warnedAboutDiffHierOrderOnSiblingPath() || (firstNestedGroup = (CogMDXGroup)cogMDXGroup.getFirstDescendantOfTypeOrdered(1027, false)) != null && firstNestedGroup.hasDiffHierOrderOnSiblingPath())) {
                List<IXQEQueryNode> edgePathNodes = this.collectedgePathNodes(cogMDXGroup);
                StringBuffer daitemList = this.buildDaitemList(edgePathNodes);
                int aSeverity = 1;
                XQEMessage message = new XQEMessage(XQEMessageKeys.WRN_GroupsWithDiffHierOrderOnSiblingPaths, daitemList.toString(), edgePathNodes);
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, message));
                for (IXQEQueryNode edgePathNode : edgePathNodes) {
                    if (!((CogMDXGroup)edgePathNode).hasDiffHierOrderOnSiblingPath()) continue;
                    ((CogMDXGroup)edgePathNode).setHasDiffHierOrderOnSiblingPath(CogMDXGroup.HAS_DIFF_HIER_ORDER_ON_SIBLING_PATH_WRN);
                }
            }
        }
    }

    private StringBuffer buildDaitemList(List<IXQEQueryNode> edgePathNodes) {
        StringBuffer daitemList = new StringBuffer();
        for (IXQEQueryNode edgePathNode : edgePathNodes) {
            CogMDXGroup currGroup = (CogMDXGroup)edgePathNode;
            if (currGroup.getFirstRSAPIDataItem() == null || currGroup.getFirstRSAPIDataItem().getName() == null || currGroup.getFirstRSAPIDataItem().getName().isEmpty()) continue;
            daitemList.append("[");
            daitemList.append(currGroup.getFirstRSAPIDataItem().getName());
            daitemList.append("]");
            if (edgePathNode == edgePathNodes.get(edgePathNodes.size() - 1)) continue;
            daitemList.append(",");
        }
        return daitemList;
    }

    private List<IXQEQueryNode> collectedgePathNodes(CogMDXGroup cogMDXGroup) {
        IXQEQueryNode[] ancestors = cogMDXGroup.getAncestorsOfCategory(1027);
        ArrayList<IXQEQueryNode> edgePathNodes = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode ancestor : ancestors) {
            if (!((CogMDXGroup)ancestor).hasDiffHierOrderOnSiblingPath()) continue;
            edgePathNodes.add(ancestor);
        }
        List<IXQEQueryNode> descendants = cogMDXGroup.getDescendantsOfCategoryOrdered(1027, true);
        for (IXQEQueryNode descendant : descendants) {
            if (!((CogMDXGroup)descendant).hasDiffHierOrderOnSiblingPath()) continue;
            edgePathNodes.add(descendant);
        }
        return edgePathNodes;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(TRANSFORMATION_APPLIED) != null) {
            this.traceNodeCondition(false, "The transformation was applied already.", trace);
            return false;
        }
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        if (cogMDXGroup.hasDiffHierOrderOnSiblingPath()) {
            this.traceNodeCondition(true, "The transformation was not applied yet.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The transformation is not applicable.", trace);
        return false;
    }
}

