/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class FlagCogMDXGroupRequiringGenerateContextAction
extends Transformation {
    public FlagCogMDXGroupRequiringGenerateContextAction() {
        this.mName = "Flag any CogMDXGroup requiring GenerateContext action.";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode ancestorGroup;
        CogMDXGroup ancestor;
        IHierarchy ancestorHierarchy;
        IXQEQueryNode[] ancestorGroups;
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        IHierarchy targetHierarchy = targetGroup.getFirstSetHierarchy();
        targetGroup.setGenerateContextIsRequired(true);
        IXQEQueryNode[] iXQEQueryNodeArray = ancestorGroups = targetGroup.getAncestorsOfCategory(1027);
        int n = iXQEQueryNodeArray.length;
        for (int i = 0; i < n && (ancestorHierarchy = (ancestor = (CogMDXGroup)(ancestorGroup = iXQEQueryNodeArray[i])).getFirstSetHierarchy()).equals(targetHierarchy) && !ancestor.getGenerateProjCurrentMember(); ++i) {
            ancestor.setGenerateContextIsRequired(true);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        if (cogMDXGroup.isGenerateContextRequired().booleanValue()) {
            this.traceNodeCondition(false, "The transfromation was applied already.", trace);
            return false;
        }
        if (cogMDXGroup.getGenerateProjCurrentMember()) {
            this.traceNodeCondition(false, "Property 'generateProjCurrentMember' value is 'true'.", trace);
            return false;
        }
        if (!cogMDXGroup.isNestedLevels()) {
            this.traceNodeCondition(false, "The target CogMDXGroup node is part of a nested level structure.", trace);
            return false;
        }
        CogMDXGroup ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfType(1027);
        if (ancestorGroup == null) {
            this.traceNodeCondition(false, "The target CogMDXGroup has no ancestor CogMDXGroup.", trace);
            return false;
        }
        if (ancestorGroup.getGenerateProjCurrentMember()) {
            this.traceNodeCondition(false, "The ancestor CogMDXGroup requires requires Projected current member.", trace);
            return false;
        }
        IHierarchy targetHierarchy = cogMDXGroup.getFirstSetHierarchy();
        if (targetHierarchy.getDimension().isMeasuresDimension()) {
            this.traceNodeCondition(false, "The target CogMDXGroup belongs to the measures.", trace);
            return false;
        }
        IHierarchy ancestorHierarchy = ancestorGroup.getFirstSetHierarchy();
        if (!ancestorHierarchy.equals(targetHierarchy)) {
            this.traceNodeCondition(false, "The ancestor CogMDXGroup belongs to a different hierarchy.", trace);
            return false;
        }
        MDXEdge edge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (edge == null || !edge.isProjectedDescendant(cogMDXGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup node is not projected on an edge.", trace);
            return false;
        }
        if (!FlagCogMDXGroupRequiringGenerateContextAction.isInnermostForHierarchy(cogMDXGroup)) {
            this.traceNodeCondition(false, "The target CogMDXGroup node is not the innermost for its hierarchy.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target CogMDXGroup node requires a OLAPNestedLevelDecoration.", trace);
        return true;
    }

    public static boolean isInnermostForHierarchy(CogMDXGroup targetGroup) {
        IHierarchy nextLevelHierarchy;
        List<CogMDXGroup> nextLevelNestedGroups = targetGroup.getGroupsPrjAtNextDepthOrdered();
        IHierarchy targetHierarchy = targetGroup.getFirstSetHierarchy();
        return nextLevelNestedGroups.isEmpty() || (nextLevelHierarchy = nextLevelNestedGroups.get(0).getFirstSetHierarchy()) == null || !nextLevelHierarchy.equals(targetHierarchy);
    }
}

