/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public class RebuildMUNRulesForNoMember
extends ProviderTransformation {
    private static final String REBUILD_MUNRULES_FOR_NOMEMBER = "RebuildMUNRulesForNoMemberApplied";

    public RebuildMUNRulesForNoMember() {
        super(new String[]{"PC", "TM", "TMR", "BW"});
        this.mName = "Rebuilds the MUN rules for NOMEMBER default members.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge mdxEdge = (MDXEdge)node;
        mdxEdge.getXOLAPEdgeMapping().rebuildMUNRulesForNoMember();
        mdxEdge.setPropertyValue(REBUILD_MUNRULES_FOR_NOMEMBER, Boolean.TRUE);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceNodeCondition(false, "The target MDXEdge has no XOLAPEdgeMapping.", trace);
            return false;
        }
        if (mdxEdge.getPropertyValue(REBUILD_MUNRULES_FOR_NOMEMBER) == Boolean.TRUE) {
            this.traceNodeCondition(false, "This transformation was applied already.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation has not been applied yet.", trace);
        return true;
    }
}

