/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RecordReportEdgeHierarchies
extends Transformation {
    public RecordReportEdgeHierarchies() {
        this.mName = "Record report edge hierarchies.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{101049};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Edge v5Edge = (V5Edge)node;
        IXQEQueryNode[] edgeValueSets = v5Edge.getDescendantsOfType(101057, false);
        if (edgeValueSets.length == 0) {
            environment.setTreeHasBeenModified();
            return;
        }
        HashSet<IHierarchy> reportHierarchies = new HashSet<IHierarchy>();
        for (IXQEQueryNode edgeValueSet : edgeValueSets) {
            V5ValueSet v5ValueSet = (V5ValueSet)edgeValueSet;
            MDXHierInfo hierInfo = v5ValueSet.getHierarchyInfo();
            if (hierInfo == null) {
                IXQEQueryNode[] dataItemRefs;
                for (IXQEQueryNode dataItemRef : dataItemRefs = v5ValueSet.getDescendantsOfType(101015, false)) {
                    V5SimpleNode v5SimpleNode;
                    List<IHierarchy> projectedHierarchies;
                    V5DataItemRef v5DataItemRef = (V5DataItemRef)dataItemRef;
                    if (!v5DataItemRef.getChild(0).isOfCategory(201120) || (projectedHierarchies = (hierInfo = (v5SimpleNode = (V5SimpleNode)v5DataItemRef.getChild(0)).getHierarchyInfo()).getProjectedHierarchies()).isEmpty()) continue;
                    for (IHierarchy currHierarchy : hierInfo.getProjectedHierarchies()) {
                        if (currHierarchy.isShell()) continue;
                        reportHierarchies.add(currHierarchy);
                    }
                }
                continue;
            }
            List<IHierarchy> projectedHierarchies = hierInfo.getProjectedHierarchies();
            if (projectedHierarchies.isEmpty()) continue;
            if (reportHierarchies == null) {
                reportHierarchies = new HashSet();
            }
            reportHierarchies.addAll(hierInfo.getProjectedHierarchies());
        }
        v5Edge.setPropertyValue("reportHierarchies", reportHierarchies);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Edge v5Edge = (V5Edge)node;
        Set reportHierarchies = (Set)v5Edge.getPropertyValue("reportHierarchies");
        if (reportHierarchies != null) {
            this.traceNodeCondition(false, "The reportHierarchies property has been set already.", trace);
            return false;
        }
        IXQEQueryNode[] edgeValueSets = v5Edge.getDescendantsOfType(101057, false);
        if (edgeValueSets.length == 0) {
            this.traceNodeCondition(false, "Transforamtion is not required.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The reportHierarchies property has not been set yet.", trace);
        return true;
    }
}

