/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.EdgeMappingRules;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import java.util.List;

public class ReplaceMUNRulesWithLUNRules
extends Transformation {
    public ReplaceMUNRulesWithLUNRules() {
        this.mName = "Replace MUN rules with LUN rules whenever is possible.";
        this.mPassNumbers = new int[]{37};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        List<AbstractOLAPColumn> columns = cogMDXGroup.getAbstractOLAPColumnList();
        AbstractOLAPColumn column = columns.get(0);
        column.getRules().replaceMUNRulesWithLUNRules();
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (cogMDXGroup.getHierarchyInfo().getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
            this.traceQueryCondition(false, "The target CogMDXGroup projects measures.", trace);
            return false;
        }
        List<AbstractOLAPColumn> columns = cogMDXGroup.getAbstractOLAPColumnList();
        if (columns == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not asscoiated to an AbstractOLAPColumn.", trace);
            return false;
        }
        AbstractOLAPColumn column = columns.get(0);
        if (column.getRulesType() != 2 && column.getRulesType() != 5 && column.getRulesType() != 6) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not asscoiated to MUN type rule.", trace);
            return false;
        }
        if (column.getNumOfCalculations() > 0) {
            this.traceQueryCondition(false, "The target CogMDXGroup projects calculations.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
        List<EdgeMappingRules.MemberDescriptor> memberDescriptors = column.getRules().getMemberDescriptorList();
        for (EdgeMappingRules.MemberDescriptor memberDescriptor : memberDescriptors) {
            if (memberDescriptor.isNoMember()) {
                this.traceQueryCondition(false, "The target CogMDXGroup projects NOMEMBERS.", trace);
                return false;
            }
            if (!memberDescriptor.isRootMember()) continue;
            String queryDataSource = mdxQuery.getDataSourceType();
            for (String ykDataSourceType : YukonTransformation.YK_DATASOURCE_TYPES) {
                if (!queryDataSource.equals(ykDataSourceType)) continue;
                this.traceQueryCondition(false, "The target CogMDXGroup projects a YK root member.", trace);
                return false;
            }
        }
        CogMDXGroup ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027);
        if (column.isContext()) {
            OLAPRowCycle parentRowCycle = (OLAPRowCycle)column.getParentRow();
            if (parentRowCycle.isNestingSameHierarchy()) {
                this.traceQueryCondition(false, "The associated OLAPRowCycle is nesting the same hierarchy.", trace);
                return false;
            }
        } else {
            OLAPRowCycle parentRowCycle;
            AbstractOLAPRow parent = column.getParentRow();
            if (parent == null || parent.getParentRow() == null) {
                this.traceQueryCondition(false, "The transformation is not applicable yet.", trace);
                return false;
            }
            if (parent.getParentRow().isCycle() && parent.getParentRow().getFirstColumn() == null) {
                parentRowCycle = (OLAPRowCycle)parent.getParentRow();
                if (parentRowCycle.getNumberOfRows() == 1) {
                    this.traceQueryCondition(true, "The edge projects a single row.", trace);
                    return true;
                }
                if (mdxEdge.getHierarchyInfo().getNumProjectedHierarchies() == 1) {
                    this.traceQueryCondition(false, "The edge projects a multiple rows of a single hierarchy.", trace);
                    return false;
                }
            }
            if (parent.getParentRow().isCycle() && parent.getParentRow().getFirstColumn() != null) {
                parentRowCycle = (OLAPRowCycle)parent.getParentRow();
                if (parentRowCycle.isNestingSameHierarchy()) {
                    this.traceQueryCondition(false, "The associated AbstractOLAPRow is nestested under the same hierarchy.", trace);
                    return false;
                }
                if (parentRowCycle.getNumberOfRows() > 1 && parentRowCycle.getFirstColumn().getCogMDXGroup().getType() != 1080 && parentRowCycle.getFirstColumn().getCogMDXGroup().getHierarchyInfo().getNumProjectedHierarchies() == 2) {
                    this.traceQueryCondition(false, "The associated AbstractOLAPRow has sibling rows of a single hierarchy.", trace);
                    return false;
                }
            }
            if (cogMDXGroup.getParent().getType() == 1039 || ancestorGroup != null && ancestorGroup.getParent().getType() == 1039) {
                int numberOfColumns = parent.getNumberOfColumns();
                int numberOfMUNColumns = 0;
                for (int i = 0; i < numberOfColumns; ++i) {
                    AbstractOLAPColumn currColumn = parent.getColumn(i);
                    if (i == 0 && currColumn.getRulesType() == 4 && currColumn.isContextMember()) {
                        while (currColumn != null) {
                            if (parent.getParentRow() == null || parent.getParentRow().getFirstColumn() == null) {
                                ancestorGroup.throwInternalError("null");
                            }
                            if ((currColumn = parent.getParentRow().getFirstColumn()) == null || currColumn.getRulesType() == 4 && currColumn.isContextMember()) continue;
                        }
                    }
                    if (currColumn.getRulesType() != 2) continue;
                    ++numberOfMUNColumns;
                }
                if (numberOfMUNColumns == numberOfColumns) {
                    this.traceQueryCondition(false, "Target row only uses MUN rules.", trace);
                    return false;
                }
            }
        }
        CogMDXGroup targetGroup = cogMDXGroup;
        while (targetGroup != null) {
            if (targetGroup.getParent().getType() != 1039) {
                targetGroup = (CogMDXGroup)targetGroup.getAncestorOfCategory(1027);
                continue;
            }
            boolean areMUNRulesIrreplaceable = BuildXOLAPEdgeMappingUtilities.doSiblingLevelsOverlap(targetGroup);
            if (areMUNRulesIrreplaceable) {
                this.traceQueryCondition(false, "MUN rules are irreplaceable.", trace);
                return false;
            }
            if (targetGroup == null) continue;
            targetGroup = (CogMDXGroup)targetGroup.getAncestorOfCategory(1027);
        }
        this.traceQueryCondition(true, "The transformation is applicable.", trace);
        return true;
    }
}

