/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping.unbalanced;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.TNodeUnbCompensation;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import java.util.ArrayList;
import java.util.List;

public class BuildAbstractOLAPRowForOrderedUnbalancedCompensationNestingMeasures
extends Transformation {
    private static final String WAS_THIS_APPLIED = "BuildAbstractOLAPRowForOrderedUnbalancedCompensationNestingMeasuresApplied";

    public BuildAbstractOLAPRowForOrderedUnbalancedCompensationNestingMeasures() {
        this.mName = "This transformation builds an OLAPColumn node for the a TNodeUnbCompensation nesting a different hierarchy.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1113};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeUnbCompensation tNode = (TNodeUnbCompensation)node;
        CogMDXGroup ancestorGroup = (CogMDXGroup)tNode.getAncestorOfType(1027);
        OLAPContextColumn ancestorColumn = (OLAPContextColumn)ancestorGroup.getAbstractOLAPColumnList().get(0);
        OLAPRowCycle rowCycle = (OLAPRowCycle)ancestorGroup.getAbstractOLAPColumnList().get(0).getParentRow();
        MDXEdge mdxEdge = (MDXEdge)tNode.getAncestorOfType(1006);
        List<AbstractMDXNode> nestedMeasures = BuildXOLAPEdgeMappingUtilities.getNestedMeasuresForOrderedGroup(ancestorGroup);
        for (AbstractMDXNode nestedMeasure : nestedMeasures) {
            if (nestedMeasure.getType() != 1027) {
                throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "nestedMeasure.getType() != OLAPNodeTypeEnum.COGMDX_GROUP");
            }
            CogMDXGroup measureGroup = (CogMDXGroup)nestedMeasure;
            ArrayList<AbstractOLAPColumn> measureColumns = new ArrayList<AbstractOLAPColumn>();
            measureColumns.addAll(measureGroup.getAbstractOLAPColumnList());
            for (AbstractOLAPColumn measureColumn : measureColumns) {
                AbstractOLAPRow row = measureColumn.getParentRow();
                EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
                AbstractOLAPRow rowCopy = (AbstractOLAPRow)row.copy(edgeElementFactory, true);
                rowCopy.removeColumn(rowCopy.getColumn(0));
                BuildXOLAPEdgeMappingUtilities.createSameAsContextCurrentMemberColumn(edgeElementFactory, ancestorGroup, ancestorColumn, rowCopy, mdxEdge);
                rowCycle.addRow(rowCopy, true);
            }
        }
        tNode.setPropertyValue(WAS_THIS_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        TNodeUnbCompensation tNode = (TNodeUnbCompensation)node;
        MDXEdge mdxEdge = (MDXEdge)tNode.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target TNodeUnbCompensation is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (tNode.getPropertyValue(WAS_THIS_APPLIED) == Boolean.TRUE) {
            this.traceQueryCondition(false, "This transformation was applied already.", trace);
            return false;
        }
        if (tNode.getChild(1).getType() == 1030) {
            this.traceNodeCondition(false, "The target TNodeUnbCompensation does project a crossjoin.", trace);
            return false;
        }
        CogMDXGroup ancestorGroup = (CogMDXGroup)tNode.getAncestorOfType(1027);
        if (((AbstractMDXSet)ancestorGroup.getChild(0)).isProjectedDescendant(tNode) && BuildXOLAPEdgeMappingUtilities.isOrderedNestingMeasures(ancestorGroup) && ancestorGroup.getAbstractOLAPColumnList() != null && ancestorGroup.getAbstractOLAPColumnList().get(0) != null && ancestorGroup.getAbstractOLAPColumnList().get(0).isContext() && ancestorGroup.getAbstractOLAPColumnList().get(0).getParentRow() != null) {
            OLAPRowCycle rowCycle = (OLAPRowCycle)ancestorGroup.getAbstractOLAPColumnList().get(0).getParentRow();
            List<AbstractMDXNode> nestedMeasures = BuildXOLAPEdgeMappingUtilities.getNestedMeasuresForOrderedGroup(ancestorGroup);
            for (AbstractMDXNode nestedMeasure : nestedMeasures) {
                CogMDXGroup measureGroup;
                AbstractOLAPColumn measureColumn;
                if (nestedMeasure.getType() != 1027 || rowCycle.findColumnById((measureColumn = (measureGroup = (CogMDXGroup)nestedMeasure).getAbstractOLAPColumnList().get(0)).getId()) != null) continue;
                this.traceQueryCondition(false, "This transformation is not applicable yet.", trace);
                return false;
            }
            this.traceQueryCondition(true, "This transformation is applicable.", trace);
            return true;
        }
        this.traceQueryCondition(false, "This transformation is not applicable.", trace);
        return false;
    }
}

