/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.MDXValue;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class PutAggregateMeasureInContext
extends Transformation {
    public static final String PROP_AGGREGATE_UNREF_HIERARCHY = "aggregateUnrefHierarchy";

    public PutAggregateMeasureInContext() {
        this.mName = "Put the Aggregate Measure in Context With the Aggregate Function.";
        this.mPassNumbers = new int[]{42};
        this.mTypes = new int[]{1060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXMember dimLineMember;
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXMember measure = this.getMeasure(node.getChild(1));
        MDXValue mdxValue = (MDXValue)factory.createNode(1059);
        MDXTuple mdxTuple = (MDXTuple)factory.createNode(1069);
        mdxValue.addChild(mdxTuple);
        IHierarchy hierarchy = null;
        AbstractMDXSet set = (AbstractMDXSet)node.getChild(0);
        hierarchy = this.getHierarchyFromAggregateSet(set);
        if (hierarchy == null) {
            hierarchy = this.getHierarchyFromValueExpressionTuple((MDXTuple)measure.getParent());
        }
        if (hierarchy == null && (dimLineMember = this.getDimensionLineMember(mdxQuery)) != null) {
            MDXHierInfo hierInfo = dimLineMember.getHierarchyInfo();
            hierarchy = hierInfo.getProjectedHierarchy(0);
            ((MDXSummaryFunction)node).addMemberToContext(factory, dimLineMember, true);
        }
        if (hierarchy == null) {
            hierarchy = this.getUnreferencedHierarchy(mdxQuery);
            mdxQuery.setPropertyValue(PROP_AGGREGATE_UNREF_HIERARCHY, hierarchy);
            MDXDefaultMember defaultMember = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, hierarchy);
            ((MDXSummaryFunction)node).addMemberToContext(factory, defaultMember, true);
        }
        MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        node.getParent().exchangeChildNode(node, mdxValue);
        int solveOrder = SolveOrderUtil.getSummaryCalcSolveOrder();
        if (mdxCalculatedMemberDefinition != null) {
            solveOrder = mdxCalculatedMemberDefinition.getSolveOrder() + SolveOrderUtil.getSummaryCalcSolveOrder();
        }
        if (((MDXSummaryFunction)node).isSlicerCalcIntersectingWithSeveralProjCalc()) {
            solveOrder = SolveOrderUtil.getCubeCalcSolveOrder();
        }
        MDXCalculatedMemberReference cmRef = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, hierarchy, "_AG", (MDXSummaryFunction)node, solveOrder);
        mdxTuple.addChild(cmRef);
        this.deleteMeasure(measure);
        mdxTuple.addChild(measure);
    }

    IHierarchy getHierarchyFromAggregateSet(AbstractMDXSet set) {
        MDXHierInfo hierInfo = set.getHierarchyInfo();
        for (int i = 0; i < hierInfo.getNumProjectedHierarchies(); ++i) {
            if (hierInfo.getProjectedHierarchy(i).getDimension().isMeasuresDimension() || set.isContextDependent(hierInfo.getProjectedHierarchy(i))) continue;
            return hierInfo.getProjectedHierarchy(i);
        }
        return null;
    }

    IHierarchy getHierarchyFromValueExpressionTuple(MDXTuple tuple) {
        for (int i = 0; i < tuple.getNumberChildren(); ++i) {
            AbstractMDXMember member = (AbstractMDXMember)tuple.getChild(i);
            MDXHierInfo hierInfo = member.getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() != 1 || hierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension() || member.isContextDependent(hierInfo.getProjectedHierarchy(0))) continue;
            return hierInfo.getProjectedHierarchy(0);
        }
        return null;
    }

    AbstractMDXMember getDimensionLineMember(MDXQuery mdxQuery) {
        MDXDimensionLine mdxDimLine = mdxQuery.getDimensionLine();
        if (mdxDimLine != null && mdxDimLine.validateChildCategories() && mdxDimLine.getChild(0).getType() == 1069 && mdxDimLine.getChild(0).validateChildCategories()) {
            return (AbstractMDXMember)mdxDimLine.getChild(0).getChild(0);
        }
        return null;
    }

    AbstractMDXMember getMeasure(IXQEQueryNode valueExpression) {
        MDXTuple mdxTuple;
        if (valueExpression.getType() == 1059 && valueExpression.validateChildCategories() && valueExpression.getChild(0).getType() == 1069 && (mdxTuple = (MDXTuple)valueExpression.getChild(0)).validateChildCategories()) {
            for (int i = 0; i < mdxTuple.getNumberChildren(); ++i) {
                MDXHierInfo hierInfo;
                AbstractMDXMember member = (AbstractMDXMember)mdxTuple.getChild(i);
                if (member.getType() != 1067 && member.getType() != 1077 || !(hierInfo = member.getHierarchyInfo()).projectsMeasures()) continue;
                return member;
            }
        }
        return null;
    }

    void deleteMeasure(AbstractMDXMember measure) {
        IXQEQueryNode mdxTuple = measure.getParent();
        mdxTuple.detachChild(measure);
        if (mdxTuple.getNumberChildren() == 0) {
            IXQEQueryNode mdxValue = mdxTuple.getParent();
            mdxValue.getParent().detachChild(mdxValue);
        }
    }

    IHierarchy getUnreferencedHierarchy(MDXQuery mdxQuery) {
        IHierarchy hierarchy = (IHierarchy)mdxQuery.getPropertyValue(PROP_AGGREGATE_UNREF_HIERARCHY);
        if (hierarchy == null) {
            hierarchy = mdxQuery.getUnreferencedHierarchy();
        }
        return hierarchy;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1002) == null) {
            this.traceNodeCondition(false, "The summary function is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        IXQEQueryNode ancestorSummary = node.getAncestorOfType(1060);
        XQETrace noTrace = null;
        boolean status = this.nodeCondition(node, noTrace);
        if (status && ancestorSummary != null && this.nodeCondition(ancestorSummary, noTrace)) {
            this.traceNodeCondition(false, "This transformation must be applied first to its ancestor summary function.", trace);
            return false;
        }
        return this.nodeCondition(node, trace);
    }

    private boolean nodeCondition(IXQEQueryNode node, XQETrace trace) {
        MDXSummaryFunction summaryFn = (MDXSummaryFunction)node;
        if (summaryFn.getSummaryType() != MDXSummaryFunctionTypeEnum.AGGREGATE) {
            if (trace != null) {
                this.traceNodeCondition(false, "The target MDXSummaryFunction node is not of type MDXSummaryFunction.AGGREGATE.", trace);
            }
            return false;
        }
        summaryFn.throwOnInvalidChildCategories();
        if (summaryFn.getNumberChildren() != 2) {
            if (trace != null) {
                this.traceNodeCondition(false, "The aggregate node does not have a value expression.", trace);
            }
            return false;
        }
        AbstractMDXMember measure = this.getMeasure(node.getChild(1));
        if (measure == null) {
            if (trace != null) {
                this.traceNodeCondition(false, "The value expression is not an MDXTuple that contains a BaseMember measure.", trace);
            }
            return false;
        }
        AbstractMDXSet set = (AbstractMDXSet)node.getChild(0);
        IHierarchy hierarchy = this.getHierarchyFromAggregateSet(set);
        if (hierarchy != null) {
            if (trace != null) {
                this.traceNodeCondition(true, "The target MDXSummaryFunction node has an MDXTuple value expression which contains a BaseMember measure, and the summary set projects a hierarchy upon which which it is not context dependent.", trace);
            }
            return true;
        }
        MDXTuple mdxTuple = (MDXTuple)measure.getParent();
        hierarchy = this.getHierarchyFromValueExpressionTuple(mdxTuple);
        if (hierarchy != null) {
            if (trace != null) {
                this.traceNodeCondition(true, "The target MDXSummaryFunction node has an MDXTuple value expression which contains a BaseMember measure and another AbstractMDXMember expression that projects a hierarchy upon which is it not context depdendant, and that can be used to create a new calculated member.", trace);
            }
            return true;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXMember dimLineMember = this.getDimensionLineMember(mdxQuery);
        if (dimLineMember != null) {
            MDXHierInfo hierInfo = dimLineMember.getHierarchyInfo();
            hierarchy = hierInfo.getProjectedHierarchy(0);
        }
        if (hierarchy != null) {
            if (trace != null) {
                this.traceNodeCondition(true, "The target MDXSummaryFunction node has an MDXTuple value expression which contains a BaseMember measure, and there is an AbstractMDXMember on the MDXDimensionLine that projects a hierarchy that can be used to create a new calculated member.", trace);
            }
            return true;
        }
        if (this.getUnreferencedHierarchy(mdxQuery) == null) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TransformationFailNoUnrefHier, this.mName, XQEIntegerPool.getInteger(node.getId()).toString());
        }
        if (trace != null) {
            this.traceNodeCondition(true, "The target MDXSummaryFunction node has an MDXTuple value expression which contains a BaseMember measure, and there is an unreferenced hierarchy available in the cube that can be used to create a new calculated member.", trace);
        }
        return true;
    }
}

