/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class RemoveUnreferencedMDXSetAliasDefinition
extends Transformation {
    public RemoveUnreferencedMDXSetAliasDefinition() {
        this.mName = "Remove MDX Set Alias Definition when there are no references.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1004};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.extract();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        XQETrace trace = environment.getTrace();
        MDXSetAliasDefinition aliasDef = (MDXSetAliasDefinition)node;
        if (aliasDef.getSetAliasRefs().size() > 0) {
            this.traceQueryCondition(status, "The MDX Set Alias Definition still has references.", trace);
            return status;
        }
        status = true;
        this.traceQueryCondition(status, "The definition has no references. Set Alias Definition will be removed.", trace);
        return status;
    }
}

