/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class ResetFillerTagValuesForNullSuppression
extends Transformation {
    public ResetFillerTagValuesForNullSuppression() {
        this.mName = "Set filler tag values.";
        this.mPassNumbers = new int[]{50};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXValueExpression newValue;
        MDXCalculatedMemberReference mdxCalcRef = (MDXCalculatedMemberReference)node;
        MDXEdge mdxEdge = (MDXEdge)mdxCalcRef.getAncestorOfType(1006);
        boolean mdxNonEmpty = mdxEdge.getMDXNonEmptyProperty();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXValueExpression fillerValue = (AbstractMDXValueExpression)mdxCalcRef.getDefinition().getChild(0);
        if (mdxNonEmpty && fillerValue.getType() == 1089) {
            newValue = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)nodeFactory, 1);
            fillerValue.exchange(newValue);
        }
        if (!mdxNonEmpty && fillerValue.getType() != 1089) {
            newValue = (AbstractMDXValueExpression)nodeFactory.createNode(1089);
            fillerValue.exchange(newValue);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference mdxCalcRef = (MDXCalculatedMemberReference)node;
        if (mdxCalcRef.getDefinition().isFillerTag()) {
            MDXEdge mdxEdge = (MDXEdge)mdxCalcRef.getAncestorOfType(1006);
            if (mdxEdge == null) {
                this.traceNodeCondition(false, "The target is a filler tag. It is not projected.", trace);
                return false;
            }
            boolean mdxNonEmpty = mdxEdge.getMDXNonEmptyProperty();
            AbstractMDXValueExpression fillerValue = (AbstractMDXValueExpression)mdxCalcRef.getDefinition().getChild(0);
            if (mdxNonEmpty && fillerValue.getType() == 1089) {
                String traceMsg = "The target is a filler tag. Its value is null and NON EMPTY is applied.";
                if (mdxCalcRef.getHierarchy().getDimension().isMeasuresDimension()) {
                    this.traceNodeCondition(false, "The target is a filler tag in the measures dimension.", trace);
                    return false;
                }
                this.traceNodeCondition(true, "The target is a filler tag. Its value is null and NON EMPTY is applied.", trace);
                return true;
            }
            if (!mdxNonEmpty && fillerValue.getType() != 1089) {
                String traceMsg = "The target is a filler tag. Its value is not null and NON EMPTY is not applied.";
                this.traceNodeCondition(true, "The target is a filler tag. Its value is not null and NON EMPTY is not applied.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The target MDXCalculatedMemberReference is not a filler tag.", trace);
        return false;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "V5EdgeSuppression");
        trace.endElement();
    }
}

