/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class RollbackMDXSetAlias
extends Transformation {
    public RollbackMDXSetAlias() {
        this.mName = "Rollback Set Alias for queries that do not support MDX set alias.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1015};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RollbackMDXSetAlias.rollbackSetAliasNode((MDXSetAliasReference)node, environment);
    }

    public static void rollbackSetAliasNode(MDXSetAliasReference aliasRef, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean isRequired = false;
        Boolean propValue = (Boolean)aliasRef.getPropertyValue("required");
        if (propValue != null) {
            isRequired = propValue;
        }
        if (isRequired) {
            aliasRef.throwInternalError("MDX Set Alias is not supported. The set alias should not be created!");
        }
        MDXSetAliasDefinition definition = aliasRef.getDefinition();
        IXQEQueryNode parent = aliasRef.getParent();
        IXQEQueryNode definitionExpr = definition.getChild(0);
        IXQEQueryNode newChild = MDXBuilder.deepCopyExcludingCMDefs(factory, (AbstractMDXNode)definitionExpr, false);
        parent.exchangeChildNode(aliasRef, newChild);
        List<MDXSetAliasReference> saRefs = definition.getSetAliasRefs();
        saRefs.remove(aliasRef);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = false;
        XQETrace trace = environment.getTrace();
        MDXQuery query = (MDXQuery)node.getAncestorOfType(1002);
        if (query.setAliasSupported()) {
            this.traceNodeCondition(status, "The query supports MDX Set Alias.", trace);
            return status;
        }
        status = true;
        this.traceNodeCondition(status, "The query does not support MDX Set Alias. Set Alias defined in query need to be replaced with it's definition.", trace);
        return status;
    }
}

