/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.MDXDateTimeConstant;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class UpdateDateTimeConstant
extends Transformation {
    private static final String TIME_PORTION = " 00:00:00";
    static final String UPDATE_DATETIME_DONE = "dateTimeValueUpdated";

    public UpdateDateTimeConstant() {
        this.mName = "Fix dateTime constant by adding time portion if it is missing";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1151};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXDateTimeConstant dateTimeConst = (MDXDateTimeConstant)node;
        Value dateTimeValue = dateTimeConst.getConstantValue();
        String strValue = ((Value)dateTimeConst.getPropertyValue("value")).getString();
        if (dateTimeValue.getDataType().isDate()) {
            strValue = strValue + TIME_PORTION;
            TimestampValue tsValue = DataValueFactory.createTimestampValue();
            tsValue.set(strValue);
            ((MDXDateTimeConstant)node).setConstantValue(tsValue);
        } else if (dateTimeValue.getDataType().isTimestamp()) {
            int timeSeparatorPos = strValue.indexOf(" ");
            if (timeSeparatorPos >= 0) {
                strValue = strValue.substring(0, timeSeparatorPos);
            }
            DateValue dtValue = DataValueFactory.createDateValue();
            dtValue.set(strValue);
            ((MDXDateTimeConstant)node).setConstantValue(dtValue);
        }
        node.setPropertyValue(UPDATE_DATETIME_DONE, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        node.throwOnInvalidChildCategories();
        if (!node.getParent().isOfCategory(1070)) {
            this.traceNodeCondition(false, "Transformation only needed for comparison on dateTime constant.", trace);
            return false;
        }
        IXQEQueryNode[] children = node.getParent().getChildren();
        MDXDateTimeConstant dateTimeConst = (MDXDateTimeConstant)node;
        Value dateTimeValue = dateTimeConst.getConstantValue();
        IXQEQueryNode sibling = null;
        if (children[0].equals(node)) {
            sibling = children[1];
        } else if (children[1].equals(node)) {
            sibling = children[0];
        }
        if (node.getPropertyValue(UPDATE_DATETIME_DONE) != null) {
            this.traceNodeCondition(false, "DateTime constant already updated.", trace);
            return false;
        }
        if (!this.isDifferentDateTimeDataTypes(sibling, dateTimeValue)) {
            this.traceNodeCondition(false, "Transformation only needed when two sides are different dateTime dataTypes.", trace);
            return false;
        }
        this.traceNodeCondition(true, "MSAS dateTime value can't have millisecond part.", trace);
        return true;
    }

    public boolean isDifferentDateTimeDataTypes(IXQEQueryNode node, Value dateTimeValue) {
        IMember memberMeta;
        AbstractMDXMember baseMember;
        boolean isDiffDataType = false;
        if (node.isOfCategory(1158)) {
            node = node.getChild(0);
        }
        if (node.isOfCategory(1016)) {
            if (((CogMDXProperties)node).isDateTimeProperty() && dateTimeValue.getDataType().isDate() || ((CogMDXProperties)node).isDateProperty() && dateTimeValue.getDataType().isTimestamp()) {
                isDiffDataType = true;
            }
        } else if (node.isOfCategory(1059) && node.getChild(0).getType() == 1069 && (baseMember = (AbstractMDXMember)((MDXTuple)node.getChild(0)).getChild(0)).getType() == 1067 && ((BaseMember)baseMember).isMeasure() && ((memberMeta = ((BaseMember)baseMember).getMember()).getDataType().isTimestamp() && dateTimeValue.getDataType().isDate() || memberMeta.getDataType().isDate() && dateTimeValue.getDataType().isTimestamp())) {
            isDiffDataType = true;
        }
        return isDiffDataType;
    }
}

