/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.for_clause;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeForClause;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class NormalizeForClause
extends Transformation {
    public static final String PROP_APPLIED = "NormalizeForClauseApplied";

    public NormalizeForClause() {
        this.mName = "Normalize For Clause.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{1138};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeForClause tNode = (TNodeForClause)node;
        MDXLevelInfo levelInfo = tNode.getLevelInfo();
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            AbstractMDXSet child = (AbstractMDXSet)node.getChild(i);
            IHierarchy currHierarchy = child.getHierarchyInfo().getProjectedHierarchy(0);
            MDXLevelInfo currLevelInfo = child.getLevelInfo();
            if (levelInfo.getLowestProjectedLevel(currHierarchy).equals(currLevelInfo.getLowestProjectedLevel(currHierarchy))) continue;
            node.detachChild(i);
        }
        node.setPropertyValue(PROP_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation has already been applied to the target node.", trace);
            return false;
        }
        TNodeForClause tNode = (TNodeForClause)node;
        String forType = tNode.getForType();
        if (!(forType.equals("for") || forType.equals("forAll") || forType.equals("forAny"))) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not of type TNodeForClause.FOR/FOR_ANY/FOR_ALL.", trace);
            return false;
        }
        if (tNode.getPropertyValue("ValidateForClauseDataItemsApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "ValidateForClauseDataItems has not been applied to the target node.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target TNodeForClause node.", trace);
        return true;
    }
}

