/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.for_clause;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeForClause;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;

public final class ProcessForReportClause
extends Transformation {
    public ProcessForReportClause() {
        this.mName = "Process For Report Clause.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{1138};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXLevelInfo levelInfo = mdxQuery.getLevelInfo();
        ArrayList<MDXMembers> mdxMembersExprs = new ArrayList<MDXMembers>();
        for (IHierarchy hierarchy : levelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            if (hierarchy.getDimension().isMeasuresDimension()) continue;
            ILevel level = mdxQuery.getLowestReferencedLevel(hierarchy);
            MDXMembers mdxMembers = MDXBuilder.buildMDXMembersExpr((IXQENodeFactory)factory, level);
            mdxMembers.flagContextIndependent();
            mdxMembersExprs.add(mdxMembers);
        }
        if (mdxMembersExprs.size() == 0) {
            IHierarchy hierarchy = mdxQuery.getMeasuresHierarchy();
            AbstractMDXNode currentMeasure = MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy);
            currentMeasure = MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, currentMeasure);
            node.getParent().exchangeChildNode(node, currentMeasure);
            return;
        }
        IXQEQueryNode forReportSet = null;
        for (MDXMembers mdxMembers : mdxMembersExprs) {
            if (forReportSet == null) {
                forReportSet = mdxMembers;
                continue;
            }
            IXQEQueryNode mdxCrossjoin = factory.createNode(1030);
            mdxCrossjoin.addChild(forReportSet);
            mdxCrossjoin.addChild(mdxMembers);
            forReportSet = mdxCrossjoin;
        }
        MDXNamedSetReference nsRef = MDXBuilder.buildMDXNamedSet(factory, mdxQuery, "", forReportSet);
        node.getParent().exchangeChildNode(node, nsRef);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        TNodeForClause tNode = (TNodeForClause)node;
        String forType = tNode.getForType();
        if (!forType.equals("forReport")) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not of type TNodeForClause.FOR_REPORT.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target TNodeForClause node.", trace);
        return true;
    }
}

