/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.for_clause;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeForClause;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.slicer_detailfilter.application.DFSLAggrUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class ValidateForClauseDataItemProjection
extends Transformation {
    public ValidateForClauseDataItemProjection() {
        this.mName = "Validate For Clause Data Items against Projection.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1138};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        TNodeForClause tNode = (TNodeForClause)node;
        String forType = tNode.getForType();
        if (!(forType.equals("for") || forType.equals("forAll") || forType.equals("forAny"))) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not of type TNodeForClause.FOR/FOR_ANY/FOR_ALL.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            AbstractMDXNode child = (AbstractMDXNode)node.getChild(i);
            MDXLevelInfo levelInfo = child.getLevelInfo();
            IHierarchy hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0);
            AbstractMDXSet[] detailSets = DFSLAggrUtil.getGroupNestDetailSets(mdxQuery, hierarchy);
            if (!mdxQuery.getMDXFrom().getCube().getModelDataSource().isRelational() && detailSets.length == 0) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppFORExprHierNoProjDetails);
            }
            for (int j = 0; j < detailSets.length; ++j) {
                MDXLevelInfo detailLevelInfo = detailSets[j].getLevelInfo();
                if (levelInfo.getLowestProjectedLevel(hierarchy).getIndex() <= detailLevelInfo.getHighestProjectedLevel(hierarchy).getIndex()) continue;
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppFORExprProjsLevelsBelowProjDetails);
            }
        }
        this.traceNodeCondition(false, "The target TNodeForClause node is valid.", trace);
        return false;
    }
}

