/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.for_clause.report;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeForClause;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;

public final class ProcessForReportClause
extends Transformation {
    public ProcessForReportClause() {
        this.mName = "Process For Report Clause.";
        this.mPassNumbers = new int[]{13};
        this.mTypes = new int[]{1138};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge[] edges = mdxQuery.getEdges();
        ArrayList<MDXEdge> edgesWithNonMeasureHierarchies = new ArrayList<MDXEdge>();
        for (int i = 0; i < edges.length; ++i) {
            edges[i].throwOnInvalidChildCategories();
            MDXHierInfo hierInfo = edges[i].getHierarchyInfo();
            if (hierInfo.getNumberOfNonMeasureHierarchiesProjected() == 0) continue;
            edgesWithNonMeasureHierarchies.add(edges[i]);
        }
        if (edgesWithNonMeasureHierarchies.size() == 0) {
            IHierarchy hierarchy = mdxQuery.getMeasuresHierarchy();
            MDXCurrentMember currentMeasure = MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy);
            node.getParent().exchangeChildNode(node, currentMeasure);
            return;
        }
        IXQEQueryNode forReportSet = null;
        for (MDXEdge edge : edgesWithNonMeasureHierarchies) {
            IXQEQueryNode set = edge.getChild(0);
            if (forReportSet == null) {
                forReportSet = factory.deepCopyNode(set);
                continue;
            }
            IXQEQueryNode mdxCrossjoin = factory.createNode(1030);
            mdxCrossjoin.addChild(forReportSet);
            mdxCrossjoin.addChild(factory.deepCopyNode(set));
            forReportSet = mdxCrossjoin;
        }
        MDXNamedSetReference nsRef = MDXBuilder.buildMDXNamedSet(factory, mdxQuery, "", (AbstractMDXSet)forReportSet);
        node.getParent().exchangeChildNode(node, nsRef);
        IXQEQueryNode[] cogMDXGroupNodes = forReportSet.getDescendantsOfType(1027, true);
        for (int i = 0; i < cogMDXGroupNodes.length; ++i) {
            CogMDXGroup cogMDXGroup = (CogMDXGroup)cogMDXGroupNodes[i];
            cogMDXGroup.throwOnInvalidChildCategories();
            if (cogMDXGroup.getNumberChildren() == 2) {
                cogMDXGroup.setProjectDetailsOnly();
            }
            if (cogMDXGroup.getAncestorOfType(1027) == null) {
                cogMDXGroup.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
            }
            AbstractMDXSet set = (AbstractMDXSet)cogMDXGroup.getChild(0);
            IXQEQueryNode[] mdxMembersNodes = set.getDescendantsOfType(1040, true);
            for (int j = 0; j < mdxMembersNodes.length; ++j) {
                MDXHierInfo contextInfo;
                MDXHierInfo hierInfo = ((MDXMembers)mdxMembersNodes[j]).getHierarchyInfo();
                if (hierInfo.projectedHierarchiesOverlap(contextInfo = ((MDXMembers)mdxMembersNodes[j]).getContextHierarchyInfo())) continue;
                ((MDXMembers)mdxMembersNodes[j]).flagContextIndependent();
            }
        }
        IXQEQueryNode tNodeRemoveNonDetailSets = factory.createNode(1139);
        forReportSet.insertParent(tNodeRemoveNonDetailSets);
        environment.enableLockNodeQueryPlanning(1139);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        TNodeForClause tNode = (TNodeForClause)node;
        String forType = tNode.getForType();
        if (!forType.equals("forReport")) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not of type TNodeForClause.FOR_REPORT.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target TNodeForClause node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation can be applied to the target TNodeForClause node.", trace);
        return true;
    }
}

