/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.intersecting_wds;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.NodeCondition;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckLowerSOWDS
extends NodeCondition {
    public static final int CHECK_SIMPLE = 1;
    public static final int CHECK_COMPLEX = 2;
    MDXCalculatedMemberReference calcRef;
    AbstractMDXNode ancestorNode;
    int checkType;

    public CheckLowerSOWDS(MDXCalculatedMemberReference aCalcRef, AbstractMDXNode aAncestorNode, int aCheckType) {
        this.calcRef = aCalcRef;
        this.ancestorNode = aAncestorNode;
        this.checkType = aCheckType;
    }

    @Override
    public boolean applies(IXQEQueryNode node) {
        if (!super.applies(node)) {
            return false;
        }
        if (this.calcRef == null || this.ancestorNode == null) {
            return false;
        }
        MDXCalculatedMemberReference calc = (MDXCalculatedMemberReference)node;
        return this.ancestorNode.isProjectedDescendant((AbstractMDXNode)node) && this.isWithinDetailCalc(calc) && calc.getSolveOrder() < this.calcRef.getSolveOrder();
    }

    private boolean isWithinDetailCalc(MDXCalculatedMemberReference calc) {
        if (this.checkType == 1) {
            return CheckLowerSOWDS.isSimpleWithinDetailCalc(calc);
        }
        if (this.checkType == 2) {
            return CheckLowerSOWDS.isComplexWithinDetailCalc(calc);
        }
        calc.throwInternalError("Unknown check type");
        return false;
    }

    @Override
    public void applies(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> returnNodes) {
        if (nodes.size() == 0) {
            return;
        }
        super.applies(nodes, returnNodes);
        if (this.ancestorNode == null || this.calcRef == null) {
            return;
        }
        if (nodes.size() > 0) {
            MDXCalculatedMemberReference calc = null;
            ArrayList<IXQEQueryNode> nodeList = new ArrayList<IXQEQueryNode>();
            for (IXQEQueryNode node : nodes) {
                calc = (MDXCalculatedMemberReference)node;
                if (calc.getSolveOrder() >= this.calcRef.getSolveOrder() || !this.isWithinDetailCalc(calc)) continue;
                nodeList.add(node);
            }
            this.ancestorNode.isProjectedDescendant(nodeList, returnNodes);
        }
    }

    public static boolean isSimpleWithinDetailCalc(MDXCalculatedMemberReference calc) {
        MDXCalculatedMemberDefinition def = calc.getDefinition();
        if (!def.getChild(0).isOfCategory(1088)) {
            return false;
        }
        AbstractMDXNumericValueFunction func = (AbstractMDXNumericValueFunction)def.getChild(0);
        return func.isWithinDetailCalc();
    }

    public static boolean isComplexWithinDetailCalc(MDXCalculatedMemberReference calc) {
        MDXCalculatedMemberDefinition def = calc.getDefinition();
        if (CheckLowerSOWDS.isSimpleWithinDetailCalc(calc)) {
            return false;
        }
        List<IXQEQueryNode> functions = def.getDescendantsOfCategory(1088, false);
        for (IXQEQueryNode f : functions) {
            AbstractMDXNumericValueFunction func = (AbstractMDXNumericValueFunction)f;
            if (!func.isWithinDetailCalc()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAncestorNode(AbstractMDXNode node) {
        return this.ancestorNode == node;
    }
}

