/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.measure;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class AppendDefaultMeasureToMDXCalculatedMemberDefinition
extends Transformation {
    public AppendDefaultMeasureToMDXCalculatedMemberDefinition() {
        this.mName = "Append report default measure to MDXCalculatedMemberDefinition nodes which belong to the measure dimension.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1005};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXNode definition = (AbstractMDXNode)node.getChild(0);
        boolean includeSelf = false;
        IXQEQueryNode[] tuples = definition.getDescendantsOfType(1069, includeSelf);
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXMember queryDefaultMeasure = mdxQuery.getQueryDefaultMeasure();
        for (int i = 0; i < tuples.length; ++i) {
            MDXTuple tuple = (MDXTuple)tuples[i];
            if (tuple.getHierarchyInfo().projectsMeasures()) continue;
            IXQEQueryNode defaultMeasure = nodeFactory.deepCopyNode(queryDefaultMeasure);
            tuple.addChild(defaultMeasure);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        node.throwOnInvalidChildCategories();
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The node is not under a MDXQuery node.", trace);
            return false;
        }
        if (mdxQuery.getFirstChildByType(1092) == null) {
            this.traceNodeCondition(false, "The MDXQuery node does not have a CogMDXDefaultMeasure child node.", trace);
            return false;
        }
        MDXCalculatedMemberDefinition mdxCalculatedMemberDefinition = (MDXCalculatedMemberDefinition)node;
        if (!mdxCalculatedMemberDefinition.getHierarchyInfo().projectsMeasures()) {
            this.traceNodeCondition(false, "The MDXCalculatedMemberDefinition node does not belong to the measure dimension.", trace);
            return false;
        }
        StringBuilder msgStr = new StringBuilder();
        boolean status = false;
        AbstractMDXNode definition = (AbstractMDXNode)node.getChild(0);
        switch (definition.getType()) {
            case 1059: 
            case 1084: 
            case 1085: {
                msgStr.append("The calculation defintion is a ");
                msgStr.append(definition.getNodeTypeName());
                msgStr.append(".");
                status = true;
                break;
            }
            default: {
                msgStr.append("The calculation defintion could not posibly contain MDXTuple nodes.");
                status = false;
            }
        }
        if (status) {
            boolean includeSelf = false;
            IXQEQueryNode[] tuples = definition.getDescendantsOfType(1069, includeSelf);
            boolean bl = status = tuples.length > 0;
            if (status) {
                int i;
                String s1 = " which is not projecting the measure dimension.";
                for (i = 0; i < tuples.length; ++i) {
                    MDXTuple tuple = (MDXTuple)tuples[i];
                    if (tuple.getHierarchyInfo().projectsMeasures()) continue;
                    status = true;
                    msgStr.append(" The calculation contains at least one MDXTuple node");
                    msgStr.append(s1);
                    break;
                }
                if (i == tuples.length) {
                    status = false;
                    msgStr.append(" The calculation does not contain any MDXTuple node");
                    msgStr.append(s1);
                }
            } else {
                status = false;
                msgStr.append(" The calculation does not contain MDXTuple nodes.");
            }
        }
        this.traceNodeCondition(status, msgStr.toString(), trace);
        return status;
    }
}

