/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.measure;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.List;

public class CreateCalculatedMeasureForBaseMeasure
extends Transformation {
    public CreateCalculatedMeasureForBaseMeasure() {
        this.mName = "Create Calculated Measure for Base Measures";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1067};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IHierarchy hierarchy = ((BaseMember)node).getHierarchy();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        List<IXQEQueryNode> measures = edge.getDescendantsOfTypeOrdered(1067, false);
        measures.remove(node);
        measures.add(node);
        for (int i = 0; i < measures.size(); ++i) {
            BaseMember measure = (BaseMember)measures.get(i);
            if (!node.isSameExpression(measure, false) || ((BaseMember)node).getRollupAggregate() != measure.getRollupAggregate() || !edge.isProjectedDescendant(measure)) continue;
            IXQEQueryNode parent = measure.getParent();
            int position = parent.getPositionOfChild(measure);
            measure.detach();
            StringBuilder newCalcMemberName = new StringBuilder("_DBM");
            IMember member = measure.getMember();
            if (member != null && member.getName() != null && !member.getName().isEmpty()) {
                newCalcMemberName.append("_");
                newCalcMemberName.append(member.getName());
            }
            MDXCalculatedMemberReference newCalcMember = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, hierarchy, newCalcMemberName.toString(), measure, SolveOrderUtil.getCubeCalcSolveOrder());
            MDXBuilder.coerceToNumericValueExpression(measure, factory);
            parent.addChild(newCalcMember, position);
            newCalcMember.setRollupAggregate(measure.getRollupAggregate());
            RSAPIEdgeRowset rowset = null;
            CogMDXNest nest = (CogMDXNest)newCalcMember.getAncestorOfType(1026);
            if (nest == null) {
                CogMDXGroup group = (CogMDXGroup)newCalcMember.getAncestorOfType(1027);
                if (group != null) {
                    rowset = group.getRSAPIEdgeRowset();
                }
            } else {
                rowset = nest.getRSAPIEdgeRowset();
            }
            if (rowset == null) continue;
            newCalcMember.getDefinition().setPropertyValue("v5Caption", measure.getMember().getCaptionValue().getString());
            newCalcMember.getDefinition().setPropertyValue("v5Name", measure.getMember().getV5UniqueName());
            newCalcMember.setIsV5CalculatedMember();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        if (edge == null) {
            this.traceNodeCondition(false, "The node is not a descendant of an MDXEdge node.", trace);
            return false;
        }
        BaseMember measure = (BaseMember)node;
        if (!measure.isMeasure()) {
            this.traceNodeCondition(false, "The node is not a base measure.", trace);
            return false;
        }
        if (!edge.isProjectedDescendant(measure)) {
            this.traceNodeCondition(false, "The measure is not projected on the edge.", trace);
            return false;
        }
        List<IXQEQueryNode> measures = edge.getDescendantsOfTypeOrdered(1067, true);
        V5RollupAggregateEnum priorityRollUpAggregate = null;
        for (IXQEQueryNode m : measures) {
            BaseMember refMeasure = (BaseMember)m;
            V5RollupAggregateEnum refMeasureRollup = refMeasure.getRollupAggregate();
            if (refMeasure == measure || !refMeasure.isSameExpression(measure, false) || refMeasureRollup == measure.getRollupAggregate() || !edge.isProjectedDescendant(refMeasure)) continue;
            if (priorityRollUpAggregate == null) {
                priorityRollUpAggregate = refMeasureRollup;
                continue;
            }
            if (refMeasureRollup.compareTo(priorityRollUpAggregate) <= 0) continue;
            priorityRollUpAggregate = refMeasureRollup;
        }
        if (priorityRollUpAggregate != null && measure.getRollupAggregate().compareTo(priorityRollUpAggregate) > 0) {
            this.traceNodeCondition(true, "The same measure is projected twice with different rollup aggregates and the rollup aggregate of the current node has priority", trace);
            return true;
        }
        if (priorityRollUpAggregate != null) {
            this.traceNodeCondition(false, "The same measure is projected twice with different rollup aggregates but the rollup aggregate of the current node does not have priority", trace);
            return false;
        }
        this.traceNodeCondition(false, "The same measure is not projected twice with different rollup aggregates.", trace);
        return false;
    }
}

