/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.nestedlevelcalculation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.ITNodeAddMemberToContext;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class AddNLCToContext
extends Transformation {
    public AddNLCToContext() {
        this.mName = "Add a Nested Level Calculation to the nested expression's context.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)factory.deepCopyNode(node);
        AbstractMDXNode secondChild = (AbstractMDXNode)node.getParent().getParent().getChild(1);
        ITNodeAddMemberToContext tNode = MDXBuilder.insertTNodeAddMemberToContext(factory, secondChild, calcRef);
        environment.enableLockNodeQueryPlanning(tNode.getType());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        if (!calcRef.getDefinition().isNestedLevelCalc()) {
            this.traceNodeCondition(false, "The calculated member is not a grouped nested level expression.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent == null || parent.getType() != 1039 || parent.getParent().getType() != 1027 || parent.getParent().getPositionOfChild(parent) != 0) {
            this.traceNodeCondition(false, "The calculation is not the only first child of the parent group node.", trace);
            return false;
        }
        CogMDXGroup parentGroup = (CogMDXGroup)parent.getParent();
        if (parentGroup.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "The parent group node only has one child.", trace);
            return false;
        }
        AbstractMDXNode secondChild = (AbstractMDXNode)parentGroup.getChild(1);
        if (!secondChild.isContextDependent(calcRef.getHierarchy())) {
            this.traceNodeCondition(false, "The second child of the parent group is not dependent on this calculated member.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The calculated member must be added to the context of the parent group's second child.", trace);
        return true;
    }
}

