/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.ITNodeAddMemberToContext;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.nestedlevelcalculation.Util;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class AddDefMemberToContextDepCalcs
extends Transformation {
    public AddDefMemberToContextDepCalcs() {
        this.mName = "Add Default Member To Context Dependent Calculations.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition calcDef = calcRef.getDefinition();
        IHierarchy hierarchy = calcDef.getHierarchy();
        AbstractMDXMember memberToAdd = null;
        if (hierarchy.getDimension().isMeasuresDimension()) {
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            memberToAdd = (AbstractMDXMember)factory.deepCopyNode(mdxQuery.getQueryDefaultMeasure());
        } else {
            memberToAdd = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, calcDef.getHierarchy());
        }
        ITNodeAddMemberToContext tNode = MDXBuilder.insertTNodeAddMemberToContext(factory, (AbstractMDXNode)calcDef.getChild(0), memberToAdd);
        if (calcDef.isUserHierarchy()) {
            int aSeverity = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_DefinitionDependentOnItself));
        }
        environment.enableLockNodeQueryPlanning(tNode.getType());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IHierarchy hierarchy;
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXCalculatedMemberDefinition calcDef = calcRef.getDefinition();
        if (!calcDef.isContextDependent(hierarchy = calcDef.getHierarchy())) {
            this.traceNodeCondition(false, "The defintion is not context dependent on the hierarchy it's defined in.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The node is not a descendant of the MDXQuery node.", trace);
            return false;
        }
        List<IXQEQueryNode> calcRefs = mdxQuery.getCalcMemberRefForDefinition(calcDef);
        StringBuilder sb = new StringBuilder();
        for (IXQEQueryNode currCalcRef : calcRefs) {
            if (!Util.isNestedLevelCalculation((MDXCalculatedMemberReference)currCalcRef, sb)) continue;
            this.traceNodeCondition(false, sb.toString(), trace);
            return false;
        }
        this.traceNodeCondition(true, "The defintion is context dependent on the hierarchy it's defined in and the calculation is not a nested level calculation.", trace);
        return true;
    }
}

