/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class AddDefMemberToContextForAggregates
extends Transformation {
    public static final String PROPERTY_TRANSFORMATION_APPLIED = "AddDefMemberToContextForAggregatesApplied";

    public AddDefMemberToContextForAggregates() {
        this.mName = "Add Default Member To Context Of Aggregate Set For Hierarchies Projected On Opposite Edge.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1060, 1012, 1087, 1100};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean lockeTNodeAddMemberToContext = false;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge mdxEdge = this.findEdgeNode(mdxQuery, node);
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i] == mdxEdge) continue;
            MDXHierInfo edgeHierInfo = edges[i].getHierarchyInfo();
            for (int j = 0; j < edgeHierInfo.getNumProjectedHierarchies(); ++j) {
                IHierarchy hierarchy = edgeHierInfo.getProjectedHierarchy(j);
                if (hierarchy.getDimension().isMeasuresDimension()) continue;
                MDXDefaultMember mdxDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, hierarchy);
                AbstractMDXNode childSet = node.getType() == 1100 ? (AbstractMDXNode)node.getChild(1) : (AbstractMDXNode)node.getChild(0);
                MDXBuilder.insertTNodeAddMemberToContext(factory, childSet, mdxDefaultMember);
                lockeTNodeAddMemberToContext = true;
            }
        }
        node.setPropertyValue(PROPERTY_TRANSFORMATION_APPLIED, Boolean.TRUE);
        if (lockeTNodeAddMemberToContext) {
            environment.enableLockNodeQueryPlanning(1126);
        }
    }

    private MDXEdge findEdgeNode(MDXQuery mdxQuery, IXQEQueryNode node) {
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        if (edge != null) {
            return edge;
        }
        MDXCalculatedMemberDefinition definition = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        if (definition == null) {
            return null;
        }
        List<IXQEQueryNode> references = mdxQuery.getCalcMemberRefForDefinition(definition);
        for (MDXCalculatedMemberReference mDXCalculatedMemberReference : references) {
            MDXEdge extraEdge;
            if (!(edge != null ? (extraEdge = this.findEdgeNode(mdxQuery, mDXCalculatedMemberReference)) != edge : (edge = this.findEdgeNode(mdxQuery, mDXCalculatedMemberReference)) == null)) continue;
            return null;
        }
        return edge;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROPERTY_TRANSFORMATION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation was already applied to this node.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXEdge edge = null;
        if (mdxQuery != null) {
            edge = this.findEdgeNode(mdxQuery, node);
        }
        if (edge == null) {
            this.traceNodeCondition(false, "Unable to find the MDXEdge node this summary is projected on.", trace);
            return false;
        }
        int setPosition = 0;
        if (node.getType() == 1100) {
            setPosition = 1;
        }
        IXQEQueryNode[] cogMDXGroupNodes = node.getChild(setPosition).getDescendantsOfType(1027, true);
        for (int i = 0; i < cogMDXGroupNodes.length; ++i) {
            if (!((CogMDXGroup)cogMDXGroupNodes[i]).projectDetailsOnly()) continue;
            this.traceNodeCondition(true, "The set expression for the aggregate projects details.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The set expression for the aggregate doesn't project details.", trace);
        return false;
    }
}

