/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.CogMDXCompleteTuple;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;
import java.util.Set;

public final class ConvertCogMDXCompleteTupleToMDXTuple
extends Transformation {
    public ConvertCogMDXCompleteTupleToMDXTuple() {
        this.mName = "Convert CogMDXCompleteTuple To MDXTuple.";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{1099};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Set<IHierarchy> hierarchies = ((CogMDXCompleteTuple)node).getAvoidDimensionLine() ? mdxQuery.getReferencedHierarchiesOnEdges() : mdxQuery.getReferencedHierarchiesOnEdgesAndDimLine();
        List<IHierarchy> hierList = ((CogMDXCompleteTuple)node).getCurrentMemberHierarchies();
        boolean tagCompleteTupleForDMR = this.needTagCompleteTupleForDMR(mdxQuery, node);
        for (int childIdx = 0; childIdx < node.getNumberChildren(); ++childIdx) {
            IHierarchy opHier = ((AbstractMDXMember)node.getChild(childIdx)).getHierarchy();
            hierList.add(opHier);
        }
        for (IHierarchy hierarchy : hierarchies) {
            if (tagCompleteTupleForDMR && hierarchy.getDimension().getName().equals("tagDimension") || hierList.contains(hierarchy)) continue;
            node.addChild(MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, hierarchy));
        }
        if (tagCompleteTupleForDMR) {
            CubeWrapper cubeWrapper = (CubeWrapper)mdxQuery.getMDXFrom().getCube();
            ILevel tagLevel = cubeWrapper.getTagCompleteTupleLevel();
            IMember mun = tagLevel.getMembers().get(0);
            node.addChild(MDXBuilder.buildMDXBaseMemberExpr(factory, mun.getUniqueName(), tagLevel));
        }
        node.exchange(factory.createNode(1069), true);
    }

    protected boolean needTagCompleteTupleForDMR(MDXQuery mdxQuery, IXQEQueryNode completeTuple) {
        if ((Boolean)completeTuple.getPropertyValue("FromV5CompleteTuple") != Boolean.TRUE) {
            return false;
        }
        if (!mdxQuery.isDMR()) {
            return false;
        }
        boolean bNeedToTagCompleteTuple = false;
        CubeWrapper cubeWrapper = (CubeWrapper)mdxQuery.getMDXFrom().getCube();
        List<CogMDXDetailFilter> pushedFilters = cubeWrapper.getDetailFilters();
        for (CogMDXDetailFilter filter : pushedFilters) {
            if (filter.getPropertyValue("dmrSlicer") == Boolean.TRUE) {
                bNeedToTagCompleteTuple = true;
                continue;
            }
            IDimension dimension = filter.getDimensionFromModel();
            if (dimension != null) continue;
            filter.setPropertyValue("dmrSlicer", Boolean.TRUE);
            bNeedToTagCompleteTuple = true;
        }
        return bNeedToTagCompleteTuple;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getAncestorOfType(1002) == null) {
            node.throwInternalError("Unable to find the ancestor MDXQuery node.");
            return false;
        }
        this.traceNodeCondition(true, "The child nodes of the CogMDXCompleteTuple node are valid.", trace);
        return true;
    }
}

