/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class ConvertComparisonOperatorsToFunctions
extends Transformation {
    private static final String COMP_OPERATOR_TO_FUNCTION_NOT_NEEDED = "This comparison operator does not need to be transformed.";

    public ConvertComparisonOperatorsToFunctions() {
        this.mName = "Convert Contains, StartsWith, EndsWith operators into functions for SAP LOLAP";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1070};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXComparisonOperator compNode = (MDXComparisonOperator)node;
        int fnType = compNode.getOperatorType();
        if (fnType != 9 && fnType != 7 && fnType != 8) {
            this.traceNodeCondition(false, COMP_OPERATOR_TO_FUNCTION_NOT_NEEDED, trace);
            return false;
        }
        if (compNode.getMDXSyntax() != 0) {
            this.traceNodeCondition(false, "This comparison operator has already been transformed.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The comparison is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        if (mdxQuery.getCapabilities().isSupported("v5.useLocalOLAP")) {
            this.traceNodeCondition(true, "The query will be executed by local OLAP and needs transformation.", trace);
            return true;
        }
        if (DataSourceTypeEnum.isTM1(mdxQuery.getDataSourceType()) && MultiRequestContext.RequestProcessing.DATABASEONLY == mdxQuery.getRequestProcessing()) {
            this.traceNodeCondition(true, "The query will be executed by TM1 in database only mode and needs transformation.", trace);
            return true;
        }
        String datasourceType = mdxQuery.getDataSourceType();
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        String useLolapForFunctions = capabilities.getStringValue("v5.useLOLAPForFunctions", Boolean.FALSE.toString());
        if (!DataSourceTypeEnum.isRelational(datasourceType) && useLolapForFunctions.equals("false")) {
            this.traceNodeCondition(false, COMP_OPERATOR_TO_FUNCTION_NOT_NEEDED, trace);
            return false;
        }
        this.traceNodeCondition(true, "This comparison operator function must be transformed.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXComparisonOperator fn = (MDXComparisonOperator)node;
        fn.setMDXSyntax(2);
    }
}

