/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class FlagContextIndependentMembersExpressions
extends Transformation {
    public static final String PROP_FLAG_CONTEXT_INDEPENDENT_MEMBERS_EXPRESSIONS_APPLIED = "FlagContextIndependentMembersExpressionsApplied";

    public FlagContextIndependentMembersExpressions() {
        this.mName = "Flag context independent Members expressions.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode firstChild = node.getChild(0);
        IXQEQueryNode secondChild = node.getChild(1);
        MDXHierInfo mdxSetHierInfo = ((AbstractMDXSet)firstChild).getHierarchyInfo();
        List<IHierarchy> hierarchies = mdxSetHierInfo.getProjectedHierarchies();
        for (IHierarchy hierarchy : hierarchies) {
            if (((AbstractMDXNode)secondChild).isContextDependent(hierarchy)) continue;
            IXQEQueryNode[] memberSet = secondChild.getDescendantsOfType(1040, true);
            for (int i = 0; i < memberSet.length; ++i) {
                MDXMembers aMemberSet = (MDXMembers)memberSet[i];
                if (!aMemberSet.getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                aMemberSet.flagContextIndependent();
            }
        }
        node.setPropertyValue(PROP_FLAG_CONTEXT_INDEPENDENT_MEMBERS_EXPRESSIONS_APPLIED, "");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "The Generate expression has invalid number of children.", trace);
            return false;
        }
        if (node.getPropertyValue(PROP_FLAG_CONTEXT_INDEPENDENT_MEMBERS_EXPRESSIONS_APPLIED) != null) {
            this.traceNodeCondition(false, "FlagContextIndependentMembersExpressions has been applied to this node.", trace);
            return false;
        }
        return true;
    }
}

