/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public final class FlagToShieldContextDependency
extends Transformation {
    public FlagToShieldContextDependency() {
        this.mName = "Flag context dependent sets as condext independent.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1010, 1011, 1009};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        List<IXQEQueryNode> sets = node.getDescendantsOfCategory(1021, false);
        for (int i = 0; i < sets.size(); ++i) {
            AbstractMDXSet set = (AbstractMDXSet)sets.get(i);
            if (!set.isContextDependent((AbstractMDXNode)node, true) && (set.getType() != 1040 || set.isFlaggedContextIndependent()) || set.getParent().getType() == 1105) continue;
            IXQEQueryNode tnode = factory.createNode(1105);
            set.insertParent(tnode);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        if (mdxQuery.getCapabilities().isSupported("mdx.support.namedSetDynamic") && node.getChild(0).getPropertyValue("mdx.support.namedSetDynamic") != null) {
            this.traceNodeCondition(false, "This is a dynamic named set expression, do not change context dependency.", trace);
            return false;
        }
        boolean status = false;
        List<IXQEQueryNode> sets = node.getDescendantsOfCategory(1021, false);
        for (int i = 0; i < sets.size() && !status; ++i) {
            AbstractMDXSet set = (AbstractMDXSet)sets.get(i);
            if (!set.isContextDependent((AbstractMDXNode)node, true) && (set.getType() != 1040 || set.isFlaggedContextIndependent()) || set.getParent().getType() == 1105) continue;
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "A set expression is context dependent and should be context independent.", trace);
        } else {
            this.traceNodeCondition(status, "No set expressions are context dependent but should be context independent.", trace);
        }
        return status;
    }
}

