/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.normalization.RemoveMDXCurrentMemberFromValueExpressionTuples;

public final class HideROLAPRelativeTimeMember
extends Transformation {
    public static final String PROP_CALCULATED_MEMBER = "calcMember";

    public HideROLAPRelativeTimeMember() {
        this.mName = "Hide ROLAP relative time members.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1187};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node.getChild(0);
        calcRef.getDefinition().detach();
        node.setPropertyValue(PROP_CALCULATED_MEMBER, calcRef);
        calcRef.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] currentMembers;
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The transformation has already been applied.", trace);
            return false;
        }
        node.throwOnInvalidChildCategories();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node.getChild(0);
        for (IXQEQueryNode currentMember : currentMembers = calcRef.getDefinition().getDescendantsOfType(1076, false)) {
            if (!RemoveMDXCurrentMemberFromValueExpressionTuples.nodeCondition((MDXCurrentMember)currentMember, null)) continue;
            this.traceNodeCondition(false, "Current member normalization must occur first.", trace);
            return false;
        }
        this.traceNodeCondition(false, "The transformation can be applied.", trace);
        return false;
    }
}

