/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;

public final class NormalizeSolveOrders
extends Transformation {
    public NormalizeSolveOrders() {
        this.mName = "Normalize solve orders.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1005, 1028};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        int[] types = new int[]{1005, 1028};
        IXQEQueryNode[] calcs = mdxQuery.getDescendantsOfTypes(types, false);
        calcs = SolveOrderUtil.sortCMBySolveOrder(calcs);
        int lastV5SO = SolveOrderUtil.getUndefinedMDXSolveOrder();
        int lastMDXSO = 0;
        for (int i = 0; i < calcs.length; ++i) {
            int solveOrder = SolveOrderUtil.getSolveOrder(calcs[i]);
            if (solveOrder == SolveOrderUtil.getUndefinedMDXSolveOrder() || solveOrder == SolveOrderUtil.getMaxMDXSolveOrder() || SolveOrderUtil.isAbsoluteSolveOrder(calcs[i]).booleanValue()) continue;
            if (lastV5SO != solveOrder) {
                lastMDXSO += SolveOrderUtil.getIncNormalizedSolveOrder();
            }
            SolveOrderUtil.setSolveOrder(calcs[i], lastMDXSO);
            lastV5SO = solveOrder;
        }
        mdxQuery.setSolveOrdersNormalized();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.isSolveOrdersNormalized()) {
            this.traceNodeCondition(false, "The solve orders have already been normalized.", trace);
            return false;
        }
        int solveOrder = SolveOrderUtil.getSolveOrder(node);
        if (solveOrder == SolveOrderUtil.getMaxMDXSolveOrder() || solveOrder == SolveOrderUtil.getUndefinedMDXSolveOrder() || SolveOrderUtil.isAbsoluteSolveOrder(node).booleanValue()) {
            this.traceNodeCondition(false, "The solve order for the node does not need to be normalized.", trace);
            return false;
        }
        this.traceNodeCondition(false, "Solve orders can be normalized.", trace);
        return true;
    }
}

