/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.ragged_unbalanced.AbstractRaggedUnbalancedTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;

public final class OrderCogMDXNestNodesByHierarchyAndLevel
extends Transformation {
    public static final String APPLIED = "OrderCogMDXNestNodesByHierarchyAndLevel_Applied";
    public static final String OPEN_PAREHTHESIS = "(";
    public static final String CLOSE_PAREHTHESIS = ")";
    public static final String DELIMITER = ", ";

    public OrderCogMDXNestNodesByHierarchyAndLevel() {
        this.mName = "Group CogMDXNest Nodes By Hierarchy And Level.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{1026};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXNest targetNest = (CogMDXNest)node;
        List<IXQEQueryNode> cogMDXNestNodes = targetNest.getDescendantsOfTypeOrdered(1026, true);
        ListIterator<IXQEQueryNode> it = cogMDXNestNodes.listIterator();
        HashMap<IXQEQueryNode, MDXLevelInfo> levelInfoMap = new HashMap<IXQEQueryNode, MDXLevelInfo>();
        ArrayList<IXQEQueryNode> sets = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> orderedSets = new ArrayList<IXQEQueryNode>();
        while (it.hasNext()) {
            CogMDXNest cogMDXNest = (CogMDXNest)it.next();
            MDXLevelInfo levelInfo = OrderCogMDXNestNodesByHierarchyAndLevel.getFirstChildLevelInfo(cogMDXNest);
            levelInfoMap.put(cogMDXNest.getChild(0), levelInfo);
            sets.add(cogMDXNest.getChild(0));
        }
        IXQEQueryNode[] ancestorGroups = targetNest.getAncestorsOfType(1027);
        IXQEQueryNode parent = targetNest.getAncestorOfType(1027);
        if (parent != null) {
            IHierarchy nodeHierarchy = ((AbstractMDXNode)targetNest.getChild(0)).getHierarchyInfo().getProjectedHierarchy(0);
            MDXHierInfo parentHierInfo = ((AbstractMDXSet)parent.getChild(0)).getHierarchyInfo();
            IHierarchy parentHierarchy = parentHierInfo.getProjectedHierarchy(0);
            if (!parentHierarchy.equals(nodeHierarchy)) {
                for (IXQEQueryNode ancestorGroup : ancestorGroups) {
                    CogMDXGroup currGroup = (CogMDXGroup)ancestorGroup;
                    IHierarchy currAncestorHierarchy = ((AbstractMDXNode)currGroup.getChild(0)).getHierarchyInfo().getProjectedHierarchy(0);
                    if (currGroup == parent || !nodeHierarchy.equals(currAncestorHierarchy)) continue;
                    MDXQuery mdxQuery = (MDXQuery)currGroup.getAncestorOfType(1002);
                    throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedInconsistentHierOnListReportEdge, nodeHierarchy.getName(), (Object)currGroup.getRefDataItemProperty(), (Object)targetNest.getRefDataItemProperty(), (Object)mdxQuery.getRefQueryProperty());
                }
            }
            if (parentHierInfo.getNumProjectedHierarchies() > 0) {
                it = sets.listIterator();
                while (it.hasNext()) {
                    AbstractMDXSet set = (AbstractMDXSet)it.next();
                    if (!((MDXLevelInfo)levelInfoMap.get(set)).getHierarchyInfo().projectsHierarchy(parentHierarchy)) continue;
                    sets.remove(set);
                    orderedSets.add(set);
                    break;
                }
            }
        }
        it = sets.listIterator();
        while (it.hasNext()) {
            this.insertSetOrderedAscendingByLevelNumber(orderedSets, (AbstractMDXSet)it.next(), levelInfoMap);
        }
        it = orderedSets.listIterator();
        HashMap<AbstractMDXSet, Map<String, Object>> nodeProperties = new HashMap<AbstractMDXSet, Map<String, Object>>(orderedSets.size());
        while (it.hasNext()) {
            AbstractMDXSet set = (AbstractMDXSet)it.next();
            nodeProperties.put(set, set.getParent().getProperties());
            set.detach();
        }
        it = cogMDXNestNodes.listIterator();
        while (it.hasNext()) {
            CogMDXNest cogMDXNest = (CogMDXNest)it.next();
            cogMDXNest.addChild((IXQEQueryNode)orderedSets.remove(0), 0);
            Map properties = (Map)nodeProperties.get(cogMDXNest.getChild(0));
            OrderCogMDXNestNodesByHierarchyAndLevel.transferCogMDXNestProperties(cogMDXNest, properties);
        }
        targetNest.setPropertyValue(APPLIED, Boolean.TRUE);
    }

    public static void transferCogMDXNestProperties(CogMDXNest cogMDXNest, Map<String, Object> properties) {
        String refDataItemName = (String)properties.get("refDataItem");
        cogMDXNest.setRefDataItemProperty(refDataItemName);
        List rsapiDataItemList = (List)properties.get("RSAPIRefDataItemList");
        cogMDXNest.resetRSAPIDataItems(rsapiDataItemList);
        RSAPIEdgeRowset rsapiEdgeRowset = (RSAPIEdgeRowset)properties.get("RSAPIEdgeRowset");
        cogMDXNest.setRSAPIEdgeRowset(rsapiEdgeRowset);
        SortedMap dataItemIndexesProjectingSameSet = (SortedMap)properties.get("dataItemIndexesProjectingSameSet");
        cogMDXNest.setDataItemIndexesProjectingSameSet(dataItemIndexesProjectingSameSet);
        Integer nDepth = (Integer)properties.get("nestingDepthOfContextForProperty");
        cogMDXNest.setPropertyValue("nestingDepthOfContextForProperty", nDepth);
        String[] contextDataItems = (String[])properties.get("contextDataItems");
        cogMDXNest.setContextNames(contextDataItems);
    }

    private void insertSetOrderedAscendingByLevelNumber(List<IXQEQueryNode> setList, AbstractMDXSet set, Map<IXQEQueryNode, MDXLevelInfo> levelInfoMap) {
        boolean sortRequired;
        MDXLevelInfo levelInfo = levelInfoMap.get(set);
        MDXHierInfo hierInfo = levelInfo.getHierarchyInfo();
        if (levelInfo.isEmpty() && hierInfo.getNumProjectedHierarchies() == 0) {
            setList.add(set);
            return;
        }
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        boolean bl = sortRequired = levelInfo.projectsLevels() || levelInfo.isEmpty() && hierarchy.getLevelCount() > 0 && set.getType() == 1145;
        if (sortRequired) {
            boolean bl2 = sortRequired = !hierarchy.getDimension().isMeasuresDimension();
        }
        if (!sortRequired) {
            IXQEQueryNode lastSet;
            MDXLevelInfo lastSetlevelInfo;
            MDXHierInfo lastSetHierInfo;
            if (!setList.isEmpty() && !hierarchy.getDimension().isMeasuresDimension() && (lastSetHierInfo = (lastSetlevelInfo = levelInfoMap.get(lastSet = setList.get(setList.size() - 1))).getHierarchyInfo()).getNumProjectedHierarchies() > 0 && lastSetHierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
                setList.add(setList.size() - 1, set);
                return;
            }
            setList.add(set);
            return;
        }
        int lastNonMeasureIndex = setList.size();
        ListIterator<IXQEQueryNode> it1 = setList.listIterator();
        while (it1.hasNext()) {
            AbstractMDXSet currSet1 = (AbstractMDXSet)it1.next();
            MDXLevelInfo levelInfo1 = levelInfoMap.get(currSet1);
            IHierarchy measureHierarchy = levelInfo1.getHierarchyInfo().getProjectedHierarchy(0);
            if (!measureHierarchy.getDimension().isMeasuresDimension()) continue;
            lastNonMeasureIndex = it1.previousIndex();
            break;
        }
        ILevel setLowestLevel = null;
        ILevel setHighestLevel = null;
        if (hierarchy.getLevelCount() > 0) {
            setLowestLevel = levelInfo.getLowestProjectedLevel(hierarchy);
            setHighestLevel = levelInfo.getHighestProjectedLevel(hierarchy);
        }
        ListIterator<IXQEQueryNode> it = setList.listIterator();
        boolean foundHierarchy = false;
        while (it.hasNext()) {
            AbstractMDXSet currSet = (AbstractMDXSet)it.next();
            MDXLevelInfo currSetlevelInfo = levelInfoMap.get(currSet);
            if (currSetlevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                if (setLowestLevel == null) {
                    it.add(set);
                    return;
                }
                boolean curSetProjectsCM = set.projectsCalculatedMember();
                ILevel currSetLowestLevel = currSetlevelInfo.getLowestProjectedLevel(hierarchy);
                if (!curSetProjectsCM && currSetLowestLevel != null && setLowestLevel.getIndex() < currSetLowestLevel.getIndex()) {
                    setList.add(it.previousIndex(), set);
                    return;
                }
                ILevel highestProjectedLevel = currSetlevelInfo.getHighestProjectedLevel(hierarchy);
                if (!curSetProjectsCM && highestProjectedLevel != null && setHighestLevel.getIndex() < currSetlevelInfo.getHighestProjectedLevel(hierarchy).getIndex()) {
                    setList.add(it.previousIndex(), set);
                    return;
                }
                foundHierarchy = true;
                continue;
            }
            if (!foundHierarchy) continue;
            setList.add(it.previousIndex(), set);
            return;
        }
        setList.add(lastNonMeasureIndex, set);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXNest targetNest = (CogMDXNest)node;
        if (targetNest.getAncestorOfType(1026) == null) {
            boolean isReOrderingRequired = OrderCogMDXNestNodesByHierarchyAndLevel.isReOrderingRequiredForCogMDXNests(targetNest, environment);
            if (isReOrderingRequired) {
                this.traceNodeCondition(true, "Hierarchy order is broken for at least one hiearchy.", trace);
                return true;
            }
            this.traceNodeCondition(false, "Hierarchy order is not broken for at least one hiearchy.", trace);
            return false;
        }
        this.traceNodeCondition(false, "The node is not the top/outer most CogMDXNest node.", trace);
        return false;
    }

    public static boolean isReOrderingRequiredForCogMDXNests(CogMDXNest topNest, PlanningEnvironment environment) {
        AbstractMDXSet currentCogMDX = topNest;
        boolean isReverseOrder = false;
        boolean isLevelsOverlap = false;
        boolean areHierDispersed = false;
        int measureHierPosition = -1;
        boolean innerMostFound = false;
        int currentHierarchyPos = -1;
        Object lastHierarchy = null;
        ArrayList<IHierarchy> previousHierarchies = new ArrayList<IHierarchy>();
        IXQEQueryNode parentGroup = topNest.getAncestorOfType(1027);
        IHierarchy parentGroupHier = null;
        if (parentGroup != null) {
            MDXHierInfo parentGroupHierInfo = ((AbstractMDXSet)parentGroup.getChild(0)).getHierarchyInfo();
            parentGroupHier = parentGroupHierInfo.getProjectedHierarchy(0);
        }
        boolean firstTimeForHier = false;
        while (!innerMostFound) {
            List<IXQEQueryNode> nestedCogMDXNests;
            IHierarchy currentNestHierarchy = ((AbstractMDXSet)currentCogMDX.getChild(0)).getHierarchyInfo().getProjectedHierarchy(0);
            if (!previousHierarchies.contains(currentNestHierarchy)) {
                firstTimeForHier = true;
                ++currentHierarchyPos;
                previousHierarchies.add(currentNestHierarchy);
            } else if (!lastHierarchy.equals(currentNestHierarchy)) {
                areHierDispersed = true;
            }
            if (parentGroupHier != null && previousHierarchies.size() > 1 && parentGroupHier.equals(currentNestHierarchy)) {
                areHierDispersed = true;
            }
            XQEBaseQueryNode innermostCogMDX = null;
            if (currentNestHierarchy.getDimension().isMeasuresDimension() && measureHierPosition == -1) {
                measureHierPosition = currentHierarchyPos;
            }
            if ((nestedCogMDXNests = currentCogMDX.getDescendantsOfTypeOrdered(1026, false)).isEmpty()) {
                innerMostFound = true;
                break;
            }
            if (lastHierarchy != null && lastHierarchy.equals(currentNestHierarchy)) {
                currentCogMDX = (AbstractMDXSet)nestedCogMDXNests.get(0);
                continue;
            }
            lastHierarchy = currentNestHierarchy;
            MDXHierInfo currentNestHierInfo = ((AbstractMDXSet)currentCogMDX.getChild(1)).getHierarchyInfo();
            currentCogMDX = (AbstractMDXSet)nestedCogMDXNests.get(0);
            if (currentNestHierarchy.getDimension().isMeasuresDimension() || !currentNestHierInfo.projectsHierarchy(currentNestHierarchy) || !firstTimeForHier) continue;
            firstTimeForHier = false;
            for (IXQEQueryNode nestedCogMDXNest : nestedCogMDXNests) {
                if (!((AbstractMDXSet)nestedCogMDXNest.getChild(0)).getHierarchyInfo().projectsHierarchy((IHierarchy)lastHierarchy)) continue;
                if (nestedCogMDXNest.getNumberChildren() == 1) {
                    innermostCogMDX = (AbstractMDXSet)nestedCogMDXNest;
                    break;
                }
                MDXHierInfo nestedCogMDXNestHierInfo = ((AbstractMDXSet)nestedCogMDXNest.getChild(1)).getHierarchyInfo();
                if (nestedCogMDXNest.getNumberChildren() != 2 || nestedCogMDXNestHierInfo.projectsHierarchy((IHierarchy)lastHierarchy)) continue;
                innermostCogMDX = (AbstractMDXSet)nestedCogMDXNest;
                break;
            }
            if (innermostCogMDX == null) continue;
            boolean[] result = new boolean[]{isReverseOrder, isLevelsOverlap};
            MDXQuery mdxQuery = (MDXQuery)innermostCogMDX.getAncestorOfType(1002);
            boolean restrictMultiLevelOverlap = MDXQuery.restrictMultiLevelOverlap(mdxQuery);
            OrderCogMDXNestNodesByHierarchyAndLevel.checkNestedHierarchyLevels((AbstractMDXSet)innermostCogMDX, 1026, (IHierarchy)lastHierarchy, result, environment, restrictMultiLevelOverlap);
            isReverseOrder = result[0];
            isLevelsOverlap = result[1];
        }
        if (areHierDispersed) {
            return true;
        }
        if (measureHierPosition != currentHierarchyPos) {
            return true;
        }
        return isReverseOrder || isLevelsOverlap;
    }

    public static List<String> checkNestedHierarchyLevels(AbstractMDXSet innermostCogMDX, int innermostCogMDXType, IHierarchy targetHierarchy, boolean[] result, PlanningEnvironment environment, boolean restrictMultiLevelOverlap) {
        return OrderCogMDXNestNodesByHierarchyAndLevel.checkNestedHierarchyLevels(innermostCogMDX, innermostCogMDXType, targetHierarchy, result, environment, restrictMultiLevelOverlap, new ArrayList<IXQEQueryNode>());
    }

    public static List<String> checkNestedHierarchyLevels(AbstractMDXSet innermostCogMDX, int innermostCogMDXType, IHierarchy targetHierarchy, boolean[] result, PlanningEnvironment environment, boolean restrictMultiLevelOverlap, List<IXQEQueryNode> context) {
        AbstractMDXSet currCogMDX;
        boolean isReverseOrder = result[0];
        boolean isLevelsOverlap = result[1];
        AbstractMDXSet ancestorCogMDX = currCogMDX = innermostCogMDX;
        ArrayList<MDXLevelInfo> levelInfosForTargetHier = new ArrayList<MDXLevelInfo>();
        MDXLevelInfo levelInfo = OrderCogMDXNestNodesByHierarchyAndLevel.getFirstChildLevelInfo(innermostCogMDX);
        levelInfosForTargetHier.add(levelInfo);
        ArrayList<String> overlappingDataItems = new ArrayList<String>();
        while (ancestorCogMDX != null) {
            MDXHierInfo ancestorNestHierInfo;
            while (ancestorCogMDX != null && (ancestorCogMDX = (AbstractMDXSet)ancestorCogMDX.getAncestorOfType(innermostCogMDXType)) != null && !(ancestorNestHierInfo = ((AbstractMDXSet)ancestorCogMDX.getChild(0)).getHierarchyInfo()).projectsHierarchy(targetHierarchy)) {
            }
            if (ancestorCogMDX == null) break;
            if (!OrderCogMDXNestNodesByHierarchyAndLevel.isProjected(currCogMDX)) {
                currCogMDX = ancestorCogMDX;
                continue;
            }
            if (!OrderCogMDXNestNodesByHierarchyAndLevel.isProjected(ancestorCogMDX)) {
                currCogMDX = ancestorCogMDX;
                continue;
            }
            String refDataItem = currCogMDX.getRefDataItemProperty();
            if (!overlappingDataItems.contains(refDataItem)) {
                overlappingDataItems.add(refDataItem);
                context.add(currCogMDX);
            }
            if (!overlappingDataItems.contains(refDataItem = ancestorCogMDX.getRefDataItemProperty())) {
                overlappingDataItems.add(refDataItem);
                context.add(ancestorCogMDX);
            }
            levelInfo = OrderCogMDXNestNodesByHierarchyAndLevel.getFirstChildLevelInfo(ancestorCogMDX);
            levelInfosForTargetHier.add(levelInfo);
            int orderType = AbstractRaggedUnbalancedTransformation.isNestingOrderNatural(currCogMDX, ancestorCogMDX, targetHierarchy);
            switch (orderType) {
                case 1: {
                    isReverseOrder = true;
                    break;
                }
                case -1: {
                    isLevelsOverlap = true;
                    break;
                }
            }
            currCogMDX = ancestorCogMDX;
        }
        if (isLevelsOverlap && restrictMultiLevelOverlap) {
            String dataItemList = OrderCogMDXNestNodesByHierarchyAndLevel.generateParenthesisDelimitedList(overlappingDataItems);
            OrderCogMDXNestNodesByHierarchyAndLevel.validateOverlapForMultilevelSets(innermostCogMDX, targetHierarchy, levelInfosForTargetHier, environment, dataItemList);
        }
        result[0] = isReverseOrder;
        result[1] = isLevelsOverlap;
        return overlappingDataItems;
    }

    public static String generateParenthesisDelimitedList(List<String> stringList) {
        StringBuilder darenthesisDelimitedList = new StringBuilder(OPEN_PAREHTHESIS);
        for (String overlappingDataItem : stringList) {
            darenthesisDelimitedList.append(overlappingDataItem);
            darenthesisDelimitedList.append(DELIMITER);
        }
        int offSet = darenthesisDelimitedList.lastIndexOf(DELIMITER);
        darenthesisDelimitedList.replace(offSet, darenthesisDelimitedList.length(), CLOSE_PAREHTHESIS);
        return darenthesisDelimitedList.toString();
    }

    private static void validateOverlapForMultilevelSets(AbstractMDXSet innermostCogMDX, IHierarchy targetHierarchy, List<MDXLevelInfo> levelInfosForTargetHier, PlanningEnvironment environment, String dataItemList) {
        int maxNumOfCorrelatedSets = 2;
        ArrayList<MDXLevelInfo> noDuplMultiLevelInfos = new ArrayList<MDXLevelInfo>();
        ArrayList<MDXLevelInfo> noDuplLevelInfos = new ArrayList<MDXLevelInfo>();
        for (MDXLevelInfo currLevelInfro : levelInfosForTargetHier) {
            boolean firstTime = true;
            for (MDXLevelInfo currnoDuplLevelInfo : noDuplLevelInfos) {
                if (!currnoDuplLevelInfo.compareProjectedLevels(currLevelInfro, targetHierarchy)) continue;
                firstTime = false;
                break;
            }
            if (!firstTime) continue;
            noDuplLevelInfos.add(currLevelInfro);
            if (currLevelInfro.getProjectedLevels(targetHierarchy).size() <= 2) continue;
            noDuplMultiLevelInfos.add(currLevelInfro);
        }
        if (noDuplMultiLevelInfos.isEmpty() || noDuplLevelInfos.size() < 3) {
            return;
        }
        for (MDXLevelInfo multiLevelInfo : noDuplMultiLevelInfos) {
            int setOverlapCount = 0;
            for (MDXLevelInfo currnoDuplLevelInfo : noDuplLevelInfos) {
                if (!currnoDuplLevelInfo.projectedLevelsOverlap(multiLevelInfo)) continue;
                ++setOverlapCount;
            }
            if (setOverlapCount < 3) continue;
            String innermostDataItemName = innermostCogMDX.getRefDataItemProperty();
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedMultiLevelOverlap, (Object)targetHierarchy.getName(), (Object)dataItemList, (Object)innermostDataItemName);
        }
    }

    private static MDXLevelInfo getFirstChildLevelInfo(AbstractMDXSet targetSet) {
        AbstractMDXSet currSet = (AbstractMDXSet)targetSet.getChild(0);
        MDXLevelInfo levelInfo = currSet.getLevelInfo();
        return levelInfo;
    }

    public static boolean isProjected(AbstractMDXSet targetSet) {
        boolean isP = true;
        if (targetSet.getType() == 1026) {
            if (((CogMDXNest)targetSet).getRSAPIEdgeRowset() == null) {
                isP = false;
            }
        } else if (targetSet.getType() == 1027) {
            if (((CogMDXGroup)targetSet).getRSAPIEdgeRowset() == null) {
                isP = false;
            }
            if (isP) {
                isP = !((CogMDXGroup)targetSet).isNormalizationGroup();
            }
        } else {
            targetSet.throwInternalError("Type?");
        }
        if (isP) {
            IXQEQueryNode ancestorGroup = targetSet.getAncestorOfType(1028);
            isP = ancestorGroup == null;
        }
        return isP;
    }
}

