/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXCompleteTuple;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveMDXCurrentMemberFromValueExpressionTuples
extends Transformation {
    public RemoveMDXCurrentMemberFromValueExpressionTuples() {
        this.mName = "Remove MDXCurrentMember From Value Expression Tuples";
        this.mPassNumbers = new int[]{5, 20};
        this.mTypes = new int[]{1076};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 1099) {
            IHierarchy hierarchy = ((MDXCurrentMember)node).getHierarchy();
            ((CogMDXCompleteTuple)parent).addCurrentMemberHierarchy(hierarchy);
        }
        node.detach();
        if (parent.getNumberChildren() == 0) {
            IXQEQueryNode greatGrandParent = parent.getParent().getParent();
            IXQEQueryNode grandParent = parent.getParent();
            greatGrandParent.detachChild(grandParent);
        }
    }

    public static boolean nodeCondition(MDXCurrentMember node, StringBuilder msgStr) {
        if (node.getParent().isOfCategory(1069) && ((MDXTuple)node.getParent()).isValueExpressionOperand() && node.getParent().getParent().getType() == 1059) {
            IXQEQueryNode greatGrandParent = node.getParent().getParent().getParent();
            if (!greatGrandParent.isOfCategory(1001)) {
                if (msgStr != null) {
                    msgStr.append("The great-grandparent node of the target MDXCurrentMember node is not an AbstractMDXNode node.");
                }
                return false;
            }
            if (((AbstractMDXNode)greatGrandParent).isTransformationNode()) {
                if (msgStr != null) {
                    msgStr.append("The great-grandparent node of the target MDXCurrentMember node is a transformation node which must be resolved before this transformation can be applied.");
                }
                return false;
            }
            if (greatGrandParent.isOfCategory(1060) || greatGrandParent.getType() == 1012) {
                if (msgStr != null) {
                    msgStr.append("The target MDXCurrentMember node is the child of an MDXTuple node which is used as a value expression and is the child of an MDXSummaryFunction node, so it can be removed.");
                }
                return true;
            }
            if (node.getParent().getNumberChildren() > 1) {
                if (msgStr != null) {
                    msgStr.append("The target MDXCurrentMember node is the child of an MDXTuple node which is used as a value expression and has multiple child nodes, so it can be removed.");
                }
                return true;
            }
            if (msgStr != null) {
                msgStr.append("The target MDXCurrentMember node is used in a value expression, however it is the only child of an MDXTuple node that cannot be removed.");
            }
            return false;
        }
        if (msgStr != null) {
            msgStr.append("The target MDXCurrentMember node is not used in a value expression context.");
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder errorMsg = null;
        if (trace.getTraceLevel() != 0) {
            errorMsg = new StringBuilder();
        }
        boolean status = RemoveMDXCurrentMemberFromValueExpressionTuples.nodeCondition((MDXCurrentMember)node, errorMsg);
        String traceMsg = null;
        if (errorMsg != null) {
            traceMsg = errorMsg.toString();
        }
        this.traceQueryCondition(status, traceMsg, trace);
        return status;
    }
}

