/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.normalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXCubeCalculatedDefaultMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class ReplaceDefaultMemberWithCalculatedMemberReference
extends Transformation {
    public ReplaceDefaultMemberWithCalculatedMemberReference(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace the default member with the MDXCalculatedMemberReference in CogMDXCubeCalculatedDefaultMember.";
        this.mTypes = new int[]{1077};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXDefaultMember mdxDefaultMember = (MDXDefaultMember)node;
        IHierarchy hierarchy = mdxDefaultMember.getHierarchy();
        MDXCalculatedMemberReference cubeCalculatedDefaultMember = this.searchCalculatedDefaultMemberRef(mdxQuery, hierarchy);
        XQENodeFactory nf = environment.getNodeFactory();
        MDXCalculatedMemberReference cubeCalculatedDefaultMemberCopy = (MDXCalculatedMemberReference)nf.deepCopyNode(cubeCalculatedDefaultMember);
        cubeCalculatedDefaultMemberCopy.setPropertyValue("isDefaultMember", Boolean.TRUE);
        mdxDefaultMember.exchange(cubeCalculatedDefaultMemberCopy);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXDefaultMember mdxDefaultMember;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXCalculatedMemberReference cubeCalculatedDefaultMember = this.searchCalculatedDefaultMemberRef(mdxQuery, (mdxDefaultMember = (MDXDefaultMember)node).getHierarchy());
        if (cubeCalculatedDefaultMember != null) {
            MDXCalculatedMemberDefinition defn = cubeCalculatedDefaultMember.getDefinition();
            LinkedHashSet<IHierarchy> hierarchies = new LinkedHashSet<IHierarchy>();
            LinkedHashSet<AbstractMDXNode> visited = new LinkedHashSet<AbstractMDXNode>();
            defn.getReferencedHierarchies(hierarchies, visited);
            ArrayList<IXQEQueryNode> nodeList = new ArrayList<IXQEQueryNode>();
            for (IXQEQueryNode iXQEQueryNode : visited) {
                IXQEQueryNode[] defaultMemberList = iXQEQueryNode.getDescendantsOfType(1077, true);
                if (defaultMemberList == null) continue;
                nodeList.addAll(Arrays.asList(defaultMemberList));
            }
            for (IXQEQueryNode iXQEQueryNode : nodeList) {
                MDXDefaultMember innerMember = (MDXDefaultMember)iXQEQueryNode;
                if (innerMember.getHierarchy() != defn.getHierarchy()) continue;
                this.traceNodeCondition(false, "The default calculated member is referencing itself.", trace);
                throw new XQERuntimeException(XQEMessageKeys.PLN_CircularReferenceForCalculatedDefaultMember, defn.getHierarchy().getUniqueName());
            }
            this.traceNodeCondition(true, "Able to replace the default member with a resolved calculated member reference.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Can't find a suitable resolved calculated member that can substitute the default member.", trace);
        return false;
    }

    private MDXCalculatedMemberReference searchCalculatedDefaultMemberRef(MDXQuery mdxQuery, IHierarchy hierarchy) {
        IXQEQueryNode[] defaultMemberList;
        for (IXQEQueryNode n : defaultMemberList = mdxQuery.getDescendantsOfType(1184, false)) {
            IXQEQueryNode child = ((CogMDXCubeCalculatedDefaultMember)n).getChild(0);
            if (!child.isOfCategory(1013) || !((MDXCalculatedMemberReference)child).getHierarchy().equals(hierarchy)) continue;
            return (MDXCalculatedMemberReference)child;
        }
        return null;
    }
}

