/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdjustFilterOnLevelPropertiesScope
extends Transformation {
    private static final String PASSED_MSG = "The hierarchy filter scope is adjusted to the level scope.";
    private static final String LEVEL_DIFF_HIERARCHY_MSG = "The Level property is from different hierarchy.";
    private static final List<Integer> SUPPORTED_OPERATIONS = Arrays.asList(1, 9, 7, 8);

    public AdjustFilterOnLevelPropertiesScope() {
        this.mName = "Adjust Filter On Level Properties Scope";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{1053};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXFilter filterNode = (MDXFilter)node;
        IXQEQueryNode propertyNode = filterNode.getChild(1).getFirstDescendantOfTypeOrdered(1016, false);
        CogMDXProperties cogMDXProperties = (CogMDXProperties)propertyNode;
        AbstractMDXSet levelSet = (AbstractMDXSet)cogMDXProperties.getChild(1);
        BaseLevel baseLevel = (BaseLevel)levelSet.getChild(0);
        MDXMembers newLevelSet = MDXBuilder.buildMDXMembersExpr((IXQENodeFactory)nodeFactory, baseLevel.getLevel());
        AbstractMDXSet filterSet = (AbstractMDXSet)filterNode.getChild(0);
        filterSet.exchange(newLevelSet);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean setIsHierarchy;
        XQETrace trace = environment.getTrace();
        MDXFilter filterNode = (MDXFilter)node;
        AbstractMDXSet filterSet = (AbstractMDXSet)filterNode.getChild(0);
        boolean bl = setIsHierarchy = filterSet.getType() == 1040 && filterSet.getChild(0).getType() == 1073;
        if (!setIsHierarchy) {
            this.traceNodeCondition(false, "The filtered set is not a hierarchy member set.", trace);
            return false;
        }
        IHierarchy hierarchy = ((BaseHierarchy)filterSet.getChild(0)).getHierarchy();
        IXQEQueryNode comparisonNode = filterNode.getChild(1);
        if (this.isSimpleLevelPropertyComparison(comparisonNode, trace)) {
            ILevel level = this.getLevelOfLevelProperty((MDXComparisonOperator)comparisonNode);
            if (hierarchy == level.getHierarchy()) {
                this.traceNodeCondition(true, PASSED_MSG, trace);
                return true;
            }
            this.traceNodeCondition(false, LEVEL_DIFF_HIERARCHY_MSG, trace);
            return false;
        }
        if (comparisonNode.getType() == 1070) {
            return false;
        }
        if (!this.isSupportedLogicalOperation(comparisonNode)) {
            this.traceNodeCondition(false, "Only MDX_AND and MDX_OR are currently supported.", trace);
            return false;
        }
        HashSet<ILevel> levels = new HashSet<ILevel>();
        if (!this.isApplicableForOptimization(comparisonNode, hierarchy, levels, trace)) {
            this.traceNodeCondition(false, "The filter condition is unsupported for this optimization.", trace);
            return false;
        }
        this.traceNodeCondition(true, PASSED_MSG, trace);
        return true;
    }

    private boolean isSimpleLevelPropertyComparison(IXQEQueryNode node, XQETrace trace) {
        if (node.getType() != 1070) {
            return false;
        }
        MDXComparisonOperator comparisonOperator = (MDXComparisonOperator)node;
        if (comparisonOperator.getChild(0).getType() != 1016) {
            this.traceNodeCondition(false, "The filter condition is not on a member property.", trace);
            return false;
        }
        if (!SUPPORTED_OPERATIONS.contains(comparisonOperator.getOperatorType())) {
            this.traceNodeCondition(false, "Unsupported comparison operator: " + comparisonOperator.getOperatorTypeString(), trace);
            return false;
        }
        CogMDXProperties cogMDXProperties = (CogMDXProperties)comparisonOperator.getChild(0);
        boolean setIsLevel = false;
        if (cogMDXProperties.getChild(1).isOfCategory(1021)) {
            AbstractMDXSet baseSet = (AbstractMDXSet)cogMDXProperties.getChild(1);
            setIsLevel = baseSet.getType() == 1040 && baseSet.getChild(0).getType() == 1065;
        }
        IXQEQueryNode compareToNode = comparisonOperator.getChild(1);
        if (!setIsLevel || compareToNode.getType() != 1127 && compareToNode.getType() != 1064) {
            this.traceNodeCondition(false, "The filter condition is not a simple level property comparison.", trace);
            return false;
        }
        return true;
    }

    private ILevel getLevelOfLevelProperty(MDXComparisonOperator comparisonOperator) {
        CogMDXProperties cogMDXProperties = (CogMDXProperties)comparisonOperator.getChild(0);
        AbstractMDXSet baseSet = (AbstractMDXSet)cogMDXProperties.getChild(1);
        BaseLevel baseLevel = (BaseLevel)baseSet.getChild(0);
        return baseLevel.getLevel();
    }

    private boolean isSupportedLogicalOperation(IXQEQueryNode operationNode) {
        return operationNode.isOfCategory(1071) && (operationNode.getType() == 1110 || operationNode.getType() == 1111);
    }

    private boolean isApplicableForOptimization(IXQEQueryNode operationNode, IHierarchy hierarchy, Set<ILevel> levels, XQETrace trace) {
        IXQEQueryNode firstChild = operationNode.getChild(0);
        IXQEQueryNode secondChild = operationNode.getChild(1);
        return this.isApplicableOperand(firstChild, hierarchy, levels, trace) && this.isApplicableOperand(secondChild, hierarchy, levels, trace) && levels.size() == 1;
    }

    private boolean isApplicableOperand(IXQEQueryNode operandNode, IHierarchy hierarchy, Set<ILevel> levels, XQETrace trace) {
        if (this.isSupportedLogicalOperation(operandNode)) {
            return this.isApplicableForOptimization(operandNode, hierarchy, levels, trace);
        }
        if (!this.isSimpleLevelPropertyComparison(operandNode, trace)) {
            return false;
        }
        ILevel level = this.getLevelOfLevelProperty((MDXComparisonOperator)operandNode);
        levels.add(level);
        return hierarchy == level.getHierarchy() && levels.size() == 1;
    }
}

