/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.optimization.IdentifyPushdownCandidate;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class IdentifyPushdownCandidateNamedSet
extends Transformation {
    public static final String PUSHDOWN_NAMEDSET_APPLIED = "pushdown_namedset_applied";
    public static final int[] PUSHDOWNTYPES = new int[]{1041, 1042, 1053};

    public IdentifyPushdownCandidateNamedSet() {
        this.mName = "Push the evaluation of an expression to underlying data source.";
        this.mPassNumbers = new int[]{47};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.setPropertyValue(PUSHDOWN_NAMEDSET_APPLIED, Boolean.TRUE);
        List<IXQEQueryNode> sortedNamedSet = this.getSortedNamedSet(mdxQuery);
        if (sortedNamedSet == null || sortedNamedSet.isEmpty()) {
            return;
        }
        double levelOOMThreshold = mdxQuery.getGovernors().getEnablePushdownLevelOOM();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (IXQEQueryNode ns : sortedNamedSet) {
            IXQEQueryNode c;
            int nC = ns.getNumberChildren();
            if (nC != 1 || !IdentifyPushdownCandidate.isSupportedPushdownTarget(c = ns.getChild(0), PUSHDOWNTYPES) || c.getType() == 1042 && IdentifyPushdownCandidate.hasFilterSkippingMembers(mdxQuery) || !IdentifyPushdownCandidate.isValidCustomSetPushdownTarget(environment, c, null, PUSHDOWNTYPES)) continue;
            MDXOOMContext context = new MDXOOMContext("dmr");
            MDXOOMInfo r = ((AbstractMDXSet)c.getChild(0)).computeOOM(context);
            if (r.getOOM() <= levelOOMThreshold) continue;
            IXQEQueryNode tNode = nodeFactory.createNode(1191);
            c.insertParent(tNode);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        Object b = mdxQuery.getPropertyValue(PUSHDOWN_NAMEDSET_APPLIED);
        if (b != null) {
            this.traceNodeCondition(false, "Pushdown for Large Level through CustomSet is done.", trace);
            return false;
        }
        if (!mdxQuery.isDMR()) {
            this.traceNodeCondition(false, "The MDXQuery is NOT a DMR query. ", trace);
            return false;
        }
        if (mdxQuery.isDMRCubeReuseEnabled()) {
            this.traceNodeCondition(false, "Reusable DMR cube does not support CustomSet pushdown.", trace);
            return false;
        }
        Governors gv = mdxQuery.getGovernors();
        if (gv == null || gv.getEnablePushdownLevelOOM() <= 0.0) {
            this.traceNodeCondition(false, "Pushdown for Large Level through CustomSet is not enabled.", trace);
            return false;
        }
        IXQEQueryNode[] namedSets = mdxQuery.getChildrenOfType(1003);
        if (namedSets.length > 0) {
            this.traceNodeCondition(true, "Need to try Pushdown in Named set for Large Level through CustomSet.", trace);
            return true;
        }
        this.traceNodeCondition(false, "No Named set for Pushdown for Large Level through CustomSet.", trace);
        return false;
    }

    protected List<IXQEQueryNode> getSortedNamedSet(MDXQuery mdxQuery) {
        IXQEQueryNode[] cmANDnmChildren;
        int refType = 1014;
        ArrayList<IXQEQueryNode> queryNodehelper1 = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> queryNodehelper2 = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode c : cmANDnmChildren = mdxQuery.getChildrenOfType(1003)) {
            if (c.getDescendantsOfType(refType, false).length == 0) {
                queryNodehelper1.add(c);
                continue;
            }
            queryNodehelper2.add(c);
        }
        Iterator it = queryNodehelper2.iterator();
        while (it.hasNext()) {
            AbstractMDXNode calcDef = (AbstractMDXNode)it.next();
            List<AbstractMDXNode> refNodes = calcDef.getDescendantsOfType(refType, false, false, false, false, false);
            boolean addNode = true;
            Iterator<AbstractMDXNode> itRef = refNodes.iterator();
            while (addNode && itRef.hasNext()) {
                AbstractMDXNode calcRefDef = itRef.next();
                if (!queryNodehelper2.contains(((MDXNamedSetReference)calcRefDef).getDefinition())) continue;
                addNode = false;
            }
            if (!addNode) continue;
            queryNodehelper1.add(calcDef);
            queryNodehelper2.remove(calcDef);
            it = queryNodehelper2.iterator();
        }
        if (!queryNodehelper2.isEmpty()) {
            return null;
        }
        return queryNodehelper1;
    }

    static {
        Arrays.sort(PUSHDOWNTYPES);
    }
}

