/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXGenerate;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class MergeGenerateForCrossoin
extends Transformation {
    public MergeGenerateForCrossoin() {
        this.mName = "Merge Generate for Crossjoin";
        this.mPassNumbers = new int[]{41, 46};
        this.mTypes = new int[]{1030};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXGenerate generate = (MDXGenerate)node.getParent();
        MDXCrossjoin crossjoin = (MDXCrossjoin)node;
        AbstractMDXSet firstCossjoinChild = (AbstractMDXSet)node.getChild(0);
        firstCossjoinChild.move(generate);
        crossjoin.detach();
        generate.exchange(crossjoin);
        crossjoin.addChild(generate, 0);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        boolean status = true;
        status = MergeGenerateForCrossoin.checkNodeCondition(node, traceMsg);
        if (!status) {
            this.traceNodeCondition(false, traceMsg.toString(), trace);
            return status;
        }
        this.traceNodeCondition(status, "The parent MDXGenerate can be moved to the first child of the traget node.", trace);
        return status;
    }

    public static boolean checkNodeCondition(IXQEQueryNode node, StringBuilder traceMsg) {
        MDXHierInfo firstCrossjoinSetHierInfo;
        if (node.getParent().getType() != 1057) {
            if (traceMsg != null) {
                traceMsg.append("The parent node is not an MDXGenerate node.");
            }
            return false;
        }
        MDXGenerate generate = (MDXGenerate)node.getParent();
        MDXHierInfo genSetHierInfo = ((AbstractMDXSet)generate.getChild(0)).getHierarchyInfo();
        if (!genSetHierInfo.compareProjectedHierarchies(firstCrossjoinSetHierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo()) || genSetHierInfo.getNumProjectedHierarchies() != 1) {
            if (traceMsg != null) {
                traceMsg.append("The first child of the parent MDXGenerate does not project the same hierarchy as ");
                traceMsg.append("the first set of the MDXCrossjoin.");
            }
            return false;
        }
        if (((AbstractMDXSet)node.getChild(1)).isContextDependent(genSetHierInfo.getProjectedHierarchy(0))) {
            if (traceMsg != null) {
                traceMsg.append("The second set of the MDXCrossjoin is context dependent on the hierarchy ");
                traceMsg.append("projected in the first set of the parent MDXGenerate.");
            }
            return false;
        }
        return true;
    }
}

