/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXExcept;
import com.cognos.xqe.ast.olap.MDXGenerate;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class OptimizeDistinctOnSetOperator
extends Transformation {
    public OptimizeDistinctOnSetOperator() {
        this.mName = "Optimize Distinct On Set Operator.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1033};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parentNode = node;
        for (int idx = 0; idx < parentNode.getNumberChildren(); ++idx) {
            IXQEQueryNode set = parentNode.getChild(idx);
            if (set.getType() == 1057) {
                ((MDXGenerate)set).setAll(false);
                continue;
            }
            if (set.getType() == 1038) {
                ((MDXIntersect)set).setAll(false);
                continue;
            }
            if (set.getType() != 1032) continue;
            ((MDXExcept)set).setAll(false);
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child node of the MDXDistinct node is invalid.", trace);
            return false;
        }
        boolean status = false;
        for (int idx = 0; idx < node.getNumberChildren(); ++idx) {
            IXQEQueryNode set = node.getChild(idx);
            if (set.getType() == 1039) {
                status = !((MDXSet)set).projectsDuplicates();
            } else if (set.getType() == 1057) {
                status = ((MDXGenerate)set).getAll();
            } else if (set.getType() == 1038) {
                status = ((MDXIntersect)set).getAll();
            } else if (set.getType() == 1032) {
                status = ((MDXExcept)set).getAll();
            }
            if (!status) continue;
            this.traceNodeCondition(true, "The MDXDistinct operand is an MDXSet/Generate/Intersect/Except expressionthat projects duplicates.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MDXDistinct operand is not an MDXSet/Generate/Intersect/Except expression that projects duplicates.", trace);
        return false;
    }
}

