/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXNumericOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public class OptimizeSummaryOfOthers
extends Transformation {
    public OptimizeSummaryOfOthers() {
        this.mPassNumbers = new int[]{41};
        this.mName = "Optimize Summary of Others";
        this.mTypes = new int[]{1060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode parent = node.getParent();
        node.detach();
        IXQEQueryNode exceptExpr = node.detachChild(0);
        MDXSummaryFunction sumAllExpr = (MDXSummaryFunction)node;
        MDXSummaryFunction sumKnownExpr = (MDXSummaryFunction)factory.deepCopyNode(node);
        sumAllExpr.addChild(exceptExpr.detachChild(0), 0);
        sumKnownExpr.addChild(exceptExpr.detachChild(0), 0);
        MDXNumericOperator sumOthersExpr = MDXBuilder.buildMDXNumericOperator((IXQENodeFactory)factory, 0, sumAllExpr, sumKnownExpr);
        parent.addChild(sumOthersExpr);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery query = (MDXQuery)node.getAncestorOfType(1002);
        if (query == null || !query.isDMR()) {
            this.traceNodeCondition(false, "The MDXSummaryFunction is not part of a DMR query.", trace);
            return false;
        }
        node.throwOnInvalidChildCategories();
        if (((MDXSummaryFunction)node).getSummaryType() != MDXSummaryFunctionTypeEnum.SUM) {
            this.traceNodeCondition(false, "The summary function is not SUM.", trace);
            return false;
        }
        if (node.getChild(0).getType() == 1032) {
            if (node.getChild(0).getChild(0).getType() == 1040) {
                this.traceNodeCondition(true, "The MDXSummaryFunction is computing Sum(Except(Members, <Set>)).", trace);
                return true;
            }
        } else {
            this.traceNodeCondition(false, "The first child of summary function is not Except.", trace);
            return false;
        }
        this.traceNodeCondition(false, "The MDXSummaryFunction is not computing Sum(Except(Members, <Set>)).", trace);
        return false;
    }
}

