/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXTuple;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXEmptySet;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetTerminal;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import java.util.HashSet;
import java.util.List;

public class PushExpressionEvaluationToDatabase
extends Transformation {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String QUERYNAME = "Set operation sub Query";

    public PushExpressionEvaluationToDatabase() {
        this.mName = "Push the evaluation of an expression to the native MDX engine.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1003};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        PlanningEnvironment subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironment((ExecutionEnvironment)environment.getExecutionEnvironment(), environment);
        XQENodeFactory nodeFactory = subQueryEnvironment.getNodeFactory();
        long ticks = System.currentTimeMillis();
        V5QuerySet v5QuerySet = (V5QuerySet)nodeFactory.createNode(101002);
        v5QuerySet.addToIndex();
        MDXQuery subMdxQuery = (MDXQuery)nodeFactory.createNode(1002);
        v5QuerySet.addChild(subMdxQuery);
        subMdxQuery.setRefQueryProperty(QUERYNAME);
        MDXEdge subMdxEdge = (MDXEdge)nodeFactory.createNode(1006);
        subMdxEdge.setEdgeID(0);
        subMdxEdge.setMDXNonEmptyProperty(false);
        AbstractMDXSet subTopCount = null;
        IXQEQueryNode topCount = node.getChild(0);
        subTopCount = (AbstractMDXSet)nodeFactory.deepCopyNode(topCount);
        subMdxEdge.addChild(subTopCount);
        subMdxQuery.addChild(subMdxEdge);
        MDXFromCube mdxFrom = mdxQuery.getMDXFrom();
        MDXFromCube subMdxFrom = (MDXFromCube)nodeFactory.deepCopyNode(mdxFrom);
        subMdxFrom.setHaveVariablesBeenRead(false);
        subMdxQuery.addChild(subMdxFrom);
        subMdxQuery.disableLocalSubMDXQueryRequest();
        subMdxQuery.setSuppressNulls(Boolean.FALSE);
        subMdxQuery.setforceLocalQueryProcessing(new Boolean(false));
        String dataSourceType = mdxQuery.getDataSourceType();
        if (DataSourceTypeEnum.isTMR(dataSourceType)) {
            IXQEQueryNode[] refs;
            int[] types = new int[]{1077};
            for (IXQEQueryNode ref : refs = subMdxQuery.getDescendantsOfTypes(types, false)) {
                MDXDefaultMember member = (MDXDefaultMember)ref;
                if (!member.getPropertyIsNoMember()) continue;
                member.setPropertyIsNoMember(false);
            }
        }
        XQEDebugLog.out.println("TopCount/Filter Opt-Sub Query MDX: ");
        XQEDebugLog.out.println(subMdxQuery.getMDX());
        XQEDebugLog.out.println("TopCount/Filter Opt-Sub Query Create Time:" + (System.currentTimeMillis() - ticks));
        ticks = System.currentTimeMillis();
        RequestEnvironment subRequestEnvironment = (RequestEnvironment)subQueryEnvironment.getRequestEnvironment();
        PlannedV5QuerySet plannedQuery = QueryPlanner.getInstance().planQuery(v5QuerySet, subQueryEnvironment);
        XQEDebugLog.out.println("TopCount/Filter Opt-Sub Query Plan Time:" + (System.currentTimeMillis() - ticks));
        IXQEQueryNode[] mdxQueries = plannedQuery.getDescendantsOfType(501017, true);
        if (mdxQueries.length != 1) {
            plannedQuery.throwInternalError("TopCount/Filter Opt-Sub-Query planning resulted in more than 1 query, this is not expected.");
        }
        ticks = System.currentTimeMillis();
        XMdx mdxNode = (XMdx)mdxQueries[0];
        if (!capabilities.isSupported("v5.deferNamedSetEvaluation")) {
            IHybridResultSet result;
            subQueryEnvironment.setPlanningActive(subRequestEnvironment);
            ExecutionEnvironment execEnvironment = (ExecutionEnvironment)subQueryEnvironment.getExecutionEnvironment();
            XDataContext dataContext = execEnvironment.pushDataContext();
            try {
                result = (IHybridResultSet)mdxNode.execute(dataContext);
            }
            finally {
                execEnvironment.popDataContext(dataContext);
            }
            subQueryEnvironment.setPlanningInactive();
            XQEDebugLog.out.println("Sub Query MDX: ");
            XQEDebugLog.out.println(mdxNode.getMdxText());
            XQEDebugLog.out.println("TopCount/Filter Opt-Sub Query Execute Time:" + (System.currentTimeMillis() - ticks));
            ticks = System.currentTimeMillis();
            HashSet<IMember> members = new HashSet<IMember>();
            nodeFactory = environment.getNodeFactory();
            AbstractMDXSet resolvedTopCount = (AbstractMDXSet)nodeFactory.createNode(1039);
            XIterator membersIterator = null;
            int count = 0;
            try {
                ITuple aTuple;
                membersIterator = result.getAxisIterator(0);
                while ((aTuple = (ITuple)membersIterator.next()) != null) {
                    ++count;
                    IMember aMember = aTuple.getMember(0);
                    members.add(aMember);
                    BaseMember member = MDXBuilder.buildMDXBaseMemberExpr(nodeFactory, aMember.getUniqueName(), aMember.getLevel());
                    member.bind(aMember);
                    resolvedTopCount.addChild(member);
                }
                IXQEQueryNode child = node.getChild(0);
                if (count > 0) {
                    node.exchangeChildNode(child, resolvedTopCount, false);
                } else {
                    CogMDXEmptySet emptyTopCount = (CogMDXEmptySet)nodeFactory.createNode(1145);
                    List<IHierarchy> hierarchies = ((MDXNamedSetDefinition)node).getHierarchyInfo().getProjectedHierarchies();
                    BaseHierarchy hier = MDXBuilder.buildMDXBaseHierarchyExpr(nodeFactory, hierarchies.get(0));
                    emptyTopCount.addChild(hier);
                    node.exchangeChildNode(child, emptyTopCount, false);
                }
            }
            finally {
                if (membersIterator != null) {
                    membersIterator.release();
                }
                result.release();
            }
            XQEDebugLog.out.println("TopCount/Filter Opt-Expand Member List Time:" + (System.currentTimeMillis() - ticks));
        } else {
            XQEDebugLog.out.println("Deferring named set evaluation for topcount and filterset optimization");
            nodeFactory = environment.getNodeFactory();
            MDXSetTerminal set = (MDXSetTerminal)nodeFactory.createNode(1180);
            set.setPropertyValues((AbstractMDXNode)node.getChild(0), ((MDXNamedSetDefinition)node).getUniqueName(), mdxNode, subQueryEnvironment);
            node.exchangeChildNode(node.getChild(0), set, false);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RequestEnvironment regEnvironment;
        String requestName;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        if (!mdxQuery.getUseLocalQueryProcessing() || !mdxQuery.isRemoteDatasourceOLAP()) {
            this.traceNodeCondition(false, "The MDXQuery is NOT against LOLAP. ", trace);
            return false;
        }
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!(capabilities.isSupported("v5.deferNamedSetEvaluation") || null == (requestName = (regEnvironment = (RequestEnvironment)environment.getRequestEnvironment()).getOperationName()) || requestName.equals("execute") || requestName.equals("executeDetailQuery"))) {
            this.traceNodeCondition(false, "The query is not received as an Execution request.", trace);
            return false;
        }
        node.throwOnInvalidChildCategories();
        IXQEQueryNode child = node.getChild(0);
        if (!(capabilities.isSupported("v5.enableTopCountFunctionsOptimization") && (child.getType() == 1041 || child.getType() == 1042) || capabilities.isSupported("v5.enableFilterSetOptimization") && child.getType() == 1053)) {
            this.traceNodeCondition(false, "The TopCount/Filter optimization is disabled", trace);
            return false;
        }
        int[] promptType = new int[]{1163, 1162, 1129, 1161, 1159};
        IXQEQueryNode[] prompts = mdxQuery.getDescendantsOfTypes(promptType, false);
        if (prompts.length > 0) {
            this.traceNodeCondition(false, "The MDXQuery contains prompts ", trace);
            return false;
        }
        if (child.getType() != 1041 && child.getType() != 1042 && child.getType() != 1053) {
            this.traceNodeCondition(false, "The Top Count/Filter expression is not found", trace);
            return false;
        }
        child.throwOnInvalidChildCategories();
        String dataSourceType = mdxQuery.getDataSourceType();
        int[] refType = new int[]{1014, 1013, 1015, 1004, 1148};
        IXQEQueryNode[] refs = child.getDescendantsOfTypes(refType, false);
        if (refs.length > 0) {
            this.traceNodeCondition(false, "The TopCount/Filter expressions contains a reference to a named set, calculated member or a set alias ", trace);
            return false;
        }
        List<IXQEQueryNode> valueExpressionNodes = child.getChild(0).getDescendantsOfCategory(1061, false, 1064);
        if (!valueExpressionNodes.isEmpty()) {
            this.traceNodeCondition(false, "The Top/Bottom/Head/Tail/Filter expressions contains a value expression.", trace);
            return false;
        }
        int cardinality = 0;
        MDXLevelInfo levelInfo = ((AbstractMDXNode)child.getChild(0)).getLevelInfo();
        MDXHierInfo hierInfo = levelInfo.getHierarchyInfo();
        List<IHierarchy> hierarchies = hierInfo.getProjectedHierarchies();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "There is more than one projected hierarchies in the dataset", trace);
            return false;
        }
        ILevel level = levelInfo.getLowestProjectedLevel(hierarchies.get(0));
        if (capabilities.getStringValue("datasource.levelBasedDatasetCardinality", VALUE_FALSE).equals("VALUE_TRUE")) {
            cardinality = level.getCardinality();
        } else {
            IDimension iDimension = level.getDimension();
            cardinality = iDimension.getCardinality();
        }
        if (cardinality < capabilities.getIntegerValue("v5.topCountFunctionsOptimization.datasetSize")) {
            this.traceNodeCondition(false, "The cardinality of the set does not exceed the configurable threshold", trace);
            return false;
        }
        if (child.getNumberChildren() < 2) {
            return child.getType() == 1042;
        }
        if (child.getChild(1).getType() == 1064 && ((MDXNumericConstant)child.getChild(1)).getConstantValue() instanceof Integer) {
            int topnumber = (Integer)((MDXNumericConstant)child.getChild(1)).getConstantValue();
            if (topnumber > capabilities.getIntegerValue("v5.topCountFunctionsOptimization.projectedSetSize")) {
                this.traceNodeCondition(false, "The cardinality of the projected set exceeds the configurable threshold", trace);
                return false;
            }
            if (child.getType() == 1042) {
                return true;
            }
            if (child.getType() == 1041 && child.getChild(2).getType() == 1059 && ((AbstractMDXTuple)child.getChild(2).getChild(0)).projectsOnlyExplicitMembers(null)) {
                return true;
            }
        }
        if (child.getType() == 1053) {
            IXQEQueryNode logicalExpressionNode = child.getChild(1);
            if (logicalExpressionNode.getType() == 1070) {
                return this.isSupportedFilterExpression(logicalExpressionNode, child, dataSourceType, trace);
            }
            if (DataSourceTypeEnum.isTMR(dataSourceType) && (logicalExpressionNode.getType() == 1110 || logicalExpressionNode.getType() == 1111)) {
                for (IXQEQueryNode operand : logicalExpressionNode.getChildren()) {
                    if (this.isSupportedFilterExpression(operand, child, dataSourceType, trace)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean forceCreateNamedSet(IXQEQueryNode node) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        return mdxQuery.getUseLocalQueryProcessing() && mdxQuery.isRemoteDatasourceOLAP() && (node.getType() == 1041 || node.getType() == 1042 || node.getType() == 1053);
    }

    private boolean isSupportedFilterExpression(IXQEQueryNode node, IXQEQueryNode filterNode, String dataSourceType, XQETrace trace) {
        if (node.getType() != 1070) {
            return false;
        }
        if (node.getChildren().length != 2) {
            return false;
        }
        if (node.getChild(0).getType() == 1059 && node.getChild(1).getType() == 1064 || node.getChild(0).getType() == 1064 && node.getChild(1).getType() == 1059 || DataSourceTypeEnum.isTMR(dataSourceType) && node.getChild(0).getType() == 1016 && node.getChild(1).getType() == 1127) {
            int[] strType = new int[]{1063};
            IXQEQueryNode[] strs = filterNode.getDescendantsOfTypes(strType, false);
            if (strs.length > 0) {
                this.traceNodeCondition(false, "The Filter set contains string operand", trace);
                return false;
            }
            this.traceNodeCondition(true, "The Filter set can be pushed to the DB.", trace);
            return true;
        }
        return false;
    }
}

