/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCustomSet;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXPushdownQueryDefinition;
import com.cognos.xqe.ast.olap.MDXPushdownQueryReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.DMRMemberLoadQuery;
import com.cognos.xqe.transformation.dmr.DMRPushdownQueryGenerator;
import com.cognos.xqe.transformation.olap.optimization.IdentifyPushdownCandidate;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;

public class PushSetEvaluationToDataSourceAsCustomSet
extends Transformation {
    private static final int[] CONSTS = new int[]{1064, 1089, 1127, 1151};

    public PushSetEvaluationToDataSourceAsCustomSet() {
        this.mName = "Push the evaluation of a set expression to underlying data source.";
        this.mPassNumbers = new int[]{48};
        this.mTypes = new int[]{1191};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        try {
            IXQEQueryNode[] iXQEQueryNodeArray;
            IXQEQueryNode[] calcRefs;
            CubeWrapper cube;
            String innerQueryDiName;
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            ArrayList<ILevel> outputLevels = new ArrayList<ILevel>();
            ArrayList<DMRPushdownQueryGenerator.ContextDataItem> contextDataItemNames = new ArrayList<DMRPushdownQueryGenerator.ContextDataItem>();
            ArrayList<DMRPushdownQueryGenerator.ContextDataItem> ancestorDataItemNames = new ArrayList<DMRPushdownQueryGenerator.ContextDataItem>();
            DMRPushdownQueryGenerator g = new DMRPushdownQueryGenerator(environment, false);
            AbstractMDXNode pushdownTarget = (AbstractMDXNode)node.getChild(0);
            MDXLevelInfo projectedLevelInfo = pushdownTarget.getLevelInfo();
            V5QuerySet querySet = g.buildEmptyQuerySet("PushdownQuery", PushSetEvaluationToDataSourceAsCustomSet.getModelLocale(environment, projectedLevelInfo));
            boolean bUseTopNRows = this.setUseTopNRows(nodeFactory, querySet, pushdownTarget);
            HashSet<IHierarchy> explicitHier = new HashSet<IHierarchy>();
            String contextInfo = this.collectContextInfo(pushdownTarget, explicitHier);
            MDXLevelInfo contextLevelInfo = pushdownTarget.getContextLevelInfo();
            for (IHierarchy hierarchy : projectedLevelInfo.getHierarchyInfo().getProjectedHierarchies()) {
                if (!contextLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                contextLevelInfo.clearProjectedLevels(hierarchy);
            }
            this.projectLevels(environment, querySet, contextLevelInfo, contextDataItemNames, null, explicitHier);
            this.projectLevels(environment, querySet, projectedLevelInfo, ancestorDataItemNames, outputLevels, explicitHier);
            List<V5Query> queryList = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
            V5Query innerQuery = queryList.get(0);
            for (DMRPushdownQueryGenerator.ContextDataItem contextDi : contextDataItemNames) {
                innerQueryDiName = DMRPushdownQueryGenerator.getLocalDataItemName(contextDi.getContextItem(), innerQuery, querySet);
                innerQueryDiName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(innerQuery.getV5QueryName()), innerQueryDiName);
                contextDi.setContextItem(innerQueryDiName);
            }
            for (DMRPushdownQueryGenerator.ContextDataItem contextDi : ancestorDataItemNames) {
                innerQueryDiName = DMRPushdownQueryGenerator.getLocalDataItemName(contextDi.getContextItem(), innerQuery, querySet);
                innerQueryDiName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(innerQuery.getV5QueryName()), innerQueryDiName);
                contextDi.setContextItem(innerQueryDiName);
            }
            if (!bUseTopNRows) {
                StringBuilder buffer = new StringBuilder();
                g.visit(pushdownTarget, querySet, contextDataItemNames, ancestorDataItemNames, buffer);
            }
            if (!g.useMeasure() && !(cube = (CubeWrapper)mdxQuery.getReferencedCube()).getDetailFilters().isEmpty()) {
                querySet.setPropertyValue("v5Version", 0);
            }
            MDXPushdownQueryDefinition pushdownQuery = (MDXPushdownQueryDefinition)nodeFactory.createNode(1189);
            mdxQuery.addChild(pushdownQuery);
            pushdownQuery.setPushdownQuery(querySet);
            pushdownQuery.setUniqueName("XQE_PUSHDOWNQUERY" + mdxQuery.getNextPushdownQueryId());
            MDXPushdownQueryReference pushdownQueryRef = (MDXPushdownQueryReference)nodeFactory.createNode(1190);
            pushdownQueryRef.bind(pushdownQuery);
            MDXStringConstant contextIndependentFlag = (MDXStringConstant)nodeFactory.createNode(1127);
            contextIndependentFlag.setConstantValue(contextInfo);
            MDXCustomSet customSet = (MDXCustomSet)nodeFactory.createNode(1192);
            customSet.addChild(pushdownQueryRef);
            customSet.addChild(contextIndependentFlag);
            for (ILevel iLevel : outputLevels) {
                customSet.addChild(MDXBuilder.buildMDXBaseLevelExpr(nodeFactory, iLevel));
            }
            for (IXQEQueryNode calcRef : calcRefs = node.getDescendantsOfType(1013, false)) {
                MDXCalculatedMemberDefinition calcDef = ((MDXCalculatedMemberReference)calcRef).getDefinition();
                if (calcDef.getCalcMemberRefs().size() != 1) continue;
                calcDef.detach();
            }
            pushdownQuery.setPushdownMDXExpression((AbstractMDXSet)node.getChild(0).exchange(customSet));
            node.extract();
            for (IXQEQueryNode aNamedSet : iXQEQueryNodeArray = mdxQuery.getChildrenOfType(1003)) {
                if (mdxQuery.isSetSpecificationReferenced((MDXNamedSetDefinition)aNamedSet)) continue;
                aNamedSet.detach();
            }
        }
        catch (Exception e) {
            node.getChild(0).setPropertyValue("local_process_only", Boolean.TRUE);
            node.extract();
        }
    }

    public static Locale getModelLocale(PlanningEnvironment environment, MDXLevelInfo projectedLevelInfo) {
        for (IHierarchy hierarchy : projectedLevelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            if (hierarchy.getDimension().isMeasuresDimension() || PushSetEvaluationToDataSourceAsCustomSet.isDummyDimension(hierarchy.getDimension()) || projectedLevelInfo.getProjectedLevels(hierarchy).isEmpty()) continue;
            ILevel level = projectedLevelInfo.getLowestProjectedLevelsSkipCalculation(hierarchy);
            if (!((level = ((MDXLevelInfo.LevelInfo)level).getLevel()) instanceof LevelWrapper) || (level = ((LevelWrapper)level).getWrappedLevel()) == null) continue;
            return environment.getMetadataConnection().getDefaultLocale(level);
        }
        return null;
    }

    private boolean setUseTopNRows(XQENodeFactory nodeFactory, V5QuerySet querySet, AbstractMDXNode pushdownTarget) {
        if (pushdownTarget.getType() != 1042) {
            return false;
        }
        MDXHeadTailFunction headFunc = (MDXHeadTailFunction)pushdownTarget;
        if (headFunc.getOperatorType() != 1) {
            return false;
        }
        if (headFunc.getNumberChildren() != 2 || headFunc.getChild(1).getType() != 1064) {
            return false;
        }
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        if (!providerCapabilities.isSupported("CustomSetUseTopN")) {
            return false;
        }
        IXQEQueryNode setChild = IdentifyPushdownCandidate.getSetChild(headFunc.getChild(0), null);
        boolean support = false;
        if (setChild.getNodeType() == 1040 && setChild.getChild(0).getType() == 1065) {
            support = true;
        }
        if (!support && setChild.getNodeType() == 1048 && setChild.getChild(0).getType() == 1067) {
            support = true;
            BaseMember baseMUN = (BaseMember)setChild.getChild(0);
            V5Query query = (V5Query)querySet.getFirstDescendantOfTypeOrdered(101006, false);
            ILevel level = baseMUN.getLevel();
            String mun = baseMUN.getExternalName();
            String logical = (String)baseMUN.getPropertyValue("logical");
            IXQEQueryNode in = DMRMemberLoadQuery.createInExpression(nodeFactory, level, mun, logical);
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            detailFilter.setPostAutoAggregation(false);
            detailFilter.addChild(in);
            query.addChild(detailFilter);
        }
        if (!support) {
            return false;
        }
        MDXNumericConstant constNum = (MDXNumericConstant)headFunc.getChild(1);
        IXQEQueryNode qrd = querySet.getFirstDescendantOfTypeOrdered(101055, false);
        qrd.setPropertyValue("topNRows", constNum.getConstantValue().toString());
        return true;
    }

    private String collectContextInfo(AbstractMDXNode pushdownTarget, HashSet<IHierarchy> hs) {
        IXQEQueryNode tp;
        StringBuilder sb = new StringBuilder();
        sb.append("<c v='true'>");
        int tuplePos = 1;
        if (pushdownTarget.getType() == 1041) {
            tuplePos = 2;
        }
        IXQEQueryNode v = pushdownTarget.getChild(tuplePos);
        if (pushdownTarget.getType() == 1053) {
            IXQEQueryNode[] children = v.getChildren();
            v = null;
            if (children.length == 1) {
                v = children[0];
            } else if (children.length == 2) {
                if (children[1].isOfTypes(CONSTS)) {
                    v = children[0];
                } else if (children[0].isOfTypes(CONSTS)) {
                    v = children[1];
                }
            }
        }
        if (v != null && v.getType() == 1059 && v.getNumberChildren() == 1 && (tp = v.getChild(0)).getType() == 1069) {
            IXQEQueryNode[] members;
            for (IXQEQueryNode mb : members = tp.getChildren()) {
                MDXDefaultMember aDefaultMb;
                IHierarchy tmp;
                IHierarchy h = null;
                int type = mb.getType();
                if (type == 1067) {
                    BaseMember aMb = (BaseMember)mb;
                    tmp = aMb.getHierarchy();
                    if (!tmp.getDimension().isMeasuresDimension() && aMb.getLevel().isRootLevel()) {
                        h = tmp;
                    }
                } else if (type == 1077 && !(tmp = (aDefaultMb = (MDXDefaultMember)mb).getHierarchy()).getDimension().isMeasuresDimension()) {
                    h = tmp;
                }
                if (h == null) continue;
                hs.add(h);
                sb.append("<hierarchy name='");
                sb.append(StringEscapeUtils.escapeXml((String)h.getUniqueName()));
                sb.append("' />");
            }
        }
        sb.append("</c>");
        return sb.toString();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return true;
    }

    private static boolean isDummyDimension(IDimension dim) {
        String dimName = dim.getName();
        return dimName.equals("dummy") || dimName.equals("secondDummy") || dimName.equals("tagDimension");
    }

    private void projectLevels(PlanningEnvironment environment, V5QuerySet querySet, MDXLevelInfo projectedLevelInfo, List<DMRPushdownQueryGenerator.ContextDataItem> resultDataItemList, List<ILevel> outputLevels, HashSet<IHierarchy> explicitHier) {
        DMRPushdownQueryGenerator g = new DMRPushdownQueryGenerator(environment, false);
        for (IHierarchy hierarchy : projectedLevelInfo.getHierarchyInfo().getProjectedHierarchies()) {
            if (hierarchy.getDimension().isMeasuresDimension() || PushSetEvaluationToDataSourceAsCustomSet.isDummyDimension(hierarchy.getDimension()) || projectedLevelInfo.getProjectedLevels(hierarchy).isEmpty() || explicitHier.contains(hierarchy)) continue;
            ILevel level = projectedLevelInfo.getLowestProjectedLevelsSkipCalculation(hierarchy);
            level = ((MDXLevelInfo.LevelInfo)level).getLevel();
            if (outputLevels != null && level instanceof LevelWrapper) {
                outputLevels.add(level);
            }
            ArrayList<ILevel> ancestorLevels = new ArrayList<ILevel>();
            while (!level.isRootLevel()) {
                ancestorLevels.add(0, level);
                level = level.getPreviousLevel();
            }
            for (ILevel aLevel : ancestorLevels) {
                resultDataItemList.add(g.addLevelToV5QuerySet((LevelWrapper)aLevel, true, querySet));
            }
        }
    }
}

