/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQENodeIndex;
import com.cognos.xqe.ast.localprocessing.v5.V5MasterDetailWindow;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXParameterMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryMetadataCollectionForLOLAP
extends Transformation {
    public static final String QUERYNAME = "Priming sub Query";
    public static final String HAS_UNRESOLVED_DFM = "hasUnresolvedDefaultMember";
    public static final XQELogger PRIMINGQUERYLOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "PrimingQuery", LogLevel.ERROR);

    public QueryMetadataCollectionForLOLAP() {
        this.mName = "Generate meta data sub query for LOLAP query cache.";
        this.mPassNumbers = new int[]{53};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery originalQuery = (MDXQuery)node;
        PlanningEnvironment subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironment((ExecutionEnvironment)environment.getExecutionEnvironment(), environment);
        XQENodeFactory nodeFactory = subQueryEnvironment.getNodeFactory();
        List<IXQEQueryNode> projectedBaseLevelsHiers = this.collectProjectedBaseLevelsHiers(originalQuery, false);
        List<AbstractMDXSet> masterLinkSets = this.getMasterQueryLinkSets(node, environment);
        if (masterLinkSets != null) {
            for (AbstractMDXSet masterLinkSet : masterLinkSets) {
                projectedBaseLevelsHiers.addAll(this.collectProjectedBaseLevelsHiers(masterLinkSet, true));
            }
        }
        HashSet<ILevel> uniqueLevels = new HashSet<ILevel>();
        HashSet<IHierarchy> uniqueHierarchies = new HashSet<IHierarchy>();
        for (IXQEQueryNode currentNode : projectedBaseLevelsHiers) {
            if (currentNode.getType() == 1065) {
                uniqueLevels.add(((BaseLevel)currentNode).getLevel());
                continue;
            }
            uniqueHierarchies.add(((BaseHierarchy)currentNode).getHierarchy());
        }
        Iterator<IHierarchy> hierIterator = uniqueHierarchies.iterator();
        HashMap<IHierarchy, List<Object>> hierarchySetMap = new HashMap<IHierarchy, List<Object>>();
        while (hierIterator.hasNext()) {
            IHierarchy iHierarchy = (IHierarchy)hierIterator.next();
            if (hierarchySetMap.containsKey(iHierarchy)) continue;
            ArrayList<IHierarchy> singletonList = new ArrayList<IHierarchy>();
            singletonList.add(iHierarchy);
            hierarchySetMap.put(iHierarchy, singletonList);
        }
        for (ILevel iLevel : uniqueLevels) {
            List<ILevel> iLevelList;
            IHierarchy iHierarchy = iLevel.getHierarchy();
            if (hierarchySetMap.containsKey(iHierarchy)) {
                iLevelList = (List)hierarchySetMap.get(iHierarchy);
                iLevelList.add(iLevel);
                continue;
            }
            iLevelList = new ArrayList();
            iLevelList.add(iLevel);
            hierarchySetMap.put(iHierarchy, iLevelList);
        }
        HashSet<IMember> uniqueMeasures = this.colloctMeasuresAndExplicitMembers(hierarchySetMap, node, nodeFactory);
        if (masterLinkSets != null) {
            for (AbstractMDXSet masterLinkSet : masterLinkSets) {
                uniqueMeasures.addAll(this.colloctMeasuresAndExplicitMembers(hierarchySetMap, masterLinkSet, nodeFactory));
            }
        }
        Set iHierKeySet = hierarchySetMap.keySet();
        hierIterator = iHierKeySet.iterator();
        AbstractMDXSet levelAndMemberXJSet = this.buildXJSetForProjectedDataitems(hierarchySetMap, hierIterator, nodeFactory);
        AbstractMDXSet finalXJset = null;
        MDXSet measureSet = (MDXSet)nodeFactory.createNode(1039);
        for (IMember iMember : uniqueMeasures) {
            BaseMember theMeasure = (BaseMember)nodeFactory.createNode(1067);
            theMeasure.bind(iMember);
            measureSet.addChild(theMeasure);
        }
        if (null != levelAndMemberXJSet && uniqueMeasures.size() > 0) {
            finalXJset = (MDXCrossjoin)nodeFactory.createNode(1030);
            finalXJset.addChild(levelAndMemberXJSet);
            finalXJset.addChild(measureSet);
        } else if (null != levelAndMemberXJSet) {
            finalXJset = levelAndMemberXJSet;
        } else if (uniqueMeasures.size() > 0) {
            finalXJset = measureSet;
        }
        if (finalXJset == null) {
            originalQuery.disableLocalSubMDXQueryRequest();
            environment.setTreeHasBeenModified();
            return;
        }
        XQEDebugLog.out.println("Original Query MDX: ");
        XQEDebugLog.out.println(originalQuery.getMDX());
        QueryMetadataCollectionForLOLAP.logMDXQuery(originalQuery);
        long ticks = System.currentTimeMillis();
        V5QuerySet v5QuerySet = this.createSubMDXQuery(node, nodeFactory, finalXJset);
        XQEDebugLog.out.println("Priming query-Sub Query Create Time:" + (System.currentTimeMillis() - ticks));
        ticks = System.currentTimeMillis();
        ((RequestEnvironment)subQueryEnvironment.getRequestEnvironment()).setValidateRequest(false);
        QueryPlanner.getInstance().plan(v5QuerySet, subQueryEnvironment);
        MDXQuery primingQuery = ((XMdxLocal)v5QuerySet.getChild(0)).getMDXQuery();
        originalQuery.addPlannedPrimingQuery((XMdxLocal)v5QuerySet.getChild(0));
        XQEDebugLog.out.println("Priming Query MDX: ");
        XQEDebugLog.out.println(primingQuery.getMDX());
        XQEDebugLog.out.println("Priming query-Sub Query Plan Time:" + (System.currentTimeMillis() - ticks));
        QueryMetadataCollectionForLOLAP.logMDXQuery(primingQuery);
    }

    private List<IXQEQueryNode> collectProjectedBaseLevelsHiers(AbstractMDXNode node, boolean includeSelf) {
        IXQEQueryNode[] mdxMembers = node.getDescendantsOfType(1040, includeSelf);
        ArrayList<IXQEQueryNode> projectedLevelsHiers = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode currentNode : mdxMembers) {
            currentNode.throwOnInvalidChildCategories();
            IXQEQueryNode child = currentNode.getChild(0);
            if (child.getType() != 1065 && child.getType() != 1073) continue;
            projectedLevelsHiers.add(child);
        }
        return projectedLevelsHiers;
    }

    private List<AbstractMDXSet> getMasterQueryLinkSets(IXQEQueryNode mdxQuery, PlanningEnvironment environment) {
        List<MasterDetailLink> links;
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        if (mdProvider == null || !mdProvider.hasMasterDetailQuery()) {
            return null;
        }
        String qrdName = ((RSAPIDataset)mdxQuery.getAncestorOfType(401005)).getName();
        if (!mdProvider.isDetailQrd(qrdName) && (links = mdProvider.getMasterDetailLinks(qrdName)) != null && !links.isEmpty()) {
            return null;
        }
        IXQEQueryNode[] mdxParameters = mdxQuery.getDescendantsOfType(1129, false);
        String parameterName = null;
        ArrayList<AbstractMDXSet> resultSets = new ArrayList<AbstractMDXSet>();
        for (IXQEQueryNode parameter : mdxParameters) {
            List<String> linkNames;
            IXQEQueryNode mdw;
            if (!((MDXParameterMember)parameter).isMasterDetailParameter()) continue;
            parameterName = ((MDXParameterMember)parameter).getName();
            String queryName = mdProvider.getDetailQueryName(qrdName);
            if (queryName == null && (mdw = mdxQuery.getAncestorOfType(601026)) != null) {
                V5MasterDetailWindow mdwCombined = (V5MasterDetailWindow)mdw;
                XQENodeIndex nodeIndex = environment.getNodeIndex();
                V5MasterDetailWindow mdwMaster = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdwCombined.getMasterDetailWindowNodeIDMaster());
                queryName = ((RSAPIDataset)mdwMaster.getAncestorOfType(401005)).getRefQueryName();
            }
            if ((linkNames = mdProvider.getMasterDetailLinkNamesForParameter(parameterName, queryName)) == null) continue;
            for (String linkName : linkNames) {
                AbstractMDXSet masterSet;
                MasterDetailLink link = mdProvider.getLink(linkName);
                if (link == null || (masterSet = link.getMasterLinkSetExpr()) == null || masterSet.getNumberChildren() == 0) continue;
                resultSets.add(masterSet);
                while (link.getParentMDLink() != null) {
                    AbstractMDXSet parentMasterSet = (link = link.getParentMDLink()).getMasterLinkSetExpr();
                    if (parentMasterSet == null || parentMasterSet.getNumberChildren() == 0) continue;
                    resultSets.add(parentMasterSet);
                }
            }
        }
        return resultSets;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        V5MasterDetailWindow mdw = (V5MasterDetailWindow)node.getAncestorOfType(601026);
        boolean bl = status = mdw == null;
        if (status) {
            this.traceQueryCondition(status, "Query is not an optimized master-detail.", trace);
            return status;
        }
        this.traceQueryCondition(status, "Query is an optimized master-detail.", trace);
        boolean bl2 = status = mdw.getMasterDetailWindowNodeIDCombined() == mdw.getId().intValue();
        if (status) {
            this.traceQueryCondition(status, "Query is the combined portion of the optimized master-detail.", trace);
        } else {
            this.traceQueryCondition(status, "Query is not the combined portion of the optimized master-detail.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean bl;
        MDXCalculatedMemberReference calcRef;
        MDXCalculatedMemberDefinition calcDef;
        IXQEQueryNode[] calc;
        MDXDimensionLine dimensionLine;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!capabilities.isSupported("v5.planSubQueryForLocalOLAP")) {
            this.traceNodeCondition(false, "The configuration of planning sub query for LOLAP is set to false.", trace);
            return false;
        }
        if (!mdxQuery.getUseLocalQueryProcessing() || !mdxQuery.isRemoteDatasourceOLAP()) {
            this.traceNodeCondition(false, "The MDXQuery is NOT against LOLAP. No sub query is required.", trace);
            return false;
        }
        if (!mdxQuery.requiresLocalSubMDXQuery()) {
            this.traceNodeCondition(false, "We do not need the optimization sub MDX query.", trace);
            return false;
        }
        RequestEnvironment reqEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = reqEnvironment.getRequestParameters();
        if (parameters != null && parameters.hasUnresolvedParameters()) {
            this.traceNodeCondition(false, "There is still unresolved parameters in the query.", trace);
            return false;
        }
        IXQEQueryNode[] parameterMembers = node.getDescendantsOfType(1129, false);
        if (parameterMembers.length != 0) {
            for (IXQEQueryNode member : parameterMembers) {
                MDXParameterMember parameterMember = (MDXParameterMember)member;
                IHierarchy iHierarchy = parameterMember.getHierarchy();
                if (iHierarchy.getProperty("Valid_From") == null && iHierarchy.getProperty("Valid_To") == null) continue;
                this.traceNodeCondition(false, "There is parameter from time dependent hierarcy. ", trace);
                return false;
            }
        }
        if ((dimensionLine = mdxQuery.getDimensionLine()) != null && (calc = dimensionLine.getDescendantsOfType(1013, false)).length != 0 && this.whereReducesSetSize(calcDef = (calcRef = (MDXCalculatedMemberReference)calc[0]).getDefinition())) {
            this.traceNodeCondition(false, "The where clause reduces the set size, do not run the priming query.", trace);
            return false;
        }
        IXQEQueryNode[] nodes = mdxQuery.getDescendantsOfType(1180, false);
        if (nodes.length > 0) {
            this.traceNodeCondition(false, "The MDXQuery contains a named set which evaluation is pushed to the database and deferred ", trace);
            return false;
        }
        List<AbstractMDXSet> masterLinkSets = this.getMasterQueryLinkSets(mdxQuery, environment);
        if (masterLinkSets != null && masterLinkSets.size() != 0) {
            MDXHierInfo detailHierInfo = mdxQuery.getHierarchyInfo();
            for (AbstractMDXSet abstractMDXSet : masterLinkSets) {
                List<IHierarchy> masterHiers = abstractMDXSet.getHierarchyInfo().getProjectedHierarchies();
                for (IHierarchy iHierarchy : masterHiers) {
                    if (!detailHierInfo.projectsSameDimensionDiffHierarchy(iHierarchy)) continue;
                    this.traceNodeCondition(false, "Found different hierarchies from same dimension.", trace);
                    return false;
                }
            }
        }
        int[] memberType = new int[]{1067, 1077};
        List<AbstractMDXNode> members = mdxQuery.getDescendantsOfTypes(memberType, true, true, false, false, false);
        if (masterLinkSets != null) {
            for (AbstractMDXSet masterLinkSet : masterLinkSets) {
                members.addAll(masterLinkSet.getDescendantsOfTypes(memberType, true, true, false, false, false));
            }
        }
        boolean bl2 = false;
        for (int i = 0; i < members.size() && !bl2; ++i) {
            AbstractMDXMember member = (AbstractMDXMember)members.get(i);
            IHierarchy mHier = member.getHierarchy();
            if (!mHier.getDimension().isMeasuresDimension()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.traceNodeCondition(false, "The MDXQuery does not have a measure.", trace);
            return false;
        }
        this.traceNodeCondition(true, "A sub query is reqired to build the meta data for LOLAP query cache.", trace);
        return true;
    }

    private boolean whereReducesSetSize(IXQEQueryNode node) {
        int[] nodeTypes = new int[]{1038, 1041, 1042, 1053, 1014, 1013};
        IXQEQueryNode[] nodes = node.getDescendantsOfTypes(nodeTypes, false);
        if (nodes != null) {
            for (IXQEQueryNode aNode : nodes) {
                if (aNode.getType() == 1014) {
                    MDXNamedSetReference nsRef = (MDXNamedSetReference)aNode;
                    MDXNamedSetDefinition nsDef = nsRef.getDefinition();
                    if (!this.whereReducesSetSize(nsDef)) continue;
                    return true;
                }
                if (aNode.getType() == 1013) {
                    MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)aNode;
                    MDXCalculatedMemberDefinition calcDef = calcRef.getDefinition();
                    if (!this.whereReducesSetSize(calcDef)) continue;
                    return true;
                }
                AbstractMDXSet aSet = (AbstractMDXSet)aNode;
                MDXHierInfo hierInfo = aSet.getHierarchyInfo();
                if (hierInfo == null) continue;
                List<IHierarchy> hiers = hierInfo.getProjectedHierarchies();
                for (IHierarchy hier : hiers) {
                    if (!hier.getDimension().getType().equals((Object)DimensionTypeEnum.TIME) && !hier.getDimension().getType().equals((Object)DimensionTypeEnum.SAPTIME)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private AbstractMDXSet buildXJSetForProjectedDataitems(Map<IHierarchy, List<Object>> hierarchyLevelMap, Iterator<IHierarchy> iterator, IXQENodeFactory nodeFactory) {
        if (!iterator.hasNext()) {
            return null;
        }
        AbstractMDXSetOperator setFromSameHier = null;
        IHierarchy ihierarchy = iterator.next();
        List<Object> nodesFromTheHier = hierarchyLevelMap.get(ihierarchy);
        if (nodesFromTheHier.size() > 1) {
            Iterator<Object> setIterator = nodesFromTheHier.iterator();
            setFromSameHier = (AbstractMDXSetOperator)nodeFactory.createNode(1039);
            while (setIterator.hasNext()) {
                MDXMembers mdxMembers;
                Object theNode = setIterator.next();
                if (theNode instanceof ILevel) {
                    BaseLevel currentBaseLevel = (BaseLevel)nodeFactory.createNode(1065);
                    currentBaseLevel.bind((ILevel)theNode);
                    mdxMembers = (MDXMembers)nodeFactory.createNode(1040);
                    mdxMembers.addChild(currentBaseLevel);
                    setFromSameHier.addChild(mdxMembers);
                    continue;
                }
                if (theNode instanceof IHierarchy) {
                    BaseHierarchy currentBaseHier = (BaseHierarchy)nodeFactory.createNode(1073);
                    currentBaseHier.bind((IHierarchy)theNode);
                    mdxMembers = (MDXMembers)nodeFactory.createNode(1040);
                    mdxMembers.addChild(currentBaseHier);
                    setFromSameHier.addChild(mdxMembers);
                    continue;
                }
                if (!(theNode instanceof AbstractMDXSetOperator)) continue;
                setFromSameHier.addChild((AbstractMDXSetOperator)theNode);
            }
        } else {
            Object theNode = nodesFromTheHier.get(0);
            if (theNode instanceof ILevel) {
                BaseLevel currentBaseLevel = (BaseLevel)nodeFactory.createNode(1065);
                currentBaseLevel.bind((ILevel)theNode);
                setFromSameHier = (MDXMembers)nodeFactory.createNode(1040);
                setFromSameHier.addChild(currentBaseLevel);
            } else if (theNode instanceof IHierarchy) {
                BaseHierarchy currentBaseHier = (BaseHierarchy)nodeFactory.createNode(1073);
                currentBaseHier.bind((IHierarchy)theNode);
                setFromSameHier = (MDXMembers)nodeFactory.createNode(1040);
                setFromSameHier.addChild(currentBaseHier);
            } else if (theNode instanceof AbstractMDXSetOperator) {
                setFromSameHier = (MDXSet)nodeFactory.createNode(1039);
                setFromSameHier.addChild((AbstractMDXSetOperator)theNode);
            }
        }
        AbstractMDXSet subSet = this.buildXJSetForProjectedDataitems(hierarchyLevelMap, iterator, nodeFactory);
        if (null != subSet) {
            MDXCrossjoin crossjoinSet = (MDXCrossjoin)nodeFactory.createNode(1030);
            crossjoinSet.addChild(setFromSameHier);
            crossjoinSet.addChild(subSet);
            return crossjoinSet;
        }
        return setFromSameHier;
    }

    private HashSet<IMember> colloctMeasuresAndExplicitMembers(Map<IHierarchy, List<Object>> hierarchySetMap, IXQEQueryNode node, IXQENodeFactory nodeFactory) {
        HashSet<IMember> uniqueMeasures = new HashSet<IMember>();
        Set<IHierarchy> iHierKeySet = hierarchySetMap.keySet();
        int[] memberTypes = new int[]{1067, 1077, 1076};
        IXQEQueryNode[] members = node.getDescendantsOfTypes(memberTypes, false);
        for (int i = 0; i < members.length; ++i) {
            AbstractMDXMember member = (AbstractMDXMember)members[i];
            IHierarchy mHier = member.getHierarchy();
            if (mHier.getDimension().isMeasuresDimension()) {
                if (member.getType() == 1067) {
                    uniqueMeasures.add(((BaseMember)member).getMember());
                    continue;
                }
                if (member.getType() != 1077) continue;
                uniqueMeasures.add(((MDXDefaultMember)member).getDefaultMember());
                continue;
            }
            List<Object> collectedProjectedItems = hierarchySetMap.get(mHier);
            if (null != collectedProjectedItems && collectedProjectedItems.get(0) instanceof IHierarchy && collectedProjectedItems.contains(mHier)) continue;
            ILevel mLevel = null;
            if (member.getType() == 1067 && !((BaseMember)member).isRootMember()) {
                mLevel = ((BaseMember)member).getLevel();
            }
            if (null != mLevel && null != collectedProjectedItems && collectedProjectedItems.contains(mLevel) || member.getType() == 1077 && !iHierKeySet.contains(mHier)) continue;
            boolean hierarchyResolved = false;
            if (member.getType() == 1077 && member.getParent().getType() == 1069) {
                IXQEQueryNode[] children = member.getParent().getChildrenOfType(1013);
                IHierarchy dmHier = ((MDXDefaultMember)member).getHierarchy();
                if (children.length > 0) {
                    hierarchyResolved = true;
                }
                block1: for (IXQEQueryNode childIt : children) {
                    MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)childIt;
                    MDXCalculatedMemberDefinition calcDef = calcRef.getDefinition();
                    Set<MDXHierInfo> veHierInfo = calcDef.getContextDependentValueExpressionHierarchyInfo(calcDef);
                    for (MDXHierInfo hierInfo : veHierInfo) {
                        if (hierInfo.projectsHierarchy(dmHier)) continue;
                        hierarchyResolved = false;
                        continue block1;
                    }
                }
                if (hierarchyResolved) continue;
            }
            boolean cached = false;
            AbstractMDXSet theMemberSet = null;
            IXQEQueryNode parent = member.getParent();
            if (parent != null && (parent.getType() == 1052 || parent.getType() == 1048)) {
                List<ILevel> projLevelsInFunction = ((AbstractMDXNode)parent).getLevelInfo().getProjectedLevels(mHier);
                if (collectedProjectedItems != null && member.getType() != 1076) {
                    for (ILevel iLevel : projLevelsInFunction) {
                        if (!collectedProjectedItems.contains(iLevel)) continue;
                        cached = true;
                        break;
                    }
                }
                if (!cached && member.getType() != 1076) {
                    theMemberSet = (AbstractMDXSet)parent;
                } else {
                    if (null == collectedProjectedItems) {
                        collectedProjectedItems = new ArrayList<Object>();
                    }
                    for (ILevel iLevel : projLevelsInFunction) {
                        if (collectedProjectedItems.contains(iLevel)) continue;
                        collectedProjectedItems.add(iLevel);
                    }
                    if (collectedProjectedItems.size() > 0) {
                        hierarchySetMap.put(mHier, collectedProjectedItems);
                    }
                }
            } else if (member.getType() != 1076 && !this.isCached(member, collectedProjectedItems, memberTypes)) {
                theMemberSet = (MDXSet)nodeFactory.createNode(1039);
                theMemberSet.addChild(nodeFactory.deepCopyNode(member));
                if (member.getType() == 1077 && !hierarchyResolved && node.getType() == 1002 && !mHier.isParentChild() && node.getPropertyValue(HAS_UNRESOLVED_DFM) == null) {
                    node.setPropertyValue(HAS_UNRESOLVED_DFM, Boolean.TRUE);
                }
            }
            if (theMemberSet == null) continue;
            if (null != collectedProjectedItems) {
                collectedProjectedItems.add(theMemberSet);
                continue;
            }
            collectedProjectedItems = new ArrayList<Object>();
            collectedProjectedItems.add(theMemberSet);
            hierarchySetMap.put(mHier, collectedProjectedItems);
        }
        return uniqueMeasures;
    }

    private boolean isCached(AbstractMDXMember member, List<Object> collectedProjectedItems, int[] memberTypes) {
        boolean cached = false;
        if (collectedProjectedItems == null || collectedProjectedItems.size() == 0) {
            return false;
        }
        if (member.getType() == 1067 && collectedProjectedItems.contains(((BaseMember)member).getLevel())) {
            return false;
        }
        if (member.getType() != 1076) {
            Iterator<Object> setIterator = collectedProjectedItems.iterator();
            block0: while (setIterator.hasNext() && !cached) {
                Object currentNode = setIterator.next();
                if (currentNode instanceof ILevel || !(currentNode instanceof MDXSet)) continue;
                List<AbstractMDXNode> membersInSameHier = ((MDXSet)currentNode).getDescendantsOfCategories(memberTypes, false, false, false, false, false);
                String memberExternalName = null;
                StringBuilder functionName = new StringBuilder();
                if (member.getType() == 1067) {
                    memberExternalName = ((BaseMember)member).getExternalName();
                } else {
                    ((MDXDefaultMember)member).writeFormattedText(functionName);
                    memberExternalName = functionName.toString();
                }
                for (IXQEQueryNode iXQEQueryNode : membersInSameHier) {
                    String externalName = null;
                    StringBuilder theFunctionName = new StringBuilder();
                    if (iXQEQueryNode.getType() == 1067) {
                        externalName = ((BaseMember)iXQEQueryNode).getExternalName();
                    } else {
                        ((MDXDefaultMember)member).writeFormattedText(theFunctionName);
                        externalName = theFunctionName.toString();
                    }
                    if (!externalName.equals(memberExternalName)) continue;
                    cached = true;
                    continue block0;
                }
            }
        }
        return cached;
    }

    private V5QuerySet createSubMDXQuery(IXQEQueryNode node, IXQENodeFactory nodeFactory, AbstractMDXSet crossjoinSet) {
        MDXQuery mdxQuery = (MDXQuery)node;
        V5QuerySet v5QuerySet = (V5QuerySet)nodeFactory.createNode(101002);
        v5QuerySet.addToIndex();
        MDXQuery subMdxQuery = (MDXQuery)nodeFactory.createNode(1002);
        subMdxQuery.setRefQueryProperty(QUERYNAME);
        MDXEdge subMdxEdge = (MDXEdge)nodeFactory.createNode(1006);
        this.propagateDimensionPropertiesToPrimingQueryEdge(subMdxEdge, mdxQuery);
        subMdxEdge.setEdgeID(0);
        subMdxEdge.setMDXNonEmptyProperty(true);
        subMdxEdge.addChild(crossjoinSet);
        subMdxQuery.addChild(subMdxEdge);
        MDXFromCube mdxFrom = mdxQuery.getMDXFrom();
        MDXFromCube subMdxFrom = (MDXFromCube)nodeFactory.deepCopyNode(mdxFrom);
        subMdxFrom.setHaveVariablesBeenRead(false);
        v5QuerySet.addChild(subMdxQuery);
        subMdxQuery.addChild(subMdxFrom);
        subMdxQuery.disableLocalSubMDXQueryRequest();
        mdxQuery.disableLocalSubMDXQueryRequest();
        subMdxQuery.setSuppressNulls(mdxQuery.getSuppressNulls());
        subMdxQuery.setforceLocalQueryProcessing(new Boolean(true));
        return v5QuerySet;
    }

    public static void logMDXQuery(MDXQuery mdxQuery) {
        if (mdxQuery != null && PRIMINGQUERYLOGGER.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            String newline = "\n";
            buffer.append("QueryName: ");
            String queryName = mdxQuery.getRefQueryProperty();
            buffer.append(queryName);
            RSAPIDataset rsapiDataset = (RSAPIDataset)mdxQuery.getAncestorOfType(401005);
            if (rsapiDataset != null) {
                buffer.append("\t").append("QRDName: ");
                String qrdName = rsapiDataset.getName();
                buffer.append(qrdName);
            }
            buffer.append(newline);
            String mdxText = mdxQuery.getMDX();
            buffer.append(mdxText).append(newline);
            PRIMINGQUERYLOGGER.log(buffer.toString());
        }
    }

    public void propagateDimensionPropertiesToPrimingQueryEdge(MDXEdge subMdxEdge, MDXQuery mdxQuery) {
        MDXEdge[] edges = mdxQuery.getEdges();
        MDXDimensionProperties dimProperties = subMdxEdge.getDimensionProperties();
        for (MDXEdge edge : edges) {
            dimProperties.addCustomerDimensionProperties(edge.getDimensionProperties());
        }
    }
}

