/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXNull;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeTrueFalse;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class RemoveComparisonToOutOfContextMDXProperty
extends Transformation {
    public static final String TRASNSFORAMTION_APPLIED = "RemoveComparisonToOutOfContextMDXPropertyApplied";

    public RemoveComparisonToOutOfContextMDXProperty() {
        this.mName = "Remove MDXComparisonOperator when any of its operands is an out of context CogMDXProperties.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1070};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXComparisonOperator mdxComparisonOperator = (MDXComparisonOperator)node;
        IXQEQueryNode[] children = mdxComparisonOperator.getChildren();
        MDXNull outOfContextProperty = null;
        int position = -1;
        for (IXQEQueryNode child : children) {
            ++position;
            if (child.getType() != 1089 || child.getPropertyValue("OutOfContextMDXProperty") == null) continue;
            outOfContextProperty = (MDXNull)child;
            String propertyName = (String)outOfContextProperty.getPropertyValue("OutOfContextMDXProperty");
            String refDataItem = (String)outOfContextProperty.getPropertyValue("refDataItem");
            MDXQuery mdxQuery = (MDXQuery)mdxComparisonOperator.getAncestorOfType(1002);
            int aSeverity = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_FilterUsesComparisonToOutOfContextMDXProperty, refDataItem, propertyName, mdxQuery.getRefQueryProperty()));
            break;
        }
        TNodeTrueFalse tNodeTrueFalse = null;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        switch (mdxComparisonOperator.getOperatorType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                boolean isNEQ = mdxComparisonOperator.getOperatorType() == 2;
                position = position == 0 ? 1 : 0;
                IXQEQueryNode otherOp = mdxComparisonOperator.getChild(position);
                if (otherOp.getType() == 1089) {
                    if (isNEQ) {
                        tNodeTrueFalse = MDXBuilder.buildTNodeTrueFalse(nodeFactory, false);
                        break;
                    }
                    tNodeTrueFalse = MDXBuilder.buildTNodeTrueFalse(nodeFactory, true);
                    break;
                }
                if (otherOp.getType() == 1064) {
                    MDXNumericConstant mdxNumericConstant = (MDXNumericConstant)otherOp;
                    if (mdxNumericConstant.couldResolveToZero()) {
                        if (isNEQ) {
                            tNodeTrueFalse = MDXBuilder.buildTNodeTrueFalse(nodeFactory, false);
                            break;
                        }
                        tNodeTrueFalse = MDXBuilder.buildTNodeTrueFalse(nodeFactory, true);
                        break;
                    }
                    if (isNEQ) {
                        tNodeTrueFalse = MDXBuilder.buildTNodeTrueFalse(nodeFactory, true);
                        break;
                    }
                    tNodeTrueFalse = MDXBuilder.buildTNodeTrueFalse(nodeFactory, false);
                    break;
                }
                if (otherOp.getType() != 1127) break;
                tNodeTrueFalse = MDXBuilder.buildTNodeTrueFalse(nodeFactory, false);
                break;
            }
            default: {
                tNodeTrueFalse = MDXBuilder.buildTNodeTrueFalse(nodeFactory, false);
            }
        }
        if (tNodeTrueFalse != null) {
            mdxComparisonOperator.getParent().exchangeChildNode(mdxComparisonOperator, tNodeTrueFalse);
        } else {
            mdxComparisonOperator.setPropertyValue(TRASNSFORAMTION_APPLIED, Boolean.TRUE);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] children;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(TRASNSFORAMTION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "RemoveComparisonToOutOfContextMDXProperty was already applied.", trace);
            return false;
        }
        for (IXQEQueryNode child : children = node.getChildren()) {
            if (child.getType() != 1089 || child.getPropertyValue("OutOfContextMDXProperty") == null) continue;
            this.traceNodeCondition(true, "Found a comparison operand which is an out of context MDX property.", trace);
            return true;
        }
        this.traceNodeCondition(false, "None comparison operand is an out of context MDX property.", trace);
        return false;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "edgeSuppression");
        trace.endElement();
    }
}

