/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.localprocessing.v5.V5SuppressRule;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveLocalSuppression
extends Transformation {
    public RemoveLocalSuppression() {
        this.mName = "Remove Local Suppression when pushed to the MDX query using NON_EMPTY.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode localSuppresion = node.getAncestorOfType(601022);
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int idx = localSuppresion.getNumberChildren() - 1; idx > 0; --idx) {
            V5SuppressRule suppressRule = (V5SuppressRule)localSuppresion.getChild(idx);
            for (int j = 0; j < edges.length; ++j) {
                if (!suppressRule.getEdgeName().equals(edges[j].getV5Name()) || !edges[j].getMDXNonEmptyProperty() || suppressRule.getDivByZero() || suppressRule.getOverflow() || suppressRule.getZero()) continue;
                suppressRule.extract();
            }
        }
        if (localSuppresion.getNumberChildren() == 1) {
            localSuppresion.extract();
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode localSuppresion = node.getAncestorOfType(601022);
        if (localSuppresion == null) {
            this.traceQueryCondition(false, "No local suppression applied to this MDX Query.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXEdge[] edges = mdxQuery.getEdges();
        for (int idx = 1; idx < localSuppresion.getNumberChildren(); ++idx) {
            V5SuppressRule suppressRule = (V5SuppressRule)localSuppresion.getChild(idx);
            for (int j = 0; j < edges.length; ++j) {
                if (!suppressRule.getEdgeName().equals(edges[j].getV5Name()) || !edges[j].getMDXNonEmptyProperty() || suppressRule.getDivByZero() || suppressRule.getOverflow() || suppressRule.getZero()) continue;
                this.traceQueryCondition(true, "No null local suppression applied to any MDX Edge having NON_EMPTY.x", trace);
                return true;
            }
        }
        this.traceQueryCondition(false, "No null local suppression applied to any MDX Edge having NON_EMPTY.", trace);
        return false;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "edgeSuppression");
        trace.endElement();
    }
}

