/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveMDXFunctionsOnSingleMember
extends Transformation {
    public RemoveMDXFunctionsOnSingleMember(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Remove MDX function when applied on a set containing a single member.";
        this.mTypes = new int[]{1058, 1037, 1042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode firstChild = node.detachChild(0);
        node.getParent().exchangeChildNode(node, firstChild, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 1 || node.getNumberChildren() > 1 && node.getType() == 1058) {
            IXQEQueryNode childNode = node.getChild(0);
            if (childNode.isOfCategory(1004)) {
                childNode = childNode.getChild(0);
            }
            if (this.containsSet(childNode) && this.containsSingleMember(childNode)) {
                this.traceNodeCondition(true, "We do not need the MDX function.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "We cannot remove the MDX function.", trace);
        return false;
    }

    private boolean containsSet(IXQEQueryNode childNode) {
        return childNode.getType() == 1039;
    }

    private boolean containsSingleMember(IXQEQueryNode childNode) {
        IXQEQueryNode nextChildNode;
        return childNode.getNumberChildren() == 1 && ((nextChildNode = childNode.getChild(0)).isOfCategory(1067) || nextChildNode.getType() == 1067);
    }
}

