/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTESharedPassNumbers;

public class ReplaceCountOnCalculatedMemberSetWithConstant
extends Transformation {
    public ReplaceCountOnCalculatedMemberSetWithConstant(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace Count on member set with constant.";
        this.mTypes = new int[]{1087};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCount mdxCount = (MDXCount)node;
        IXQEQueryNode mdxSet = mdxCount.getChild(0);
        int value = mdxSet.getNumberChildren();
        MDXNumericConstant constant = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)environment.getNodeFactory(), value);
        node.getParent().exchangeChildNode(node, constant, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        MDXCount mdxCount = (MDXCount)node;
        IXQEQueryNode mdxSet = mdxCount.getChild(0);
        if (mdxCount.includeEmpty() && mdxSet.getType() == 1039) {
            status = true;
            for (IXQEQueryNode child : mdxSet.getChildren()) {
                if (child.isOfCategory(1013)) continue;
                status = false;
                break;
            }
        }
        if (status) {
            this.traceNodeCondition(status, "The expression is matching the transformation input pattern.", trace);
        } else {
            this.traceNodeCondition(status, "The expression is not matching the transformation input pattern.", trace);
        }
        return status;
    }
}

