/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class ReplaceCountOnEmptySetWithZero
extends Transformation {
    public ReplaceCountOnEmptySetWithZero(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace Count On Empty Set With Zero";
        this.mTypes = new int[]{1087};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXNumericConstant mdxNumericConstant = MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 0);
        node.getParent().exchangeChildNode(node, mdxNumericConstant, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target MDXCount node are invalid.", trace);
            return false;
        }
        if (node.getDescendantsOfType(1004, false).length > 0) {
            this.traceNodeCondition(false, "The target node has a descendant which is a set alias definition.", trace);
            return false;
        }
        if (((AbstractMDXSet)node.getChild(0)).getType() == 1145) {
            this.traceNodeCondition(true, "The first operand of the MDXCount node is an empty set.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The first operand of the MDXCount node will not evaluate to an empty set.", trace);
        return false;
    }
}

