/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ReplaceFunctionOnNullWithNull
extends Transformation {
    private static int[] applicableTypes = new int[]{1016};

    public ReplaceFunctionOnNullWithNull() {
        this.mName = "Replace a function call on a null object with null";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1089};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        node.getParent().getParent().exchangeChildNode(node.getParent(), factory.createNode(1089), false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.getParent().isOfTypes(applicableTypes)) {
            this.traceNodeCondition(false, "The function is not one of the applicable types.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Function can be replaced with null.", trace);
        return true;
    }
}

